/************************************************************************/
/*									*/
/*		auxdmain.c						*/
/*									*/
/*	General routines for auxilliary definitions package		*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "auxd_local.h"





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/


static	Boolean 	auxd_inited = FALSE;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	AUXD_init -- package initialization				*/
/*									*/
/************************************************************************/


void
AUXD_init()
{
   PROT_INIT;
   PROTECT;
   if (!auxd_inited) {
      auxd_inited = TRUE;
      AUXD_info_init();
      AUXD_syn_init();
    }
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	AUXD_error -- handle error messages for this module		*/
/*									*/
/************************************************************************/


void
AUXD_error(fmt,a1,a2,a3)
   String fmt;
   Universal a1,a2,a3;
{
   Character buf[256];

   sprintf(buf,fmt,a1,a2,a3);

   fprintf(stderr,"AUXD: %s\n",buf);
   fflush(stderr);

   exit(1);
};





/* end of auxdmain.c */
