/************************************************************************/
/*									*/
/*		auxd_local.h						*/
/*									*/
/*	Local definitions for auxilliary definitions package		*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#include <DATATYPES.h>
#include <bwethread.h>

#include <sequence.h>
#include "auxd.h"





/************************************************************************/
/*									*/
/*	Local definitions						*/
/*									*/
/************************************************************************/


extern	SEMAPHORE	AUXD__sema;

#define PROT_DECL	SEMAPHORE AUXD__sema
#define PROT_INIT AUXD__sema = (USE_THREADS ? THREADseminit(1) : NULL)
#define PROTECT   if (AUXD__sema != NULL) THREADpsem(AUXD__sema)
#define UNPROTECT if (AUXD__sema != NULL) THREADvsem(AUXD__sema)




/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/


typedef struct _AUXD_FIELD *	AUXD_FIELD;

typedef enum {
   TYPE_UNDEFINED,
   TYPE_INTEGER,
   TYPE_FLOAT,
   TYPE_STRING
} AUXD_TYPE;



typedef struct _AUXD {
   String	name;
   Boolean	listfg;
   AUXD 	next;
   AUXD 	nextalt;
   AUXD 	son;
   AUXD 	inherit;
   AUXD_FIELD	field;
} AUXD_INFO;





typedef union  _AUXD_VALUE {
   Integer   intval;
   String    strval;
   Float*    fltval;
   Sequence  seqval;
} AUXD_VALUE;





typedef struct _AUXD_FIELD {
   String	name;
   AUXD_TYPE	type;
   Boolean	listfg;
   AUXD_FIELD	next;
   AUXD_VALUE	value;
} AUXD_FIELD_INFO;


#define int_value	value.intval
#define str_value	value.strval
#define flt_value	value.fltval
#define seq_value	value.seqval




/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


extern	void		AUXD_init();
extern	void		AUXD_error();

extern	void		AUXD_info_init();

extern	void		AUXD_syn_init();
extern	AUXD		AUXD_new_auxd();
extern	AUXD_FIELD	AUXD_add_field();




/* end of auxd_local.h */
