/************************************************************************/
/*									*/
/*		auxd.h							*/
/*									*/
/*	Definitions for auxilliary definitions module			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define AUXD_STRING_CHAR	'`'





/************************************************************************/
/*									*/
/*	Class Definitions						*/
/*									*/
/************************************************************************/


typedef struct _AUXD *		AUXD;





/************************************************************************/
/*									*/
/*	Entry Points							*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	AUXD		AUXDget_handle();
extern	AUXD		AUXDnext_handle();
extern	char *		AUXDget_info();
extern	int		AUXDget_info_int();
extern	double		AUXDget_info_real();
extern	int		AUXDget_defined();
extern	int		AUXDget_info_list();
extern	int		AUXDget_info_list_int();
extern	int		AUXDget_info_list_real();
extern	char *		AUXDdecode();

extern	void		AUXDuse();

#else

extern "C" {
	AUXD		AUXDget_handle(AUXD,char *);
	AUXD		AUXDnext_handle(AUXD);
	char *		AUXDget_info(AUXD,char *);
	int		AUXDget_info_int(AUXD,char *);
	double		AUXDget_info_real(AUXD,char *);
	int		AUXDget_defined(AUXD,char *);
	int		AUXDget_info_list(AUXD,char *,int,char **);
	int		AUXDget_info_list_int(AUXD,char *,int,int *);
	int		AUXDget_info_list_real(AUXD,char *,int,double *);
	char *		AUXDdecode(char *,int,char *);

	void		AUXDuse(char *);
};

#endif




/* end of auxd.h */




