/*
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/

**-----------------------------------------------------------------------------
**
** face.c - Assignment 1, CS123
**
** Rob Boyer
** Account: CS123081
**
**-----------------------------------------------------------------------------
*/

#include <ash.h>

/*
**  define some macros to map from a 100x100 coordinate system with the
**  origin at (0,0)
*/

#define mapx(x) ((x + 100) * right_x)/200
   /* convert and scale to window size, x value */
#define mapy(y) ((100 - y) * bot_y)/200
   /* convert and scale to window size, y value */
#define scalex(x) (x * right_x/200)
  /* scale x distance to coordinate system */
#define scaley(y) (y * bot_y/200)
   /* scale y distance to coordinate system */

/*
**  define some macros to set colors
*/

#define set_fcolor(w,color) ASHcolor( w ,ASHlookup_color( w , color))
#define set_bcolor(w,color) ASHbackground_color(w,ASHlookup_color(w, color))

/*
**  define some useful constants
*/

#define LEFT 0
#define RIGHT 1
#define LOW 1
#define HIGH 2
#define TRUE 1
#define FALSE 0

#define STARTING_PATTERN 40
#define BERET_PATTERN STARTING_PATTERN
#define LIP_PATTERN STARTING_PATTERN+1
#define EYE_PATTERN STARTING_PATTERN+2
#define TIE_PATTERN STARTING_PATTERN+3
#define BOT_F_PATTERN STARTING_PATTERN+4
#define TOP_F_PATTERN STARTING_PATTERN+5

#define MEDIUM_JOIN_LINE 10
#define DASHED_JOIN_LINE 11
#define THICK_JOIN_LINE 12
#define MEDIUM_SOLID_LINE 13
#define ARROW_LINE 14

/*
**  Static storage
*/

static ASH_WINDOW f;
static int left_x,bot_y,right_x,top_y;
static int resizing;
static int sx[10],sy[10];	       /* working array for points */
/*
** routines defined in this module (besides main:):
*/

void face_refresh();
ASH_CONTROL_FUNCTION async_msg();
void draw_ear(),draw_eye(),draw_hat(),draw_face();
void build_patterns();


/*
**----------------------------------------------------------------------------
**
** main module. execution starts here..
**
**----------------------------------------------------------------------------
*/

main(argc,argv)
     int argc;
     char **argv;
{
  int new_count;
/*  ASHtrace(ASH_TRACE_ON);  */
  resizing = FALSE;
  new_count = ASHset_application(argc,argv); /* get command line arguments */
  f = ASHinit(ASH_MODE_INQUIRE);   /* user explicitly sets size */
  ASHset_refresh(f,face_refresh);  /* set a handler for refresh */
  ASHset_control(f,async_msg);	   /* set an event handler for */
					     /*   control events */
  build_patterns();			     /* build the fill patterns */
					     /*   and line styles */
  draw_face();				     /* draw the face */
  RIPuser_pick(0);			     /* wait for something to happen*/
}





/*
**----------------------------------------------------------------------------
**
**  face_refresh function called by ASH or X whenever refreshing needs to be done.  draw_face is
**  called to re-draw the face using the current coordinate system
**
**-----------------------------------------------------------------------------
*/

void face_refresh(wind)
     ASH_WINDOW wind;
{
  draw_face();
}

/*
**-----------------------------------------------------------------------------
**
**  ASH_Control function - we will do some fancy operations on the eyes when
**    the mouse pointer enters and exits our window...
**
**-----------------------------------------------------------------------------
*/

ASH_CONTROL_FUNCTION async_msg(msg,wind)
     char *msg;
     ASH_WINDOW wind;
{
  printf("\nin asynch_msg, msg = %s", msg);
  if ( !strcmp(msg,"ASH$ENTER") ) {
    if (!resizing) {
      draw_eye(LEFT,HIGH);
      draw_eye(RIGHT,HIGH);
    }
  } else if ( !strcmp(msg,"ASH$EXIT") ) {
    if (!resizing) {
      draw_eye(LEFT,LOW);
      draw_eye(RIGHT,LOW);
    }
  } else if ( !strcmp(msg, "ASH$INQ_RESIZE")) {
    resizing = TRUE;
  } else if ( !strcmp(msg, "ASH$RESIZE")) {
    resizing = FALSE;
  }
  return 0;
}

/*
**----------------------------------------------------------------------------
**
**  draw_face - draws it all
**
**----------------------------------------------------------------------------
*/

void draw_face()
{
  ASHinq_size(f,ASH_SIZE_WINDOW,&left_x,&bot_y,&right_x,&top_y);
  set_fcolor( f, "wheat");
  set_bcolor( f, "gray");
  ASHfill(f,ASH_FILL_DARK_HALFTONE);
  ASHround_rectangle(f,mapx(-75),mapy(-85), mapx(75),mapy(85),
    scalex(75),scaley(85));

/*
** Draw the ears using filled splines
*/
  draw_ear(LEFT);
  draw_ear(RIGHT);

/*
** Draw the eyes using elipses and circles
*/

  draw_eye(LEFT,0);
  draw_eye(RIGHT,0);

/*
** Draw some glasses using thick lines, arcs...
*/

  set_fcolor(f,"orange");
  ASHline_style(f,THICK_JOIN_LINE);
  ASHline(f,  mapx( -75 ),mapy( 16),	mapx( -62 ),mapy( 14));
  ASHline(f,  mapx( -62 ),mapy( 14),  mapx(  62 ),mapy( 14));
  ASHline(f,  mapx(  62 ),mapy( 14),  mapx(  75 ),mapy( 16));
  ASHarc(f, mapx( -34), mapy( 14),  scalex(28),scaley(28) ,
	 180*64, 180*64);
  ASHarc(f, mapx(34),mapy( 14), scalex(28),scaley(28), 180*64,180*64);


/*
** Draw the nose using some thin lines
*/
  set_fcolor(f,"black");
  ASHline_style(f,ASH_STYLE_SOLID);
  ASHspline_arc(f,mapx(-4),mapy(-5), mapx(-27),mapy(-40),mapx(27),mapy(-40),
		mapx(4),mapy(-5 ));

/*
** Draw the mouth using chords and a user-defined fill pattern
*/

  set_fcolor(f, "red");
  ASHfill(f,LIP_PATTERN);
  ASHarc_chord(f,mapx(0),mapy(-120), scalex(120),scaley(85),  65*64, 50*64);
  ASHarc_chord(f,mapx(0),mapy( 34),  scalex(120),scaley(85), -65*64,-50*64);

/*
** Draw a hat using a filled spline and another user-defined fill pattern
*/
  draw_hat();

/*
** Draw the shoulders and a collar using a user-defined line style
*/
  ASHline_style(f,MEDIUM_JOIN_LINE);

  sx[0] = mapx(-33);
  sy[0] = mapy( -80 );

  sx[1] = mapx(- 50);
  sy[1] = mapy( -88 );

  sx[2] = mapx( 0 );
  sy[2] = mapy( -92 );

  sx[3] = mapx(  50);
  sy[3] = mapy( -88 );

  sx[4] = mapx(  33);
  sy[4] = mapy( -80);

  set_fcolor(f,"aquamarine");
  ASHpolyline(f,5,sx,sy);

  sx[0] = mapx(-80);
  sy[0] = mapy(-95);

  sx[1] = mapx(-25);
  sy[1] = mapy(-88);
  ASHspline(f,2,sx,sy);

  sx[0] = mapx( 80);
  sy[0] = mapy(-95);

  sx[1] = mapx( 25);
  sy[1] = mapy(-88);
  ASHspline(f,2,sx,sy);


/*
** Draw a bow-tie using a user-defined fill patterm
*/

  sx[0] = mapx( -35 );
  sy[0] = mapy( -80 );

  sx[1] = mapx( -35 );
  sy[1] = mapy( -98 );

  sx[2] = mapx(   0 );
  sy[2] = mapy( -92 );

  sx[3] = mapx(  35 );
  sy[3] = mapy( -80 );

  sx[4] = mapx(  35 );
  sy[4] = mapy( -98 );

  ASHfill(f,TIE_PATTERN);
  set_fcolor(f,"yellow");
  set_bcolor(f,"forestgreen");
  ASHgeneral_polygon(f,5,sx,sy);

/*
** Draw some whiskers
*/

  ASHline_style(f,ASH_STYLE_THICK_DASHED);
  set_fcolor(f,"black");
  ASHspline_arc( f,
		mapx(-25),mapy(-60), mapx(-27),mapy(-70), mapx(-20),mapy(-75), mapx(-1),mapy(-85));
  ASHspline_arc( f,
		mapx(-20),mapy(-60), mapx(-17),mapy(-65), mapx(-20),mapy(-78), mapx(-0),mapy(-85));
  ASHspline_arc( f,
		mapx(-17),mapy(-60), mapx(-18),mapy(-72), mapx(-10),mapy(-76), mapx(-1),mapy(-86));
  ASHspline_arc( f,
		mapx(-10),mapy(-60), mapx( -8),mapy(-68), mapx(-12),mapy(-71), mapx( 0),mapy(-86));
  ASHspline_arc( f,
		mapx( -5),mapy(-59), mapx( -6),mapy(-67), mapx( -5),mapy(-75), mapx(1),mapy(-85));
  ASHspline_arc( f,
		mapx( -2),mapy(-60), mapx(-2),mapy(-70), mapx(-1),mapy(-74), mapx(0),mapy(-85));
  ASHspline_arc( f,
		mapx(25),mapy(-60), mapx(27),mapy(-70), mapx(20),mapy(-75), mapx(1),mapy(-85));
  ASHspline_arc( f,
		mapx(20),mapy(-60), mapx(17),mapy(-65), mapx(20),mapy(-78), mapx(0),mapy(-85));
  ASHspline_arc( f,
		mapx(17),mapy(-60), mapx(18),mapy(-72), mapx(10),mapy(-76), mapx(0),mapy(-86));
  ASHspline_arc( f,
		mapx(10),mapy(-60), mapx( 8),mapy(-68), mapx(12),mapy(-71), mapx(0),mapy(-86));
  ASHspline_arc( f,
		mapx( 5),mapy(-59), mapx( 6),mapy(-67), mapx( 5),mapy(-75), mapx(-1),mapy(-85));
  ASHspline_arc( f,
		mapx( 2),mapy(-60), mapx(2),mapy(-70), mapx(1),mapy(-74), mapx(1),mapy(-85));

/*
** Write some identifying text
*/

  ASHtext_color(f,ASHlookup_color(f,"blueviolet"));
  ASHtext(f, mapx(-98), mapy(-80), "Rob Boyer");
  ASHtext(f, mapx(-98), mapy(-85), "CS123081");

}

/*
**----------------------------------------------------------------------------------------------------
**
**  draw_ear - draw left or right ear depending on the input parameter
**
**----------------------------------------------------------------------------------------------------
*/

void draw_ear(side)
int side;
{
  int xmul=1;
  if (side==LEFT) xmul = -1;

  sx[0] = mapx( xmul * -72);
  sy[0] = mapy( 20 );

  sx[1] = mapx( xmul * -90  );
  sy[1] = mapy( 25);

  sx[2] = mapx( xmul * -80  );
  sy[2] = mapy( -15 );

  sx[3] = mapx( xmul * -85  );
  sy[3] = mapy( -35 );

  sx[4] = mapx( xmul * -72  );
  sy[4] = mapy( -35 );

  sx[5] = mapx( xmul * -72  );
  sy[5] = mapy( 20 );

/*ASHspline_filled(f,5,sx,sy);		ABORTS xnews */
  ASHpolygon(f,5,sx,sy);

}

/*
**----------------------------------------------------------------------------------------------------
**
**  draw_eye - draw left or right eye and eyebrow depending on the input parameter.
**
**----------------------------------------------------------------------------------------------------
*/
  void draw_eye( side, pos )
  int side,pos;
{
  int xmul = 1;
  if (side==LEFT)xmul=-1;

  if ( pos ) goto skip;
  set_fcolor(f, "white");
  ASHfill(f,ASH_FILL_SOLID);
  ASHfilled_ellipse(f,mapx(xmul*33),mapy(0),scalex(16),scaley(10));
  ASHfill(f,EYE_PATTERN);
  set_fcolor(f, "blue" );
  ASHfilled_circle(f,mapx( xmul*33 ), mapy(-2), scalex(9));
  pos = LOW;

/*
**  if the routine is called with the LOW argument, then erase the eyebrows at the high
**  position and draw them in the lower position.  If called with the HIGH argument, do
**  the reverse.  A primitive animation results when the mouse pointer is moved in and out
**  of the window.
*/

skip:
    if (pos == LOW) {
    set_fcolor( f, "wheat");
    set_bcolor( f, "gray");
    ASHfill(f,ASH_FILL_DARK_HALFTONE);
    ASHline_style(f,MEDIUM_SOLID_LINE);
    ASHarc( f, mapx(xmul*33), mapy(0), scalex(25), scaley(11), 58*64, 104*64);

    ASHline_style(f,MEDIUM_JOIN_LINE);
    ASHfill(f,EYE_PATTERN);
    set_fcolor( f, "black");
    ASHarc( f, mapx(xmul*33), mapy(0), scalex(25), scaley(9), 60*64, 100*64);

  } else {

    set_fcolor( f, "wheat");
    set_bcolor( f, "gray");
    ASHfill(f,ASH_FILL_DARK_HALFTONE);
    ASHline_style(f,MEDIUM_SOLID_LINE);
    ASHarc( f, mapx(xmul*33), mapy(0), scalex(25), scaley(9), 58*64, 104*64);
    ASHline_style(f,MEDIUM_JOIN_LINE);
    set_fcolor( f,"black");
     ASHfill(f,EYE_PATTERN);
     ASHarc( f, mapx(xmul*33), mapy(0), scalex(25), scaley(11), 60*64, 100*64);
  }
}

/*
**----------------------------------------------------------------------------------------------------
**
**  draw the beret-style hat usping filled splines
**
**----------------------------------------------------------------------------------------------------
*/

void draw_hat()
  {
  set_fcolor(f,"brown");

  sx[0] = mapx(0);
  sy[0] = mapy(25);

  sx[1] = mapx(-90 );
  sy[1] = mapy( 60 );

  sx[2] = mapx(-10  );
  sy[2] = mapy( 98 );

  sx[3] = mapx( 0 );
  sy[3] = mapy( 81 );

  sx[4] = mapx( 20 );
  sy[4] = mapy( 94 );

  sx[5] = mapx( 97 );
  sy[5] = mapy( 64 );

  ASHfill(f,BERET_PATTERN);
/*ASHspline_filled(f,6,sx,sy);		*/
  ASHpolygon(f,6,sx,sy);
}


/*
**------------------------------------------------------------------------------------------
**
** build_patterns - build the fill patterns and line styles for the face
**
**------------------------------------------------------------------------------------------
*/

void build_patterns() {

  static short pats[6][16] = {
    { 0x9999, 0x9999, 0xb9b9, 0xb9b9, 0xbbbb, 0xbbbb, 0xb9b9, 0xb9b9,
	0x9999, 0x9999, 0xb9b9, 0xb9b9, 0xbbbb, 0xbbbb, 0xb9b9, 0xb9b9	},

    { 0x0101, 0x0303, 0x0707, 0x0f0f, 0x1f1f, 0x3f3f, 0x7f7f, 0xffff,
      0xffff, 0x7f7f, 0x3f3f, 0x1f1f, 0x0f0f, 0x0707, 0x0303, 0x0101},

    { 0xffff, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0x0000,
      0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000 },

    { 0x0000, 0x1111, 0x3333, 0x7777, 0xffff, 0x7777, 0x3333, 0x1111,
      0xffff, 0x7777, 0x3333, 0x1111, 0x0000, 0x1111, 0x3333, 0x7777 },

    { 0x8000, 0x4000, 0x2000, 0x1000, 0x0800, 0x0400, 0x0200, 0x0100,
      0x0080, 0x0040, 0x0020, 0x0010, 0x0008, 0x0004, 0x0002, 0x0001},

    { 0x0001, 0x0002, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080,
      0x0100, 0x0200, 0x0400, 0x0800, 0x1000, 0x2000, 0x4000, 0x8000} };

  ASHfill_table(STARTING_PATTERN, 6, pats );

  ASHline_table(MEDIUM_JOIN_LINE, 5, 0, 2, 2, 0, 0);
  ASHline_table(DASHED_JOIN_LINE, 3, 0, 2, 2, 1, 4, 2, 4, 6, 4);
  ASHline_table(THICK_JOIN_LINE, 15, 2, 1, 2, 1, 2, 6, 3);
  ASHline_table(MEDIUM_SOLID_LINE, 5, 0, 1, 2, 1, 1, 6);
  ASHline_table(ARROW_LINE, 8, 2, 1, 2, 1, 3, 1, 7, 1);

}


