/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include "/pro/bwe/include/ash.h"
#include "/pro/bwe/include/willow.h"
#include "/pro/bwe/include/leaf.h"
#include "/pro/bwe/include/stem.h"

#define NULL 0
#define TRUE 1

static	int	window_init();
static	void	subwin_init();
static	int	subwin_draw();
static	int	inner_draw();
static	int	btn_press();
static	void	field_setup();
static	int	stem_press();



/************************************************************************/
/*									*/
/*	Stem tables							*/
/*									*/
/************************************************************************/


#define FILE_MENU	"File"
#define TOP_MENU	"Top"
#define EDIT_MENU	"Edit"
#define PROP_MENU	"Props"

static	STEM_PDM_DATA	pdm_menu[] = {
   { STEM_PSTATE_MENU, FILE_MENU },
      { STEM_PSTATE_BTN, "Finer Grid", btn_press },
      { STEM_PSTATE_BTN, "Courser Grid", btn_press },
      { STEM_PSTATE_BTN, "Show Grid", btn_press },
      { STEM_PSTATE_BTN, "Clear", btn_press },
      { STEM_PSTATE_BTN, "Remove", btn_press },
      { STEM_PSTATE_BTN, "Save", btn_press },
      { STEM_PSTATE_BTN, "Restart", btn_press },
   { STEM_PSTATE_MENU, TOP_MENU },
      { STEM_PSTATE_BTN, "Default", btn_press },
      { STEM_PSTATE_BTN, "Tiled", btn_press },
      { STEM_PSTATE_BTN, "Layout", btn_press },
      { STEM_PSTATE_BTN, "Box", btn_press },
      { STEM_PSTATE_BTN, "Arc", btn_press },
      { STEM_PSTATE_BTN, "Ignore", btn_press },
      { STEM_PSTATE_BTN, "Next Alternative", btn_press },
      { STEM_PSTATE_BTN, "First Alternative", btn_press },
      { STEM_PSTATE_BTN, "New Alternative", btn_press },
      { STEM_PSTATE_BTN, "Set Conditions", btn_press },
   { STEM_PSTATE_MENU, EDIT_MENU },
      { STEM_PSTATE_BTN, "Box", btn_press },
      { STEM_PSTATE_BTN, "Layout", btn_press },
      { STEM_PSTATE_BTN, "Field", btn_press },
      { STEM_PSTATE_BTN, "Pointer", btn_press },
      { STEM_PSTATE_BTN, "Empty", btn_press },
   { STEM_PSTATE_MENU, PROP_MENU },
      { STEM_PSTATE_BTN, "Options", btn_press },
   { STEM_PSTATE_END }
};





/************************************************************************/
/*									*/
/*	Leaf tables							*/
/*									*/
/************************************************************************/


#define STEM_WINDOW	1
#define FIELD_WINDOW	2
#define LEFT_PANE	3
#define RIGHT_PANE	4
#define BOT_WINDOW	5

#define FILL_STYLE	3



static LEAF_DATA	test_leaf[] = {
   LEAF_ROOT(NULL),
   { STEM_WINDOW, LEAF_TYPE_PDM,
	{ LEAF_COORD_LX, LEAF_COORD_TEXT_LINE,
	     LEAF_COORD_RX, LEAF_COORD_TY },
	NULL, NULL },
   { LEFT_PANE, LEAF_TYPE_SHADE,
	{ LEAF_COORD_LX, LEAF_COORD_BY,
	    LEAF_COORD_SIZE_LINE(15), LEAF_COORD_NEXT(STEM_WINDOW) },
	NULL, FILL_STYLE },
   { RIGHT_PANE, LEAF_TYPE_SHADE,
	{ LEAF_COORD_SIZE_LINE(15), LEAF_COORD_BY,
	    LEAF_COORD_RX, LEAF_COORD_NEXT(STEM_WINDOW) },
	NULL, FILL_STYLE },
   { BOT_WINDOW, LEAF_TYPE_WINDOW,
	{ LEAF_COORD_NEXT(LEFT_PANE), LEAF_COORD_BY,
	     LEAF_COORD_NEXT(RIGHT_PANE), LEAF_COORD_REL_LINE(50) },
	NULL, FILL_STYLE },
   { FIELD_WINDOW, LEAF_TYPE_STEM,
	{ LEAF_COORD_NEXT(LEFT_PANE), LEAF_COORD_NEXT(BOT_WINDOW),
	     LEAF_COORD_NEXT(RIGHT_PANE), LEAF_COORD_NEXT(STEM_WINDOW) },
	stem_press, NULL },
   LEAF_END
};




/************************************************************************/
/*									*/
/*	Willow tables							*/
/*									*/
/************************************************************************/


static	WILLOW_DEFN	template = {
   WILLOW_CLASS_USER_THREAD,
   { "Test", "old_english.36", 'T' },
   { 0 },
   { ASH_WINDOW_NOSAVE, WILLOW_TITLE_TAB_SENSE, WILLOW_INSTANCE_SAVED },
   window_init,
   NULL,
   { { { "Move", "pecan.icons", '1', 0, 0, 1 },
       WILLOW_LOCATION_UL,
       WILLOW_BUTTON_NORMAL,
       WILLOW_ACTION_MOVE(DOWN) },
     { { "Size", "pecan.icons", '0', 0, 0, 1 },
       WILLOW_LOCATION_UR,
       WILLOW_BUTTON_NORMAL,
       WILLOW_ACTION_TYPE_AUX8, NULL, WILLOW_ACTION_DOWN },
     { { "Size1", "pecan.icons", '0', 0, 0, 1 },
       WILLOW_LOCATION_LR,
       WILLOW_BUTTON_NORMAL,
       WILLOW_ACTION_TYPE_AUX8, NULL, WILLOW_ACTION_DOWN },
     { { "Size2", "pecan.icons", '0', 0, 0, 1 },
       WILLOW_LOCATION_LL,
       WILLOW_BUTTON_NORMAL,
       WILLOW_ACTION_TYPE_AUX8, NULL, WILLOW_ACTION_DOWN },
     { { "Move1" },
       WILLOW_LOCATION_BOTTOM,
       WILLOW_BUTTON_NOSHOW,
       WILLOW_ACTION_MOVE(DOWN) },
     { { "Remove" },
       WILLOW_LOCATION_TITLE,
       WILLOW_BUTTON_NORMAL,
       WILLOW_ACTION_ICON(DEFAULT) },
     { { "Push" },
       WILLOW_LOCATION_TITLE,
       WILLOW_BUTTON_NORMAL,
       WILLOW_ACTION_PUSH(DEFAULT) },
     { { "Pop" },
       WILLOW_LOCATION_ANY,
       WILLOW_BUTTON_NOSHOW,
       WILLOW_ACTION_POP(DEFAULT) },
   }
};



main(argc,argv)
   int argc;
   char * argv[];
{
   argc = ASHset_application(argc,argv);

   if (argc == 2)
      ASHinit(ASH_MODE_DISPLAY);
   else if (argc == 3)
      ASHinit(ASH_MODE_WINDOW);
   else
      ASHinit(ASH_MODE_INQUIRE);

   WILLOWdefine(NULL,NULL,NULL);

   WILLOWdefine_window(&template);

   WILLOWdraw();

   for ( ; ; ) {
      RIPuser_pick(0);
    };
};


static
window_init(w)
   ASH_WINDOW w;
{
   ASH_WINDOW sw;

   LEAFsetup_window(w,test_leaf,NULL);
   LEAFredraw(w);

   sw = LEAFinq_window(w,STEM_WINDOW,0);
   STEMpdm_define(sw,NULL,pdm_menu);

   sw = LEAFinq_window(w,FIELD_WINDOW,0);
   field_setup(sw);

   sw = LEAFinq_window(w,BOT_WINDOW,0);
   subwin_init(sw);
};






static void
subwin_init(w)
   ASH_WINDOW w;
{
   int lx,by,rx,ty;
   static int ct = 0;
   char buf[16];
   ASH_WINDOW nw;

   sprintf(buf,"Clk_%d",++ct);
   ASHinq_size(w,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);
   nw = ASHcreate(w,(3*lx+rx)/4,(3*by+ty)/4,0,0,abs(rx-lx)/2,abs(ty-by)/2,4,
		     ASH_WINDOW_VISIBLE);
   ASHfill(nw,3);
   ASHinq_size(nw,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);
   ASHrectangle(nw,lx,by,rx,ty);
   BIOnew_input_window(nw);
   ASHset_window_name(ASHinq_parent(w),buf);
   ASHset_refresh(w,subwin_draw);
};






static int
subwin_draw(w)
   ASH_WINDOW w;
{
   int lx,by,rx,ty;
   static int ct = 0;
   char buf[16];

   ASHinq_size(w,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);

   ASHline(w,lx,by,rx,ty);
   ASHline(w,lx,ty,rx,by);
   ASHtext(w,lx+3,by+3,"12345");
};





static int
inner_draw(w)
   ASH_WINDOW w;
{
   int lx,by,rx,ty;

   ASHinq_size(w,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);
   ASHrectangle(w,lx,by,rx,ty);
};




static int
btn_press(d,menu,btn)
   int d;
   char * menu;
   char * btn;
{
   printf("Call to %s button of %s menu\n",btn,menu);

   return 1;
};



static void
field_setup(w)
   ASH_WINDOW w;
{
   STEM_BUTTON btns[16];
   char buf[16][32];
   int i;

   for (i = 0; i < 15; ++i) {
      sprintf(buf[i],"Stem button %d",i);
      btns[i].name = buf[i];
      btns[i].flags = STEM_FLAG_NORMAL;
   };

   btns[i].name = 0;

   STEMrefresh(w,btns);
};




static int
stem_press(d,btn,rbtn,w)
   int d;
   int btn;
   int rbtn;
   ASH_WINDOW w;
{
   printf("Field button %d hit with flags 0x%x\n",btn,rbtn);

   return 1;
};
