/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/X.h>
#include <X11/Xatom.h>

#define FALSE 0

main(argc,argv)
   int argc;
   char ** argv;
{
   Display * dpy;
   Visual * vis;
   XVisualInfo * vin,vinit;
   int ct,screen,depth,i;
   Window wind,root;
   GC gc;
   XSizeHints sh;
   XEvent xev;
   XWindowAttributes attrs;
   Colormap cm;
   XSetWindowAttributes sattrs;
   int mask;
   Atom actual_type;
   int actual_format;
   int nitems;
   int leftover;
   Colormap cmp;

   dpy = XOpenDisplay(0);
   if (dpy == 0) {
      fprintf("Can't open display\n");
      exit(1);
    };
   XSynchronize(dpy,1);

   screen = XDefaultScreen(dpy);

   vinit.screen = screen;
   vin = XGetVisualInfo(dpy,VisualScreenMask,&vinit,&ct);
   if (vin != NULL) {
      vis = vin[0].visual;
      for (i = 0; i < ct; ++i) {
	 if (vin[i].depth > 1 && vin[i].class == PseudoColor) {
	    vis = vin[i].visual;
	    break;
	  };
       };
    };
   XFree(vin);

   root = RootWindow(dpy,screen);
   depth = DisplayPlanes(dpy,screen);
   cm = XCreateColormap(dpy,root,vis,AllocAll);
   cm = XCopyColormapAndFree(dpy,cm);
   mask = CWColormap;
   sattrs.colormap = cm;

   if (XGetWindowProperty(dpy,root,XA_RGB_COLOR_MAP,
				0L, 100000000L,
				FALSE,
				XA_COLORMAP,
				&actual_type,
				&actual_format,
				&nitems,
				&leftover,
				&cmp) == Success) {
      printf("COLOR MAP is 0x%x\n",cmp);
    };

   if (XGetWindowProperty(dpy,root,XA_RGB_BEST_MAP,
				0L, 100000000L,
				FALSE,
				XA_COLORMAP,
				&actual_type,
				&actual_format,
				&nitems,
				&leftover,
				&cmp) == Success) {
      printf("BEST COLOR MAP is 0x%x\n",cmp);
    };

   if (XGetWindowProperty(dpy,root,XA_RGB_DEFAULT_MAP,
				0L, 100000000L,
				FALSE,
				XA_COLORMAP,
				&actual_type,
				&actual_format,
				&nitems,
				&leftover,
				&cmp) == Success) {
      printf("DEFAULT COLOR MAP is 0x%x\n",cmp);
    };


   wind = XCreateWindow(dpy,root,100,100,200,200,3,depth,InputOutput,vis,
			   mask,&sattrs);

   sh.flags = USPosition|USSize;
   sh.x = 100;
   sh.y = 100;
   sh.width = 200;
   sh.height = 200;
   XSetStandardProperties(dpy,wind,"test37","test37",None,argc,argv,&sh);
   XMapWindow(dpy,wind);

   for ( ; ; ) {
      while (XCheckWindowEvent(dpy,wind,~0,&xev));
      XGetWindowAttributes(dpy,wind,&attrs);
      if (attrs.map_state == IsViewable) break;
    };

   gc = XCreateGC(dpy,wind,0,0);
   XSetState(dpy,gc,BlackPixel(dpy,screen),WhitePixel(dpy,screen),3,~0);
   XFillRectangle(dpy,wind,gc,50,50,100,100);
   XFlush(dpy);

   sleep(20);
};
