/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include "ash.h"
#include "bio.h"
#include "leaf.h"
#include "stem.h"
#include "rip.h"
#include "DATATYPES.h"
#include <stdio.h>


/* ================================================= */
/* === Fwd declarations           ================== */
/* ================================================= */

bpress();
rippress();

/* ================================================= */
/* === LEAF data structures       ================== */
/* ================================================= */

#define STEM_WINDOW 1
#define UP_PART 2
#define MIDDLE_PART 3
#define DOWN_PART 4


/*
  {name, type,                 -----*T
  {bottom x, bottom y,         |  / |
  top x, top y},               | /  |
  window routine, data};      B*-----
  */

static LEAF_DATA leafdata[]={
  LEAF_ROOT(NULL),
  {STEM_WINDOW, LEAF_TYPE_PDM,
     {LEAF_COORD_LX, LEAF_COORD_TEXT, 
	LEAF_COORD_RX, LEAF_COORD_TY},
     NULL, 0},
  {UP_PART, LEAF_TYPE_WINDOW,
     {LEAF_COORD_LX, LEAF_COORD_NEXT(MIDDLE_PART),
	LEAF_COORD_RX, LEAF_COORD_NEXT(STEM_WINDOW)},
     rippress,0},
  {MIDDLE_PART, LEAF_TYPE_TEXT,
     {LEAF_COORD_LX, LEAF_COORD_NEXT(DOWN_PART),
	LEAF_COORD_RX, LEAF_COORD_TEXT_LINE },
     NULL, (int)"Middle Part"},
  {DOWN_PART, LEAF_TYPE_TEXT,
     {LEAF_COORD_LX, LEAF_COORD_BY,
	LEAF_COORD_RX, LEAF_COORD_REL_LINE(10) },
     NULL, (int)"Lower Part"},
  LEAF_END
  };

/* ================================================= */
/* === STEM data structures       ================== */
/* ================================================= */

static STEM_PDM_DATA menudata[]={
  {STEM_PSTATE_MENU, "Quit"},
  {STEM_PSTATE_BTN,  "quit",bpress},
  {STEM_PSTATE_MENU, "Menu 1"},
  {STEM_PSTATE_BTN,  "Btn 1", bpress},
  {STEM_PSTATE_BTN,  "Btn 2", bpress},
  {STEM_PSTATE_BTN,  "Btn 3", bpress},
  {STEM_PSTATE_MENU, "Menu 2"},
  {STEM_PSTATE_BTN,  "Btn 4", bpress},
  {STEM_PSTATE_END}
};
     

/* ================================================= */
bpress( data, menu, button, window)
int data;
char *menu, *button;
ASH_WINDOW window;
{
  printf("STEM: Button press.\n");
  printf("Menu = %s; Button = %s\n",menu, button);
  if ( (!strcmp(menu,"Quit")) && (!strcmp(button,"quit")) )
	exit(0);
}

/* ================================================= */
riptrack(  x, y, nclicks, event, max, w)
int x, y, nclicks, event, max, w;
{
  printf("(%d, %d)\n",x,y);
  ASHline(w, 0,0, x,y);
  return (event != RIP_TRANS_UP);
}

rippress(x,y,ch,btns,region)
int x,y;
char ch;
int btns;
RIP_REGION region;
{
  int w=0;
  
  printf("RIP:  Button press.\n");
#if 0
  if (! (btns && RIP_BTN_TAP))
#endif
    RIPtrack(riptrack, -1, w, 0);
  printf("Done Tracking.\n");
}



/* ================================================= */
setup_screen(w)
ASH_WINDOW *w;
{
  ASH_WINDOW sw;

  /* create a window */
  *w=ASHinit(ASH_MODE_INQUIRE);

  /* set a nice cursor in the window */
  BIOset_cursor_standard(*w, ASH_CURSOR_ARROW_UL);

  /* set up the window according to the LEAF table and draw it */
  LEAFsetup_window(*w,leafdata,0);
  LEAFredraw(*w);

  /* set up the menu in the window in the box provided by LEAF */
  sw=LEAFinq_window(*w,STEM_WINDOW, 0);
  STEMpdm_define(sw, 0, menudata);

  /* set miscellaneous drawing attributes for the window */
  ASHcolor(*w, 1);
  ASHline_style(*w, ASH_STYLE_SOLID);
  ASHcombination_rule(*w,ASH_CR_SET);

}


/* ================================================= */
main(argc,argv)
   Integer argc;
   String argv[];
{
   ASH_WINDOW w; 

   setup_screen(&w);

   for (;;) {
     RIPuser_pick(0);
   };

 };




