/***************************************************************/
/*							       */
/*		     Test program for ANIM		       */
/*							       */
/***************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include <stdio.h>
#include "ash.h"
#include "stem.h"

/***************************************************************/
/*							       */
/*  main - the initialization routine sets up the graphic      */
/*	window and the drawing primitives such as fonts,       */
/*	cursors, and combination rules. 		       */
/*							       */
/***************************************************************/

main(argc,argv)
  int argc;
  char *argv[];
{
   ASH_WINDOW window;
   int Lx,Rx,By,Ty,width,start,i;
   int lx,by,rx,ty;
   int c[8];
   int reply;
   static char *format[9] = {
	"\n%0.0.1.41o\n",
	"%0.1.16.41o\n",
	"%0.2.18.41o\n",
	"%0.3.20.41o\n",
	"%0.4.22.41o\n",
	"%0.5.24.41o\n",
	"%0.6.26.41o\n",
	"%a  %c",
	NULL};

#define NUMPATS  9
#define NUMCOLS 7

   static short patterns[NUMPATS][16] =
   { {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},

     {0x1111, 0x0000, 0x4444, 0x0000, 0x1111, 0x0000, 0x4444, 0x0000,
      0x1111, 0x0000, 0x4444, 0x0000, 0x1111, 0x0000, 0x4444, 0x0000},

     {0x1111, 0x4444, 0x1111, 0x4444, 0x1111, 0x4444, 0x1111, 0x4444,
      0x1111, 0x4444, 0x1111, 0x4444, 0x1111, 0x4444, 0x1111, 0x4444},

     {0x1111, 0xaaaa, 0x4444, 0xaaaa, 0x1111, 0xaaaa, 0x4444, 0xaaaa,
      0x1111, 0xaaaa, 0x4444, 0xaaaa, 0x1111, 0xaaaa, 0x4444, 0xaaaa},

     {0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555,
      0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555},

     {0x7777, 0xaaaa, 0xdddd, 0xaaaa, 0x7777, 0xaaaa, 0xdddd, 0xaaaa,
      0x7777, 0xaaaa, 0xdddd, 0xaaaa, 0x7777, 0xaaaa, 0xdddd, 0xaaaa},

     {0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd,
      0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd},

     {0x7777, 0xffff, 0xdddd, 0xffff, 0x7777, 0xffff, 0xdddd, 0xffff,
      0x7777, 0xffff, 0xdddd, 0xffff, 0x7777, 0xffff, 0xdddd, 0xffff},

     {0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
      0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff}
   };


/* printf("Do the ASHdraw_hilite call (0 or 1)?\n");
   scanf("%d",&reply);
  */
   ASHinit(ASH_MODE_INQUIRE,0);

   window = ASHinq_top();
   ASHinq_size(window,ASH_SIZE_WINDOW,&Lx,&By,&Rx,&Ty);
   width = (Rx - Lx) / (NUMCOLS * 2 + 1);

   c[1] = ASHlookup_color(window,"black");
   c[2] = ASHlookup_color(window,"red");
   c[3] = ASHlookup_color(window,"orange");
   c[4] = ASHlookup_color(window,"yellow");
   c[5] = ASHlookup_color(window,"green");
   c[6] = ASHlookup_color(window,"blue");
   c[7] = ASHlookup_color(window,"maroon");

   ASHfill_table(33,NUMPATS,patterns);
   ASHcolor(window,c[5]);
   printf("What fill pattern (41 for total fill, 38 for bug)?\n");
   scanf("%d",&reply);
   ASHfill(window,reply);

/* ASHdraw_hilite(window,reply);    */
   lx = 10;  rx = 100; ty = 40; by = 90;
   for (i=0; i<20; ++i)
      { ASHrectangle(window, lx, by, rx, ty);
	sleep(1);
	ASHdraw_hilite(window,1);
	ASHrectangle(window, lx, by, rx, ty);
	ASHdraw_hilite(window,0);
	lx += 5;
	rx += 5;
	ty += 5;
	by += 5;
      }
   sleep(20);
}

