/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include "/pro/bwe/include/ash.h"
#include "/pro/bwe/include/willow.h"

#define NULL 0
#define TRUE 1

static	int	clock_init();


static	WILLOW_DEFN	template = {
   WILLOW_CLASS_USER_THREAD,
   { "Test", "old_english.36", 'T' },
   { 0 },
   { ASH_WINDOW_NOSAVE, WILLOW_TITLE_TAB_SENSE, WILLOW_INSTANCE_SAVED },
   clock_init,
   NULL,
   { { { "Move", "pecan.icons", '1', 0, 0, 1 },
       WILLOW_LOCATION_UL,
       WILLOW_BUTTON_NORMAL,
       WILLOW_ACTION_MOVE(DOWN) },
     { { "Size", "pecan.icons", '0', 0, 0, 1 },
       WILLOW_LOCATION_UR,
       WILLOW_BUTTON_NORMAL,
       WILLOW_ACTION_TYPE_AUX8, NULL, WILLOW_ACTION_DOWN },
     { { "Size1", "pecan.icons", '0', 0, 0, 1 },
       WILLOW_LOCATION_LR,
       WILLOW_BUTTON_NORMAL,
       WILLOW_ACTION_TYPE_AUX8, NULL, WILLOW_ACTION_DOWN },
     { { "Size2", "pecan.icons", '0', 0, 0, 1 },
       WILLOW_LOCATION_LL,
       WILLOW_BUTTON_NORMAL,
       WILLOW_ACTION_TYPE_AUX8, NULL, WILLOW_ACTION_DOWN },
     { { "Move1" },
       WILLOW_LOCATION_BOTTOM,
       WILLOW_BUTTON_NOSHOW,
       WILLOW_ACTION_MOVE(DOWN) },
     { { "Remove" },
       WILLOW_LOCATION_TITLE,
       WILLOW_BUTTON_NORMAL,
       WILLOW_ACTION_ICON(DEFAULT) },
     { { "Push" },
       WILLOW_LOCATION_TITLE,
       WILLOW_BUTTON_NORMAL,
       WILLOW_ACTION_PUSH(DEFAULT) },
     { { "Pop" },
       WILLOW_LOCATION_ANY,
       WILLOW_BUTTON_NOSHOW,
       WILLOW_ACTION_POP(DEFAULT) },
   }
};



main(argc,argv)
   int argc;
   char * argv[];
{
   argc = ASHset_application(argc,argv);

   if (argc == 2)
      ASHinit(ASH_MODE_DISPLAY);
   else if (argc == 3)
      ASHinit(ASH_MODE_WINDOW);
   else
      ASHinit(ASH_MODE_INQUIRE);

   WILLOWdefine(NULL,NULL,NULL);

   WILLOWdefine_window(&template);

   WILLOWdraw();

   for ( ; ; ) {
      RIPuser_pick(0);
    };
};


static
clock_init(w)
   ASH_WINDOW w;
{
   int lx,by,rx,ty;
   static int ct = 0;
   char buf[16];
   char *ttl;
   ASH_WINDOW nw;

   ttl = ASHinq_window_name(w);
   if (ttl == NULL) {
      sprintf(buf,"Clk_%d",++ct);
      ASHinq_size(w,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);
      nw = ASHcreate(w,(3*lx+rx)/4,(3*by+ty)/4,0,0,abs(rx-lx)/2,abs(ty-by)/2,4,
			ASH_WINDOW_VISIBLE);
      ASHfill(nw,3);
      ASHinq_size(nw,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);
      ASHrectangle(nw,lx,by,rx,ty);
      BIOnew_input_window(nw);
      ASHset_window_name(w,buf);
      ASHset_refresh(w,clock_init);
    };

   ASHinq_size(w,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);

   ASHline(w,lx,by,rx,ty);
   ASHline(w,lx,ty,rx,by);
   ASHtext(w,lx+3,by+3,"12345");
};






