/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include "/pro/bwe/ash/src/ash.h"

#define   WIDTH     14.0
#define   HEIGHT    22.0
#define   MY_LINE   10
#define   MY_PAT    33



/***********************************************************
**							  **
**  Cathleen Greenberg	   cs195063	face	  9-18-88 **
**							  **
**  This program draws a face in an ash window.  In order **
**  to account for different window sizes, I mapped the   **
**  face out in units.	There are 22 height units and 14  **
**  width units in the designed drawing.  These get	  **
**  correspend to pixel values by dividing the window	  **
**  width and height by the corresponding units.  The	  **
**  result is then used by the drawing routines to	  **
**  produce an appropriately scaled image.		  **
**							  **
***********************************************************/



static void
Draw_Nose(draw,unit_x,unit_y)
   ASH_WINDOW draw;
   double unit_x,unit_y;

{

   ASH_LINE_STYLE old;

   old = ASHline_style(draw,ASH_STYLE_SOLID);
   ASHarc(draw,((int)(1.5 * unit_x)),((int)(5.5 * unit_y)),
	       ((int)(4 * unit_x)),((int)(1.75 * unit_y)),
	       6080, -11520);

}


static void
Draw_Fez(draw,unit_x,unit_y)
   ASH_WINDOW draw;
   double unit_x,unit_y;

{

   ASH_FILL_STYLE old_f;
   ASH_LINE_STYLE old_l,old_l2;
   int x[4];
   int y[4];
   int spline_x[8];
   int spline_y[9];	/*** this cause x11 to hang */
/* int spline_y[8];	/* this works		    */
   static short my_pat[] = {0x16,
				     0x3c0,
				     0x7e0,
				     0xff0,
				     0x1ff8,
				     0x3ffc,
				     0x7ffe,
				     0xffff,
				     0xffff,
				     0x7ffe,
				     0x3ffc,
				     0x1ff8,
				     0xff0,
				     0x7e0,
				     0x3c0,
				     0x16};


   ASHfill_table(MY_PAT,1,my_pat);
   ASHline_table(MY_LINE, 1, 2, 2, 1, 0, 7, 25,3,5,3,2,3,1);
   x[0] = (int)(-1.5 * unit_x);
   x[1] = (int)(-2.6 * unit_x);
   x[2] = 0;
   x[3] = (int)(1.4 * unit_x);
   y[0] = (int)(6.3 * unit_y);
   y[1] = (int)(9.2 * unit_y);
   y[2] = (int)(10.2 * unit_y);
   y[3] = (int)(7.3 * unit_y);
   old_f = ASHfill(draw,MY_PAT);
   ASHpolygon(draw,4,x,y);
   old_f = ASHfill(draw,ASH_FILL_DARK_HALFTONE);
   ASHfilled_ellipse(draw,((int)(-1.3 * unit_x)),((int)(9.7 * unit_y)),
			  ((int)(1.5 * unit_x)),((int)(0.8 * unit_y)));



   old_f = ASHfill(draw,ASH_FILL_SOLID);
   old_l = ASHline_style(draw,MY_LINE); 
   spline_x[0] = (int)(-2.75 * unit_x);
   spline_x[1] = (int)(-3.5 * unit_x);
   spline_x[2] = (int)(-4 * unit_x);
   spline_x[3] = (int)(-4.1 * unit_x);
   spline_x[4] = (int)(-4.3 * unit_x);
   spline_x[5] = (int)(-4.7 * unit_x);
   spline_x[6] = (int)(-5 * unit_x);
   spline_x[7] = (int)(-5.8 * unit_x);
   spline_y[0] = (int)(9.2 * unit_y);
   spline_y[1] = (int)(8.8 * unit_y);
   spline_y[2] = (int)(8 * unit_y);
   spline_y[3] = (int)(7 * unit_y);
   spline_y[4] = (int)(5.3 * unit_y);
   spline_y[5] = (int)(3 * unit_y);
   spline_y[6] = (int)(2 * unit_y);
   spline_y[7] = (int)(1.1 * unit_y);
   ASHspline(draw,8,spline_x,spline_y);

   old_l2 = ASHline_style(draw,old_l);
   ASHline(draw,((int)(-5 * unit_x)),((int)(1.3 * unit_y)),
		((int)(-5.8 * unit_x)),((int)(2 * unit_y)));
   ASHline(draw,((int)(-4.5 * unit_x)),((int)(1.9 * unit_y)),
		((int)(-5.1 * unit_x)),((int)(2.3 * unit_y)));

} /* Draw_fez */


static void
Draw_Neck(draw,unit_x,unit_y)
   ASH_WINDOW draw;
   double unit_x,unit_y;

{
   ASH_FILL_STYLE old_f;
   ASH_LINE_STYLE old_l;

   old_f = ASHfill(draw,ASH_FILL_SOLID);
   old_l = ASHline_style(draw,ASH_STYLE_THICK);
   ASHline(draw,((int)(-1.5 * unit_x)),((int)(6.3 * unit_y)),
		((int)(-1.4 * unit_x)),((int)(-0.9 * unit_y)));
   ASHline(draw,((int)(2.0 * unit_x)),((int)(-1.1 * unit_y)),
		((int)(2.3 * unit_x)),((int)(2.3 * unit_y)));
   ASHcircle(draw,((int)(-1.5 * unit_x)),((int)(5 * unit_y)),
			 ((int)(0.5 * unit_x)));
   old_f = ASHfill(draw,ASH_FILL_HOLLOW);
   ASHfilled_circle(draw,((int)(-1.4 * unit_x)),((int)(5 * unit_y)),
			 ((int)(0.5 * unit_x)));

}


static void
Draw_Lips(draw,unit_x,unit_y)
   ASH_WINDOW draw;
   double unit_x,unit_y;

{

  ASH_LINE_STYLE old_l;
  ASH_FILL_STYLE old_f;

  old_f = ASHfill(draw,ASH_FILL_SOLID);
  old_l = ASHline_style(draw,ASH_STYLE_SOLID);
  ASHline(draw,((int)(4.5 * unit_x)),((int)(2.2 * unit_y)),
	       ((int)(3.8 * unit_x)),((int)(4.1 * unit_y)));
  ASHline(draw,((int)(0.5 * unit_x)),((int)(2.3 * unit_y)),
	       ((int)(4.5 * unit_x)),((int)(2.3 * unit_y)));

}


static void
Draw_Eyes(draw,unit_x,unit_y)
   ASH_WINDOW draw;
   double unit_x,unit_y;

{

   ASH_FILL_STYLE old = ASHfill(draw,ASH_FILL_SOLID);

   ASHfilled_circle(draw,((int)(1.4 * unit_x)),((int)(5.8 * unit_y)),
			 ((int)(0.25 * unit_x)));
   ASHfilled_circle(draw,((int)(2.5 * unit_x)),((int)(6.5 * unit_y)),
			 ((int)(0.25 * unit_x)));

}


static void
Draw_Shirt(draw,unit_x,unit_y)
   ASH_WINDOW draw;
   double unit_x,unit_y;

{

   ASH_FILL_STYLE old_f;
   ASH_LINE_STYLE old_l;

   old_f = ASHfill(draw,15);
   old_l = ASHline_style(draw,ASH_STYLE_THICKER);
   ASHline(draw,((int)(-1.4 * unit_x)),((int)(-0.9 * unit_y)),
		((int)(2.0 * unit_x)),((int)(-1.1 * unit_y)));
   ASHline(draw,((int)(-4.8 * unit_x)),((int)(-3.2 * unit_y)),
		((int)(-1.5 * unit_x)),((int)(-5.0 * unit_y)));
   ASHline(draw,((int)(3.5 * unit_x)),((int)(-2.7 * unit_y)),
		((int)(2.3 * unit_x)),((int)(-3.4 * unit_y)));
   old_f = ASHfill(draw,ASH_FILL_DARK_HALFTONE);
   ASHline(draw,((int)(2.0 * unit_x)),((int)(-1.1 * unit_y)),
		((int)(3.5 * unit_x)),((int)(-2.7 * unit_y)));
   ASHline(draw,((int)(-1.4 * unit_x)),((int)(-0.9 * unit_y)),
		((int)(-4.8 * unit_x)),((int)(-3.2 * unit_y)));
   ASHline(draw,((int)(-1.5 * unit_x)),((int)(-5.0 * unit_y)),
		((int)(-1.2 * unit_x)),((int)(-3.5 * unit_y)));
   ASHline(draw,((int)(1.5 * unit_x)),((int)(-1.0 * unit_y)),
		((int)(4.0 * unit_x)),((int)(-8.2 * unit_y)));
   old_f = ASHfill(draw,ASH_FILL_SOLID);
/* want to design a thicker still line */
   ASHline(draw,((int)(-7.0 * unit_x)),((int)(-8.2 * unit_y)),
		((int)(7.0 * unit_x)),((int)(-8.2 * unit_y)));

}


static void
Draw_Arms(draw,unit_x,unit_y)
   ASH_WINDOW draw;
   double unit_x, unit_y;

{

   ASH_LINE_STYLE old;

   old = ASHline_style(draw,ASH_STYLE_SOLID);
   ASHline(draw,((int)(-4.0 * unit_x)),((int)(-3.7 * unit_y)),
		((int)(-5.2 * unit_x)),((int)(-8.0 * unit_y)));
   ASHline(draw,((int)(-1.8 * unit_x)),((int)(-4.9 * unit_y)),
		((int)(-2.5 * unit_x)),((int)(-8.0 * unit_y)));
   ASHline(draw,((int)(3.3 * unit_x)),((int)(-3.0 * unit_y)),
		((int)(5.3 * unit_x)),((int)(-8.0 * unit_y)));

}
main(argc,argv)
   int argc;
   char **argv;
{
   ASH_WINDOW parent, draw;
   double unit_x, unit_y;
   int rx, lx, by, ty, width, height;
   char wait;

   argc = ASHset_application(argc,argv);

   parent = ASHinit(ASH_MODE_INQUIRE);
   ASHinq_size(parent,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);
   width = (int)((rx - lx)/2);
   height = (int)((by - ty)/2);
   unit_x = (rx - lx)/WIDTH;
   unit_y = (by - ty)/HEIGHT;
   draw = ASHcreate(parent,lx,by,
		   -width,-height,
		    width,height,
		    ASH_BORDER_THIN,
		    ASH_WINDOW_VISIBLE);


   Draw_Nose(draw,unit_x,unit_y);
   Draw_Fez(draw,unit_x,unit_y);
   Draw_Neck(draw,unit_x,unit_y);
   Draw_Lips(draw,unit_x,unit_y);
   Draw_Eyes(draw,unit_x,unit_y);
   Draw_Shirt(draw,unit_x,unit_y);
   Draw_Arms(draw,unit_x,unit_y);
   sleep(20);


}
