/***************************************************************/
/*							       */
/*		     Test program for ANIM		       */
/*							       */
/***************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include <stdio.h>
#include "ash.h"
#include <wind.h>



main(argc,argv)
  int argc;
  char *argv[];
{
   ASH_WINDOW window;
   int Lx,Rx,By,Ty,width,start,i,oldfill;

#define NUMPATS  9

   static short patterns[NUMPATS][16] =
   { {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},

     {0x1111, 0x0000, 0x4444, 0x0000, 0x1111, 0x0000, 0x4444, 0x0000,
      0x1111, 0x0000, 0x4444, 0x0000, 0x1111, 0x0000, 0x4444, 0x0000},

     {0x1111, 0x4444, 0x1111, 0x4444, 0x1111, 0x4444, 0x1111, 0x4444,
      0x1111, 0x4444, 0x1111, 0x4444, 0x1111, 0x4444, 0x1111, 0x4444},

     {0x1111, 0xaaaa, 0x4444, 0xaaaa, 0x1111, 0xaaaa, 0x4444, 0xaaaa,
      0x1111, 0xaaaa, 0x4444, 0xaaaa, 0x1111, 0xaaaa, 0x4444, 0xaaaa},

     {0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555,
      0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555},

     {0x7777, 0xaaaa, 0xdddd, 0xaaaa, 0x7777, 0xaaaa, 0xdddd, 0xaaaa,
      0x7777, 0xaaaa, 0xdddd, 0xaaaa, 0x7777, 0xaaaa, 0xdddd, 0xaaaa},

     {0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd,
      0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd},

     {0x7777, 0xffff, 0xdddd, 0xffff, 0x7777, 0xffff, 0xdddd, 0xffff,
      0x7777, 0xffff, 0xdddd, 0xffff, 0x7777, 0xffff, 0xdddd, 0xffff},

     {0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
      0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff}
   };


   ASHinit(ASH_MODE_INQUIRE,0);

   window = ASHinq_top();
   window = WINDsetup(window);
   ASHvisible(window,1);
   ASHinq_size(window,ASH_SIZE_WINDOW,&Lx,&By,&Rx,&Ty);
   width = (Rx - Lx) / (NUMPATS * 2 + 1);

   ASHfill_table(33,NUMPATS,patterns);

   ASHanim_setup(window,8,2,0);

   for (i=1; i<=50; ++i)
      { ASHanim_color(window,2); /* red */
	oldfill = ASHfill(window,37);
	ASHrectangle(window,50,100,100,50);
	ASHfill(window,oldfill);
	ASHanim_color(window,1); /* black */
	ASHtext(window,60,60,"test text");

	ASHanim_next_frame(window);

	ASHanim_color(window,2); /* red */
	oldfill = ASHfill(window,37);
	ASHrectangle(window,50,100,100,50);
	ASHfill(window,oldfill);
	ASHanim_color(window,1); /* black */
	ASHtext(window,60,60,"test text");

	ASHanim_next_frame(window);
      }
   sleep(120);
}


