/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <bwe/ash.h>

#define NAME "gore"
#define DEFAULT_GEOM	"=100x50"

main()
{
   Display *dpy;
   Window wdw;
   register flag;
   char *geom;
   char *name = NAME;
   char buf[128];
   ASH_WINDOW w;
   int lx, by, rx, ty;
   int x, y, wd, ht;
   XSizeHints xsh;

   if ((dpy = XOpenDisplay(0)) == 0) {
      fprintf(stderr, "can't open %s\n", XDisplayName(0));
      exit(1);
   }
   if ((geom = XGetDefault(dpy, name, "geometry")) == 0)
      geom = DEFAULT_GEOM;
   flag = XGeometry(	dpy,
			DefaultScreen(dpy),
			XGetDefault(dpy, name, "geometry"),
			"=100x50",
			2,
			1, 1, 0, 0,
			&x, &y, &wd, &ht);
   xsh.flags = USSize;
   xsh.width = wd;
   xsh.height = ht;
   if (flag & XValue && flag & YValue) {
      xsh.flags |= USPosition;
      xsh.x = x;
      xsh.y = y;
   }
   else {
      x = 0;
      y = 0;
   }
   wdw = XCreateSimpleWindow(	dpy,
			DefaultRootWindow(dpy),
			x, y,
			wd, ht,
			2,
			BlackPixelOfScreen(DefaultScreenOfDisplay(dpy)),
			WhitePixelOfScreen(DefaultScreenOfDisplay(dpy)));
   XSetStandardProperties(dpy, wdw, name, name, None, &name, 1, &xsh);
   XMapWindow(dpy, wdw);
   XSynchronize(dpy,1);
   w = ASHuse_X_window(dpy, wdw);
#ifdef bozo
   sprintf(buf, "%s -geometry %s", name, geom);
printf("ASHroot_window(dpy, \"%s\"\n", buf);
   w = ASHroot_window(dpy, buf);
#endif
   ASHinq_size(w, ASH_SIZE_WINDOW, &lx, &by, &rx, &ty);
printf("%d %d %d %d\n", lx, by, rx, ty);
   getchar();
}
