/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#define NEWASH

#include "/pro/bwe/ash/src/ash.h"
#define TRUE 1
#define FALSE 0
#define NULL 0


static	void		refresh_rtn();
static	int		control_rtn();

main(argc,argv)
   int argc;
   char **argv;
{
   ASH_WINDOW a,b,c,d,e,f,g,h;
   int i,x,y;
   int xp[10],yp[10];
   ASH_CURSOR ac1,ac2;
   int lx,by,rx,ty;

   argc = ASHset_application(argc,argv);

   if (argc == 2)
      ASHinit(ASH_MODE_DISPLAY);
   else if (argc == 3)
      ASHinit(ASH_MODE_WINDOW);
   else
      ASHinit(ASH_MODE_INQUIRE);

   BIOinit();

   a = ASHinq_top();
   printf("top window is 0x%x\n",a);
   refresh_rtn(a);

   ASHbox(a,100,100,200,200);
   ASHcombination_rule(a,10);
   ASHbox(a,125,125,225,225);
   ASHcombination_rule(a,3);

   RIPinput_box(a,"INPUT a box",&lx,&by,&rx,&ty);
   printf("box was at (%d,%d) -> (%d,%d)\n",lx,by,rx,ty);

   b = ASHcreate(a,100,500,0,0,400,400,1,ASH_WINDOW_VISIBLE|ASH_WINDOW_NOSAVE);
   c = ASHcreate(b,0,0,0,0,400,400,0,ASH_WINDOW_FRAME);

   ASHset_refresh(b,refresh_rtn);
   refresh_rtn(b);
   ASHset_refresh(a,refresh_rtn);
   refresh_rtn(a);

   ASHcenter_text(a,"BUTTON A",25,50,125,25);
   ASHsensitive_area(a,25,50,125,25,ASH_SENSE_FLIP);

   ASHcenter_text(b,"BUTTON B",25,25,125,50);
   ASHsensitive_area(b,25,25,125,50,ASH_SENSE_FLIP);

   ASHcenter_text(c,"BUTTON C",225,25,325,50);
   ASHsensitive_area(c,225,25,325,50,ASH_SENSE_FLIP);

   printf("Type a 'z' to exit\n");
   if (argc != 2) {
      for ( ; ; ) {
	 i = BIOnext_wait();
	 printf("Event %d\n",i);
	 if (i == 'z') break;
       };
    };
};




static void
refresh_rtn(w)
   ASH_WINDOW w;
{
   int i;
   int lx,by,rx,ty;
   int dx,dy;

   ASHinq_size(w,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);
   dy = (ty-by)/10;
   dx = (rx-lx)/10;

   for (i = 0; i < 10; ++i) {
      switch (((int) w)%4) {
	 case 0 :
	    ASHline(w,lx,by,rx,by+i*dy);
	    break;
	 case 1 :
	    ASHline(w,lx,ty,rx,ty-i*dy);
	    break;
	 case 2 :
	    ASHline(w,rx,ty,lx,ty-i*dy);
	    break;
	 case 3 :
	    ASHline(w,rx,by,lx,by+i*dy);
	    break;
       };
    };
};




static int
control_rtn(msg,w)
   char * msg;
   ASH_WINDOW w;
{
   printf("Message %s for 0x%x\n",msg,w);

   return ASH_CONTROL_REJECT;
};

