/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include "/pro/bwe/include/ash.h"

#define TRUE 1
#define FALSE 0
#define NULL 0

#define CARET_BITMAP_WIDTH 20
#define CARET_BITMAP_HEIGHT 20


main(argc,argv)
   int argc;
   char **argv;
{
   ASH_WINDOW a,b,c,d,e,f,g,h;
   int i,j;
   int xp[10],yp[10];
   int lx,by,rx,ty;
   int pix[400];
   int c1,c2;
   int x[4],y[4];

   argc = ASHset_application(argc,argv);

   if (argc == 2)
      ASHinit(ASH_MODE_DISPLAY);
   else if (argc == 3)
      ASHinit(ASH_MODE_WINDOW);
   else
      ASHinit(ASH_MODE_INQUIRE);

   a = ASHinq_top();

   b = ASHcreate(ASHinq_top(),0,100,
		    0,0,CARET_BITMAP_WIDTH,CARET_BITMAP_HEIGHT,
		    0,
		    ASH_WINDOW_INVISIBLE);
   ASHclear(b);

   x[0] = 0;
   y[0] = 0;
   x[1] = CARET_BITMAP_WIDTH/2;
   y[1] = CARET_BITMAP_HEIGHT;
   x[2] = CARET_BITMAP_WIDTH;
   y[2] = 0;

   ASHcombination_rule(b,10);
   ASHconvex_polygon(b,3,x,y);

   lx = CARET_BITMAP_WIDTH/2 -1;
   by = 1 + CARET_BITMAP_HEIGHT;

   c1 = ASHinq_background_color(a);
   c2 = ASHlookup_color(a,"red");

   ASHread_pixels(b,0,0,19,19,pix);
   for (i = 0; i < 20; ++i) {
      for (j = 0; j < 20; ++j) {
	 printf("%d ",pix[i*20+j]);
       }
      printf("\n");
    };

   printf("\n\n");

   ASHread_pixels(a,0,19,19,0,pix);
   for (i = 0; i < 20; ++i) {
      for (j = 0; j < 20; ++j) {
	 printf("%d ",pix[i*20+j]);
       }
      printf("\n");
    };

   ASHplane_mask(a,c1^c2);
   ASHcombination_rule(a,6);
   ASHsource(a,b);

   printf("\ncomb rule = %d, plane mask = %d\n\n",
	     ASHinq_combination_rule(a),ASHinq_plane_mask(a));

   ASHblt(a,0,0,CARET_BITMAP_WIDTH,CARET_BITMAP_HEIGHT,lx,by);

   ASHplane_mask(a,~0);
   ASHcombination_rule(a,3);
   ASHsource(a,a);

   ASHread_pixels(a,0,19,19,0,pix);
   for (i = 0; i < 20; ++i) {
      for (j = 0; j < 20; ++j) {
	 printf("%d ",pix[i*20+j]);
       }
      printf("\n");
    };

   sleep(20);
};





/* end of test19.c */

