/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include "/pro/bwe/ash/src/ash.h"

#define TRUE 1
#define FALSE 0
#define NULL 0
#define BALLS 10


main(argc,argv)
   int argc;
   char **argv;
{
   ASH_WINDOW a,b,c,d,e,f,g,h;
   int i,j,k,disp;
   int cma,cmb,cmc;
   int x[BALLS],y[BALLS],vx[BALLS],vy[BALLS];
   int lx,by,rx,ty;
   int col[BALLS];
   int x0[BALLS],y0[BALLS],x1[BALLS],y1[BALLS];

   argc = ASHset_application(argc,argv);

   if (argc == 2)
      ASHinit(ASH_MODE_DISPLAY);
   else if (argc == 3)
      ASHinit(ASH_MODE_WINDOW);
   else
      ASHinit(ASH_MODE_INQUIRE);

   a = ASHinq_top();
   if (argc > 3) ASHdebug(a,1);

   ASHinq_size(a,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);

   for (i = 0; i < BALLS; ++i) {
      x[i] = (lx+rx)/2;
      y[i] = (ty+by)/2;
      vx[i] = random()%20-10;
      if (vx[i] == 0) vx[i] = 1;
      vy[i] = random()%20-10;
      if (vy[i] == 0) vy[i] = 1;
      x0[i] = x[i];
      y0[i] = y[i];
      col[i] = 1;
    };

   ASHanim_setup(a,8,2,TRUE);

   for ( ; ; ) {
      for (i = 0; i < BALLS; ++i) {
	 x1[i] = x0[i];
	 y1[i] = y0[i];
	 x0[i] = x[i];
	 y0[i] = y[i];
	 x[i] += vx[i];
	 y[i] += vy[i];
	 if (x[i] < lx) {
	    x[i] = lx+lx-x[i];
	    vx[i] = random() % 10 + 1;
	    col[i] = (col[i]+1)%8;
	  };
	 if (x[i] > rx) {
	    x[i] = rx+rx-x[i];
	    vx[i] = -(random() % 10) - 1;
	    col[i] = (col[i]+1)%8;
	  };
	 if (y[i] < ty) {
	    y[i] = ty+ty-y[i];
	    vy[i] = random() % 10 + 1;
	    col[i] = (col[i]+1)%8;
	  };
	 if (y[i] > by) {
	    y[i] = by+by-y[i];
	    vy[i] = -(random() % 10) - 1;
	    col[i] = (col[i]+1)%8;
	  };
	 if (col[i] == 0) col[i] = 1;
	 ASHanim_color(a,0);
	 ASHrectangle(a,x1[i]-5,y1[i]+5,x1[i]+5,y1[i]-5);
	 ASHanim_color(a,col[i]);
	 ASHrectangle(a,x[i]-5,y[i]+5,x[i]+5,y[i]-5);
       };
      ASHanim_next_frame(a);
    };
};



