/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include "ash.h"
#define TRUE 1
#define FALSE 0
#define NULL 0


static	void		refresh_rtn();
static	int		control_rtn();

main(argc,argv)
   int argc;
   char **argv;
{
   ASH_WINDOW a,b,c,d,e,f,g,h;
   int i,x,y;
   int xp[10],yp[10];
   ASH_CURSOR ac1,ac2;

   argc = ASHset_application(argc,argv);

   if (argc == 2)
      ASHinit(ASH_MODE_DISPLAY);
   else if (argc == 3)
      ASHinit(ASH_MODE_WINDOW);
   else
      ASHinit(ASH_MODE_INQUIRE);

   a = ASHinq_top();
   b = ASHcreate(a,100,500,0,0,400,400,1,ASH_WINDOW_VISIBLE);
   c = ASHcreate(a,100,500,0,0,400,400,1,ASH_WINDOW_INVISIBLE);
   d = ASHcreate(a,50,400,0,0,100,100,1,ASH_WINDOW_NOSAVE|ASH_WINDOW_VISIBLE);
   printf("windows: a = 0x%x, b = 0x%x, c = 0x%x, d = 0x%x\n",a,b,c,d);

   ASHwindow_info(a);
   ASHwindow_info(b);

   refresh_rtn(b);
   f = ASHcreate(b,50,50,0,0,200,200,1,ASH_WINDOW_FRAME|ASH_WINDOW_VISIBLE);
   g = ASHcreate(f,50,50,0,0,100,100,1,ASH_WINDOW_VISIBLE|ASH_WINDOW_NOSAVE);
   ASHcombination_rule(g,6);
   printf("comb rule = %d\n",ASHinq_combination_rule(g));
   ASHcombination_rule(g,3);
   ASHline(g,0,0,100,100);
   ASHline(g,0,100,100,0);
   refresh_rtn(f);
   refresh_rtn(g);
   ASHremove(f);

   ac1 = ASHcursor_standard(ASH_CURSOR_SMALL_GLASSES);
   ac2 = ASHcursor_standard(ASH_CURSOR_BULLSEYE);

   ASHset_control(a,control_rtn);
   ASHset_control(b,control_rtn);
   ASHset_control(c,control_rtn);
   ASHset_control(d,control_rtn);

   ASHset_refresh(d,refresh_rtn);
   refresh_rtn(d);
   refresh_rtn(b);

   ASHwindow_cursor(b,ac1);
   ASHwindow_cursor(d,ac2);

   e = ASHcreate(d,10,10,0,0,50,50,1,ASH_WINDOW_NOSAVE|ASH_WINDOW_VISIBLE);
   printf("windows: e = 0x%x\n",e);
   ASHset_refresh(e,refresh_rtn);
   refresh_rtn(e);

   for (i = 0; i < 10; ++i) {
      ASHview(d,50+i,400-i,0,0,100,100);
    };
   for (i = 10; i < 20; ++i) {
      ASHview(d,50+i,400-i,0,0,110-i,110-i);
    };
   for (i = 0; i < 10; ++i) {
      ASHresize(d,50,400,0,0,100+10*i,100+10*i);
    };
   ASHpop(b);
   ASHpop(d);
   ASHpush(d);
   ASHrefresh(a);
   ASHremove(d);

   d = ASHcreate(a,50,400,0,0,300,300,1,ASH_WINDOW_NOSAVE|ASH_WINDOW_VISIBLE);
   printf("new window d = 0x%x\n",d);
   ASHset_refresh(d,refresh_rtn);
   ASHset_control(d,control_rtn);

   ASHfill(b,3);
   ASHrectangle(b,100,100,200,200);
   ASHline(b,50,90,200,90);
   ASHtext(b,100,90,"HELLO WORLD");
   ASHinq_text_extent(ASHinq_font(b),"HELLO WORLD",&x,&y);
   printf("Extent is %d %d\n",x,y);
   ASHinq_text_offset(ASHinq_font(b),"HELLO WORLD",&x,&y);
   printf("Offset is %d %d\n",x,y);
   ASHinq_text_next(ASHinq_font(b),"HELLO WORLD",&x,&y);
   printf("Next is %d %d\n",x,y);

   xp[0] = -11;
   yp[0] = 19;
   xp[1] = 0;
   yp[1] = 19;
   xp[2] = 0;
   yp[2] = 1;
   ASHpolyline(b,3,xp,yp);

   for (i = 0; i < 100; ++i) {
      ASHline(b,0,0,400,i*4+4);
      ASHline(c,400,0,0,i*4+4);
    };

   ASHpop(b);
   for (i = 0; i < 100; ++i) {
      ASHline(b,0,0,400,i*4+4);
    };

   ASHbatch_mode(TRUE);
   for (i = 0; i < 100; ++i) {
      ASHpoint(d,i,i);
    };
   ASHbatch_mode(FALSE);

   for (i = 0; i < 10; ++i) {
      xp[i] = (i*1000) % 199;
      yp[i] = (i*1000) % 257;
    };
   ASHpolygon(d,10,xp,yp);
   ASHclear(d);
   ASHconvex_polygon(d,10,xp,yp);
   ASHclear(d);
   ASHgeneral_polygon(d,10,xp,yp);
   ASHcircle(d,50,50,50);
   ASHfilled_ellipse(d,100,100,50,100);
   ASHclear(d);
   ASHspline(d,10,xp,yp);
   ASHclear(d);
   ASHspline_closed(d,10,xp,yp);

   ASHsave_bitmap(a,"/tmp/root.save");

   ASHvisible(c,TRUE);

   ASHvisible(c,FALSE);

   ASHcombination_rule(b,10);
   ASHblt(b,0,0,400,400,0,0);

   ASHcombination_rule(c,10);
   ASHblt(c,0,0,400,400,0,0);

   ASHvisible(c,TRUE);

   ASHvisible(c,FALSE);

   ASHsource(b,c);
   ASHcombination_rule(b,6);
   ASHblt(b,0,0,400,400,0,0);

   ASHcenter_text(a,"BUTTON",25,50,125,25);
   ASHsensitive_area(a,25,50,125,25,ASH_SENSE_FLIP);

   ASHcenter_text(b,"BUTTON B",25,25,125,50);
   ASHsensitive_area(b,25,25,125,50,ASH_SENSE_FLIP);

   printf("Type a 'z' to exit\n");
   if (argc != 2) {
      for ( ; ; ) {
	 i = BIOnext_wait();
	 printf("Event %d\n",i);
	 if (i == 'z') break;
       };
    };
};




static void
refresh_rtn(w)
   ASH_WINDOW w;
{
   int i;
   int lx,by,rx,ty;
   int dx,dy;

   ASHinq_size(w,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);
   dy = (ty-by)/10;
   dx = (rx-lx)/10;

   for (i = 0; i < 10; ++i) {
      switch (((int) w)%4) {
	 case 0 :
	    ASHline(w,lx,by,rx,by+i*dy);
	    break;
	 case 1 :
	    ASHline(w,lx,ty,rx,ty-i*dy);
	    break;
	 case 2 :
	    ASHline(w,rx,ty,lx,ty-i*dy);
	    break;
	 case 3 :
	    ASHline(w,rx,by,lx,by+i*dy);
	    break;
       };
    };
};




static int
control_rtn(msg,w)
   char * msg;
   ASH_WINDOW w;
{
   printf("Message %s for 0x%x\n",msg,w);

   return ASH_CONTROL_REJECT;
};
