/************************************************************************/
/*									*/
/*		bpiokeys.h						*/
/*									*/
/*	Function key definitions					*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


/************************************************************************/
/*									*/
/*	ASH maps the function keys into 64 integers as follows: 	*/
/*		 0-14:	F1-F14						*/
/*		15-24:	L1-L10						*/
/*		25-39:	R1-R15						*/
/*		40-63:	Special 					*/
/*									*/
/*									*/
/************************************************************************/


#define BPIO_KEY_BASE		1
#define BPIO_LEFT_BASE		15
#define BPIO_RIGHT_BASE 	25
#define BPIO_SPECIAL_BASE	40


#define BPIO_KEY_F1	(BPIO_KEY_BASE+0)
#define BPIO_KEY_F2	(BPIO_KEY_BASE+1)
#define BPIO_KEY_F3	(BPIO_KEY_BASE+2)
#define BPIO_KEY_F4	(BPIO_KEY_BASE+3)
#define BPIO_KEY_F5	(BPIO_KEY_BASE+4)
#define BPIO_KEY_F6	(BPIO_KEY_BASE+5)
#define BPIO_KEY_F7	(BPIO_KEY_BASE+6)
#define BPIO_KEY_F8	(BPIO_KEY_BASE+7)
#define BPIO_KEY_F9	(BPIO_KEY_BASE+8)
#define BPIO_KEY_F10	(BPIO_KEY_BASE+9)
#define BPIO_KEY_F11	(BPIO_KEY_BASE+10)
#define BPIO_KEY_F12	(BPIO_KEY_BASE+11)
#define BPIO_KEY_F13	(BPIO_KEY_BASE+12)
#define BPIO_KEY_F14	(BPIO_KEY_BASE+13)

#define BPIO_KEY_L1	(BPIO_LEFT_BASE+0)
#define BPIO_KEY_L2	(BPIO_LEFT_BASE+1)
#define BPIO_KEY_L3	(BPIO_LEFT_BASE+2)
#define BPIO_KEY_L4	(BPIO_LEFT_BASE+3)
#define BPIO_KEY_L5	(BPIO_LEFT_BASE+4)
#define BPIO_KEY_L6	(BPIO_LEFT_BASE+5)
#define BPIO_KEY_L7	(BPIO_LEFT_BASE+6)
#define BPIO_KEY_L8	(BPIO_LEFT_BASE+7)
#define BPIO_KEY_L9	(BPIO_LEFT_BASE+8)
#define BPIO_KEY_L10	(BPIO_LEFT_BASE+9)

#define BPIO_KEY_R1	(BPIO_RIGHT_BASE+0)
#define BPIO_KEY_R2	(BPIO_RIGHT_BASE+1)
#define BPIO_KEY_R3	(BPIO_RIGHT_BASE+2)
#define BPIO_KEY_R4	(BPIO_RIGHT_BASE+3)
#define BPIO_KEY_R5	(BPIO_RIGHT_BASE+4)
#define BPIO_KEY_R6	(BPIO_RIGHT_BASE+5)
#define BPIO_KEY_R7	(BPIO_RIGHT_BASE+6)
#define BPIO_KEY_R8	(BPIO_RIGHT_BASE+7)
#define BPIO_KEY_R9	(BPIO_RIGHT_BASE+8)
#define BPIO_KEY_R10	(BPIO_RIGHT_BASE+9)
#define BPIO_KEY_R11	(BPIO_RIGHT_BASE+10)
#define BPIO_KEY_R12	(BPIO_RIGHT_BASE+11)
#define BPIO_KEY_R13	(BPIO_RIGHT_BASE+12)
#define BPIO_KEY_R14	(BPIO_RIGHT_BASE+13)
#define BPIO_KEY_R15	(BPIO_RIGHT_BASE+14)

#define BPIO_KEY_HOME		(BPIO_SPECIAL_BASE+0)
#define BPIO_KEY_LEFT		(BPIO_SPECIAL_BASE+1)
#define BPIO_KEY_UP		(BPIO_SPECIAL_BASE+2)
#define BPIO_KEY_RIGHT		(BPIO_SPECIAL_BASE+3)
#define BPIO_KEY_DOWN		(BPIO_SPECIAL_BASE+4)
#define BPIO_KEY_PRIOR		(BPIO_SPECIAL_BASE+5)
#define BPIO_KEY_NEXT		(BPIO_SPECIAL_BASE+6)
#define BPIO_KEY_END		(BPIO_SPECIAL_BASE+7)
#define BPIO_KEY_BEGIN		(BPIO_SPECIAL_BASE+8)
#define BPIO_KEY_SELECT 	(BPIO_SPECIAL_BASE+9)
#define BPIO_KEY_PRINT		(BPIO_SPECIAL_BASE+10)
#define BPIO_KEY_EXECUTE	(BPIO_SPECIAL_BASE+11)
#define BPIO_KEY_INSERT 	(BPIO_SPECIAL_BASE+12)
#define BPIO_KEY_UNDO		(BPIO_SPECIAL_BASE+13)
#define BPIO_KEY_REDO		(BPIO_SPECIAL_BASE+14)
#define BPIO_KEY_MENU		(BPIO_SPECIAL_BASE+15)
#define BPIO_KEY_FIND		(BPIO_SPECIAL_BASE+16)
#define BPIO_KEY_CANCEL 	(BPIO_SPECIAL_BASE+17)
#define BPIO_KEY_HELP		(BPIO_SPECIAL_BASE+18)
#define BPIO_KEY_BREAK		(BPIO_SPECIAL_BASE+19)
#define BPIO_KEY_PF1		(BPIO_SPECIAL_BASE+20)
#define BPIO_KEY_PF2		(BPIO_SPECIAL_BASE+21)
#define BPIO_KEY_PF3		(BPIO_SPECIAL_BASE+22)
#define BPIO_KEY_PF4		(BPIO_SPECIAL_BASE+23)




/* end of bpiokeys.h */
