/************************************************************************/
/*									*/
/*		bpio.h							*/
/*									*/
/*	Definitions for brown primitivie input operations packages	*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/




/************************************************************************/
/*									*/
/*	Event class definitions 					*/
/*									*/
/************************************************************************/


typedef enum {
   BPIO_CLASS_NONE,			/* no event occurred		*/
   BPIO_CLASS_FKEY,			/* vanilla function key 	*/
   BPIO_CLASS_SHIFT_FKEY,		/* shifted function key 	*/
   BPIO_CLASS_CTRL_FKEY,		/* controlled function key	*/
   BPIO_CLASS_META_FKEY,		/* meta function key		*/
   BPIO_CLASS_UP_FKEY,			/* up function key		*/
   BPIO_CLASS_MOUSE,			/* mouse button 		*/
   BPIO_CLASS_UP_MOUSE, 		/* mouse button up		*/
   BPIO_CLASS_MOUSE_DATA,		/* mouse button data (internal) */
   BPIO_CLASS_TAP_MOUSE,		/* tap of mouse btn  (internal) */
   BPIO_CLASS_ASCII,			/* ascii text			*/
   BPIO_CLASS_META_ASCII,		/* meta ascii text		*/
   BPIO_CLASS_EVENT,			/* miscellaneous event		*/
   BPIO_CLASS_ABORT,			/* abort event			*/
   BPIO_CLASS_SHIFT_MOUSE,		/* shifted mouse button 	*/
   BPIO_CLASS_CTRL_MOUSE,		/* control mouse button 	*/
   BPIO_CLASS_META_MOUSE,		/* meta mouse button		*/
} BPIO_CLASS;





/************************************************************************/
/*									*/
/*	Event values							*/
/*									*/
/************************************************************************/


#define BPIO_EVENT_MOVE 	1
#define BPIO_EVENT_MOVE_DOWN	2
#define BPIO_EVENT_ENTER	3
#define BPIO_EVENT_EXIT 	4
#define BPIO_EVENT_STILL	5
#define BPIO_EVENT_STILL_DOWN	6
#define BPIO_EVENT_REDRAW	7
#define BPIO_EVENT_VISIBLE	8
#define BPIO_EVENT_INVISIBLE	9
#define BPIO_EVENT_VIEW 	10
#define BPIO_EVENT_RESIZE	11







/************************************************************************/
/*									*/
/*	Mouse values							*/
/*									*/
/************************************************************************/


#define BPIO_MOUSE_DATA(state,btn)	(((state)<<8)|(btn))
#define BPIO_MOUSE_BTN(v)		((v)&0xff)
#define BPIO_MOUSE_STATE(v)		(((v)>>8)&0xff)





/************************************************************************/
/*									*/
/*	Data types							*/
/*									*/
/************************************************************************/


typedef struct	_BPIO_EVENT	*BPIO_EVENT;
typedef long			 BPIO_TIME;



typedef struct _BPIO_EVENT {
   short BPIO_data;
   BPIO_CLASS BPIO_class;
   short BPIO_xpos;
   short BPIO_ypos;
   BPIO_TIME BPIO_time;
   ASH_WINDOW BPIO_window;
} BPIO_EVENT_B;





/************************************************************************/
/*									*/
/*	Entrys								*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	int		BPIOnext_event();	/* return next event	*/
extern	void		BPIOwait();
extern	int		BPIOmove_when_down();

#else

extern "C" {
	int		BPIOnext_event(...);
	void		BPIOwait(int);
	int		BPIOmove_when_down(int);
};

#endif




/* end of bpio.h */


