/************************************************************************/
/*									*/
/*		ashrm.c 						*/
/*									*/
/*	Resource manager interface for BWE				*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "ash_local.h"





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/






/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	XrmDatabase	rm_db;
static	Boolean 	rm_db_inited = FALSE;

static	String		uargval[] = { "BWE", 0 };
static	String *	uargv = uargval;
static	Integer 	uargc = 1;
static	String		uargname = NULL;
static	String		origname = NULL;
static	String *	origuargv;
static	Integer 	origuargc;
static	XrmDatabase	save_rm_db;
static	Integer 	save_rm_valid;





/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	void		set_child_defaults();
static	void		initialize_resources();
static	String		application_name();




/************************************************************************/
/*									*/
/*	Tables								*/
/*									*/
/************************************************************************/


static XrmOptionDescRec opTable[] = {
   {"-background",      "*background",  XrmoptionSepArg,        (caddr_t) NULL},
   {"-bd",              "*borderColor", XrmoptionSepArg,        (caddr_t) NULL},
   {"-bg",              "*background",  XrmoptionSepArg,        (caddr_t) NULL},
   {"-borderwidth",     "*TopLevelShell.borderWidth",   XrmoptionSepArg,        (caddr_t) NULL},
   {"-bordercolor",     "*borderColor", XrmoptionSepArg,        (caddr_t) NULL},
   {"-bw",              "*TopLevelShell.borderWidth",   XrmoptionSepArg,        (caddr_t) NULL},
   {"-display",         ".display",     XrmoptionSepArg,        (caddr_t) NULL},
   {"-fg",              "*foreground",  XrmoptionSepArg,        (caddr_t) NULL},
   {"-fn",              "*font",        XrmoptionSepArg,        (caddr_t) NULL},
   {"-font",            "*font",        XrmoptionSepArg,        (caddr_t) NULL},
   {"-foreground",      "*foreground",  XrmoptionSepArg,        (caddr_t) NULL},
   {"-geometry",        ".TopLevelShell.geometry",      XrmoptionSepArg,        (caddr_t) NULL},
   {"-iconic",          ".TopLevelShell.iconic",        XrmoptionNoArg, (caddr_t) "on"},
   {"-name",            ".name",        XrmoptionSepArg,        (caddr_t) NULL},
   {"-reverse",         "*reverseVideo",        XrmoptionNoArg, (caddr_t) "on"},
   {"-rv",              "*reverseVideo",        XrmoptionNoArg, (caddr_t) "on"},
   {"+rv",              "*reverseVideo", XrmoptionNoArg,        (caddr_t) "off"},
   {"-style",           "*style",       XrmoptionSepArg,        (caddr_t) NULL},
   {"-simple",          "*simple",      XrmoptionNoArg,         (caddr_t) "on"},
   {"-synchronous",     ".synchronous", XrmoptionNoArg, (caddr_t) "on"},
   {"-title",           ".TopLevelShell.title", XrmoptionSepArg,        (caddr_t) NULL},
   {"-xrm",              NULL,   XrmoptionResArg,        (caddr_t) NULL},
   {"+query",           ".TopLevelShell.query", XrmoptionNoArg, (caddr_t) "off"},
   {"-query",           ".TopLevelShell.query", XrmoptionNoArg, (caddr_t) "on"},
   {"-CMset",           ".cmset",       XrmoptionNoArg, (caddr_t) "off" },
   {"-CMinstall",       ".cminstall",   XrmoptionNoArg, (caddr_t) "off" },
   {"+CMset",           ".cmset",       XrmoptionNoArg, (caddr_t) "on" },
   {"+CMinstall",       ".cminstall",   XrmoptionNoArg, (caddr_t) "on" },
};

#define OP_TABLE_SIZE (sizeof(opTable)/sizeof(XrmOptionDescRec))





/************************************************************************/
/*									*/
/*	ASH_rm_init -- module initialization				*/
/*									*/
/************************************************************************/


void
ASH_rm_init()
{
   initialize_resources();
};





/********************************************************************************/
/*										*/
/*	ASH_rm_disp_init -- handle new display					*/
/*										*/
/********************************************************************************/


void
ASH_rm_disp_init(ds,fg)
   DISPLAY ds;
   Boolean fg;
{
   Atom actual_type;
   int actual_format;
   int nitems;
   int leftover;
   String xdefaults;
   XrmDatabase ndb;

   if (!fg) return;

   if (XGetWindowProperty(ds->display,
				DefaultRootWindow(ds->display),
				XA_RESOURCE_MANAGER,
				0L, 100000000L,
				FALSE,
				XA_STRING,
				&actual_type,
				&actual_format,
				&nitems,
				&leftover,
				&xdefaults) == Success) {
      if (xdefaults != NULL) {
	 ndb = XrmGetStringDatabase(xdefaults);
	 if (ndb != NULL) {
	    XrmMergeDatabases(rm_db,&ndb);
	    rm_db = ndb;
	  };
       };
    };
};






/************************************************************************/
/*									*/
/*	ASHset_application -- set argc and argv of application		*/
/*									*/
/************************************************************************/


Integer
ASHset_application(argc,argv)
   Integer argc;
   String *argv;
{
   initialize_resources();

   uargc = argc;
   uargv = argv;
   uargname = NULL;

   PROTECT;
   XrmParseCommand(&rm_db,opTable,OP_TABLE_SIZE,application_name(),&argc,argv);
   UNPROTECT;

   uargc = argc;
   uargv = argv;
   uargname = NULL;
   uargv[0] = application_name();
   origname = uargname;
   origuargc = uargc;
   origuargv = uargv;

   return uargc;
};





/************************************************************************/
/*									*/
/*	ASHset_application_string -- give a command line string 	*/
/*									*/
/************************************************************************/


void
ASHset_application_string(args)
   String args;
{
   String argv[128];
   Character buf[10240];
   Integer argc;
   String s;
   Integer qct;
   Integer i;
   XrmDatabase ndb;

   initialize_resources();

   argc = 0;
   strcpy(buf,args);
   s = buf;

   while (*s != 0) {
      while (isspace(*s)) ++s;
      if (*s == 0) break;
      qct = 0;
      argv[argc++] = s;
      while (*s != 0) {
	 if (qct != 0) {
	    if (*s == qct) qct = 0;
	  }
	 else {
	    if (isspace(*s)) break;
	    if (*s == '\'' || *s == '"') qct = *s;
	  };
	 ++s;
       };
      if (*s != 0) *s++ = 0;
    };

   uargv = (String *) calloc(sizeof(String),argc+2);

   uargc = argc+1;
   for (i = 0; i < argc; ++i) {
      uargv[i+1] = SALLOC(argv[i]);
    };
   if (argc > 0) uargv[0] = SALLOC(argv[0]);
   else uargv[0] = application_name();
   uargv[uargc] = NULL;
   uargname = NULL;

   PROTECT;
   if (save_rm_valid == 0) {
      save_rm_db = XrmGetStringDatabase("");
      XrmMergeDatabases(rm_db,&save_rm_db);
    };
   ++save_rm_valid;
   ndb = NULL;
   XrmParseCommand(&ndb,opTable,OP_TABLE_SIZE,application_name(),&uargc,uargv);
   if (ndb != NULL) XrmMergeDatabases(ndb,&rm_db);
   UNPROTECT;
};




/************************************************************************/
/*									*/
/*	ASHreset_application_string -- reset application info to base	*/
/*									*/
/************************************************************************/


void
ASHreset_application_string()
{
   uargc = origuargc;
   uargv = origuargv;
   uargname = origname;

   PROTECT;
   if (save_rm_valid > 0) {
      --save_rm_valid;
      if (save_rm_valid == 0) {
	 rm_db = XrmGetStringDatabase("");
	 XrmMergeDatabases(save_rm_db,&rm_db);
       };
    };
   UNPROTECT;
};






/************************************************************************/
/*									*/
/*	ASHresource_file -- specify resource file			*/
/*	ASHresource_string -- specify resources from string		*/
/*									*/
/************************************************************************/


void
ASHresource_file(name,overwrite)
   String name;
   Boolean overwrite;
{
   XrmDatabase ndb;

   initialize_resources();

   PROTECT;
   ndb = XrmGetFileDatabase(name);
   if (ndb != NULL) {
      if (overwrite) {
	 XrmMergeDatabases(ndb,&rm_db);
       }
      else {
	 XrmMergeDatabases(rm_db,&ndb);
	 rm_db = ndb;
       };
    };
   UNPROTECT;
};





void
ASHresource_string(text,overwrite)
   String text;
   Boolean overwrite;
{
   XrmDatabase ndb;

   initialize_resources();

   PROTECT;
   ndb = XrmGetStringDatabase(text);
   if (ndb != NULL) {
      if (overwrite) {
	 XrmMergeDatabases(ndb,&rm_db);
       }
      else {
	 XrmMergeDatabases(rm_db,&ndb);
	 rm_db = ndb;
       };
    };
   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	ASHinq_resource -- return resource for current application	*/
/*									*/
/************************************************************************/


char *
ASHinq_resource(name)
   String name;
{
   Character nam[1024],nam1[1024],nam2[1024];
   Character cls[1024],cls1[1024],cls2[1024];
   String s,t;
   Boolean fg;
   XrmValue v;
   Integer ln;

   initialize_resources();

   if (name[0] == '.' || name[0] == '*') {
      strcpy(nam,name);
      strcpy(nam1,name);
      strcpy(nam2,name);
    }
   else {
      sprintf(nam,"%s.%s",application_name(),name);
      sprintf(nam1,"BWE.%s",name);
      sprintf(nam2,"%s.%s",origname,name);
    };

   fg = TRUE;
   t = cls;
   for (s = nam; *s != 0; ++s) {
      if (fg && islower(*s)) *t++ = toupper(*s);
      else *t++ = *s;
      if (*s == '.' || *s == '*') fg = TRUE;
      else fg = FALSE;
    };
   *t = 0;

   fg = TRUE;
   t = cls1;
   for (s = nam1; *s != 0; ++s) {
      if (fg && islower(*s)) *t++ = toupper(*s);
      else *t++ = *s;
      if (*s == '.' || *s == '*') fg = TRUE;
      else fg = FALSE;
    };
   *t = 0;

   fg = TRUE;
   t = cls2;
   for (s = nam2; *s != 0; ++s) {
      if (fg && islower(*s)) *t++ = toupper(*s);
      else *t++ = *s;
      if (*s == '.' || *s == '*') fg = TRUE;
      else fg = FALSE;
    };
   *t = 0;

   PROTECT;
   fg = XrmGetResource(rm_db,nam,cls,&t,&v);
   if (!fg) fg = XrmGetResource(rm_db,nam1,cls1,&t,&v);
   if (!fg) fg = XrmGetResource(rm_db,nam2,cls2,&t,&v);
   UNPROTECT;

   if (!fg) s = NULL;
   else s = (String) v.addr;

   if (s != NULL) {			/* eliminate trailing spaces	*/
      ln = strlen(s);
      while (ln >= 0 && s[ln] == ' ') s[ln--] = 0;
    };

   return s;
};





/************************************************************************/
/*									*/
/*	ASHinq_window_resource -- get resource for given window 	*/
/*									*/
/************************************************************************/


String
ASHinq_window_resource(w,name)
   ASH_WINDOW w;
   String name;
{
   String ids[256];
   Integer i,ct;
   ASH_WINDOW pw;
   String s;
   Character buf[2048];

   ct = 0;
   for (pw = w; pw != NULL; pw = ASHinq_parent(pw)) {
      s = ASHinq_window_id(pw);
      if (s != NULL) ids[ct++] = s;
    };

   if (ASHinq_top_window(w) != ASHinq_top()) {
      s = ASHinq_window_id(ASHinq_top());
      if (s != NULL) ids[ct++] = s;
    };

   buf[0] = 0;
   for (i = ct-1; i >= 0; --i) {
      strcat(buf,ids[i]);
      strcat(buf,".");
    };

   strcat(buf,name);

   return ASHinq_resource(buf);
};




/************************************************************************/
/*									*/
/*	ASHinq_window_full_id -- get full id string for given window	*/
/*									*/
/************************************************************************/


String
ASHinq_window_full_id(w,outbuf)
   ASH_WINDOW w;
   String outbuf;
{
   String ids[256];
   Integer i,ct;
   ASH_WINDOW pw;
   String s;
   Character buf[2048];

   ct = 0;
   for (pw = w; pw != NULL; pw = ASHinq_parent(pw)) {
      s = ASHinq_window_id(pw);
      if (s != NULL) ids[ct++] = s;
    };

   buf[0] = 0;
   for (i = ct-1; i >= 0; --i) {
      strcat(buf,ids[i]);
      if (i != 0) strcat(buf,".");
    };

   strcpy(outbuf,buf);

   return outbuf;
};




/************************************************************************/
/*									*/
/*	ASHset_window_defaults -- set defaults for window		*/
/*									*/
/************************************************************************/


void
ASHset_window_defaults(w)
   ASH_WINDOW w;
{
   ASH_DRAWINFO d;
   String s;
   ASH_COLOR c;
   ASH_FONT ft;

   L_PROTECT(w);

   d = w->defaults;
   if (d == NULL || (w->parent != NULL && d == w->parent->defaults)) {
      d = ASHnew_drawinfo(w);
      w->defaults = d;
    };

   s = ASHinq_window_resource(w,"foreground");
   if (s != NULL) {
      c = ASHlookup_color(w,s);
      ASHcolor(d,c);
      ASHtext_color(d,c);
    };

   s = ASHinq_window_resource(w,"background");
   if (s != NULL) {
      c = ASHlookup_color(w,s);
      ASHbackground_color(d,c);
      ASHtext_background_color(d,c);
    };

   s = ASHinq_window_resource(w,"font");
   if (s != NULL) {
      ft = ASHloadfont(s);
      ASHfont(d,ft);
    };

   ASHcopy_drawinfo(w,d);

   L_UNPROTECT(w);

   ASH_call_for_tree(w,set_child_defaults,FALSE);
};




static void
set_child_defaults(w)
   ASH_WINDOW w;
{
   if (w->defaults == NULL && w->parent->defaults != NULL) {
      w->defaults = w->parent->defaults;
    };
};





/************************************************************************/
/*									*/
/*	ASH_set_properties -- set properties for a window		*/
/*									*/
/************************************************************************/


void
ASH_set_properties(d,xw,dflt,ask)
   DISPLAY d;
   Window xw;
   Boolean dflt;
   Boolean ask;
{
   Integer x,y,wd,ht,bwid,dp;
   Window root;
   XSizeHints sh;
   XClassHint ch;
   String s;

   PROTECT;

   XGetGeometry(d->display,xw,&root,&x,&y,&wd,&ht,&bwid,&dp);

   if (dflt) sh.flags = USPosition|USSize;
   else {
      sh.flags = 0;
      if (ask & (XValue|YValue)) sh.flags |= PPosition;
      if (ask & (WidthValue|HeightValue)) sh.flags |= PSize;
    };

   sh.x = x;
   sh.y = y;
   sh.width = wd;
   sh.height = ht;

   s = ASHinq_resource("MinSize");
   if (s != NULL) {
      sscanf(s,"%d %d",&x,&y);
      sh.min_width = x;
      sh.min_height = y;
      sh.flags |= PMinSize;
    };

   s = ASHinq_resource("MaxSize");
   if (s != NULL) {
      sscanf(s,"%d %d",&x,&y);
      sh.max_width = x;
      sh.max_height = y;
      sh.flags |= PMaxSize;
    };

   s = ASHinq_resource("SizeInc");
   if (s != NULL) {
      sscanf(s,"%d %d",&x,&y);
      sh.width_inc = x;
      sh.height_inc = y;
      sh.flags |= PResizeInc;
    };

   s = ASHinq_resource("Aspect");
   if (s != NULL) {
      sscanf(s,"%d %d",&x,&y,&wd,&ht);
      sh.min_aspect.x = x;
      sh.min_aspect.y = y;
      sh.max_aspect.x = wd;
      sh.max_aspect.y = ht;
      sh.flags |= PAspect;
    };

   XSetStandardProperties(d->display,xw,application_name(),
			     application_name(),None,uargv,uargc,&sh);

   ch.res_name = application_name();
   ch.res_class = ch.res_name;
   XSetClassHint(d->display,xw,&ch);

   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	ASH_set_wm_properties -- set wm properties for a window 	*/
/*									*/
/************************************************************************/


void
ASH_set_wm_properties(d,xw)
   DISPLAY d;
   Window xw;
{
   XWMHints wh;

/* if (getenv("PSWM") == NULL) return;          */

   PROTECT;

   wh.flags = InputHint;
   wh.input = TRUE;
   XSetWMHints(d->display,xw,&wh);

   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	initialize_resources -- setup db				*/
/*									*/
/************************************************************************/


static void
initialize_resources()
{
   Character buf[256],bufa[256];
   XrmDatabase ndb;

   PROTECT;

   if (!rm_db_inited) {
      XrmInitialize();

      sprintf(buf,"%s/.Xdefaults",getenv("HOME"));
      if (access(buf,4) >= 0) rm_db = XrmGetFileDatabase(buf);
      else rm_db = NULL;

      gethostname(bufa,256);
      sprintf(buf,"%s/.Xdefaults-%s",getenv("HOME"),bufa);
      if (access(buf,4) >= 0) {
	 ndb = XrmGetFileDatabase(buf);
	 XrmMergeDatabases(ndb,&rm_db);
       };

      XrmParseCommand(&rm_db,opTable,OP_TABLE_SIZE,application_name(),&uargc,&uargv);

      origname = uargname;
      origuargc = uargc;
      origuargv = uargv;
      save_rm_valid = 0;

      rm_db_inited = TRUE;
    };

   UNPROTECT;
};






/************************************************************************/
/*									*/
/*	application_name -- get name of this application		*/
/*									*/
/************************************************************************/


static String
application_name()
{
   String s,t;
   Character nam[1024];
   Boolean fg;
   XrmValue v;

   if (uargname != NULL) return uargname;

   s = uargv[0];

   t = rindex(s,'/');
   if (t != NULL) s = ++t;

   sprintf(nam,"%s.name",s);

   PROTECT;
   fg = XrmGetResource(rm_db,nam,nam,&t,&v);
   UNPROTECT;

   if (fg) s = (String) v.addr;

   uargname = s;

   return s;
};






/* end of ashrm.c */
