/************************************************************************/
/*									*/
/*		ashicon.c						*/
/*									*/
/*	Routines for managing and using user-defined icons		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "ash_local.h"





/************************************************************************/
/*									*/
/*	Type definitions						*/
/*									*/
/************************************************************************/


typedef struct _ASH_ICON *	ASH_ICON;



typedef struct _ASH_ICON {
   String name;
   Integer xsz,ysz;
   Integer * data;
   Integer * swapdata;
   ASH_ICON next;
} ASH_ICON_INFO;






/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	ASH_ICON	first_icon;





/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	ASH_ICON	find_icon();




/************************************************************************/
/*									*/
/*	ASH_icon_init -- module initialization				*/
/*									*/
/************************************************************************/


void
ASH_icon_init()
{
   first_icon = NULL;
};





/************************************************************************/
/*									*/
/*	ASHicon_define -- define a new icon				*/
/*									*/
/************************************************************************/


void
ASHicon_define(name,xsz,ysz,data)
   String name;
   Integer xsz,ysz;
   Integer * data;
{
   ASH_ICON ic;
   Integer sz;

   ic = PALLOC(ASH_ICON_INFO);
   ic->name = SALLOC(name);
   ic->xsz = xsz;
   ic->ysz = ysz;

   PROTECT;
   ic->next = first_icon;
   first_icon = ic;
   UNPROTECT;

   sz = (xsz+31)/32;
   sz *= ysz;
   sz *= 4;
   ic->data = (Integer *) malloc(sz);
   ic->swapdata = NULL;
   bcopy(data,ic->data,sz);
};





/************************************************************************/
/*									*/
/*	ASHicon_draw -- draw a icon as text				*/
/*									*/
/************************************************************************/


void
ASHicon_draw(w,x,y,id)
   ASH_WINDOW w;
   Integer x,y;
   String id;
{
   ASH_ICON ic;
   XImage * im;

   ic = find_icon(id);
   if (ic == NULL) return;

   DRAW_BEGIN(w);

   im = XCreateImage(DISPLAYOF(w),w->display->default_visual,1,XYBitmap,
			0,ic->data,ic->xsz,ic->ysz,32,0);

   im->byte_order = BYTE_ORDER;
   im->bitmap_bit_order = BIT_ORDER;

   x = XMAPVIEW(w,x);
   y = YMAPVIEW(w,y);
   y -= ic->ysz-1;

   if (w->use_view && w->visible) {
      XPutImage(DISPLAYOF(w),w->view_win,w->draw->text_context,im,0,0,x,y,
		   ic->xsz,ic->ysz);
    };

   if (w->full_win != NULL && (!w->frame || w->visible)) {
      x = XMAPVFULL(w,x);
      y = YMAPVFULL(w,y);
      XPutImage(DISPLAYOF(w),w->full_win,w->draw->full_text_context,im,0,0,x,y,
		   ic->xsz,ic->ysz);
    };

   XFree(im);

   DRAW_END(w);
};





/************************************************************************/
/*									*/
/*	ASHicon_size -- get size of icon as text			*/
/*									*/
/************************************************************************/


void
ASHicon_size(id,xsz,ysz)
   String id;
   Integer * xsz, * ysz;
{
   ASH_ICON ic;

   ic = find_icon(id);
   if (ic == NULL) {
      if (xsz != NULL) *xsz = 0;
      if (ysz != NULL) *ysz = 0;
    }
   else {
      if (xsz != NULL) *xsz = ic->xsz;
      if (ysz != NULL) *ysz = ic->ysz;
    };
};





/************************************************************************/
/*									*/
/*	find_icon -- find icon given name				*/
/*									*/
/************************************************************************/


static ASH_ICON
find_icon(id)
   String id;
{
   ASH_ICON ic;
   Character buf[128];

   for (ic = first_icon; ic != NULL; ic = ic->next) {
      if (STREQL(id,ic->name)) break;
    };

   if (ic == NULL) {
      sprintf(buf,"Icon %s not defined",id);
      ERROR(buf);
    };

   return ic;
};





/* end of ashicon.c */
