/************************************************************************/
/*									*/
/*		ash_local.h						*/
/*									*/
/*	Local definitions for ash					*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#define PROT_NAME	ASH__sema
#include <bwethread.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/Xatom.h>
#undef NULLSTRING

#include <DATATYPES.h>
#include <ctype.h>
#include "ash.h"
#include "bpio.h"
#include "bio.h"
#include "biokeys.h"
#include "cmpx.h"





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define NO_BITMAP -1		/* indicator for no bitmap allocated	*/
#define MAXPTS 1024		/* max pts in a polygon/line		*/

#define SAFETY		0x81f3e2d1
#define PROP_SAFETY	0x81f3e2d3

#define MAX_DASHES	16
#define FILL_TABLE_SIZE 	64
#define LINE_TABLE_SIZE 	16
#define BORDER_TABLE_SIZE	16
#define MAX_CONTROL	256
#define MAX_CURSORS	128
#define MAX_FONTS	64

#define FLIP_MAP	1

#ifdef ultrix
#define BYTE_ORDER	LSBFirst
#else
#define BYTE_ORDER	MSBFirst
#endif
#define BIT_ORDER	MSBFirst





/************************************************************************/
/*									*/
/*	Basic ASH data types						*/
/*									*/
/************************************************************************/



typedef struct _CONTROL *CONTROL;
typedef struct _DISPLAY *DISPLAY;

typedef void	(*void_Function_Ptr)();

typedef struct _ASH_LOCK *	ASH_LOCK;




/************************************************************************/
/*									*/
/*	Detailed ASH data structures					*/
/*									*/
/************************************************************************/


typedef struct _BOX {
   Short lx,by,rx,ty;
} BOX;

typedef struct _COORD {
   Short x,y;
} COORD;


typedef struct _DISPLAY_DATA {
   XContext ash_assoc;
   XContext menu_assoc;
   XContext user_assoc;
   XContext id_assoc;
   Pixmap border_tile[BORDER_TABLE_SIZE];
   GC refresh_context;
   GC save_context;
   GC clear_context;
   Cursor cursor_table[MAX_CURSORS];
   Pixmap fill_tile[FILL_TABLE_SIZE];
   Font font_table[MAX_FONTS];
   XFontStruct * font_info[MAX_FONTS];
   XGCValues default_GC;
} * DISPLAY_DATA, __DISPLAY_DATA;



typedef struct _DISPLAY {
   String name;
   Display * display;
   Screen * screen_id;
   DISPLAY next;
   Integer screen;
   Integer root_cnt;
   Boolean dflt;
   Boolean dup;
   Boolean backing_store;
   Boolean save_under;
   DISPLAY_DATA data;
   Integer foreg;
   Integer backg;
   ASH_COLOR_TABLE colormap;
   Visual * default_visual;
   Visual * color_visual;
   Colormap top_colormap;
} __DISPLAY;



typedef enum _CLIP_TYPE {
   CLIP_NONE,
   CLIP_RECTS,
   CLIP_MAP
} CLIP_TYPE;



typedef struct _CLIP_RECT *	CLIP_RECT;

typedef struct _CLIP_RECT {
   CLIP_RECT next;
   BOX rect;
} CLIP_RECT_B;



typedef struct _CLIP_INFO {
   CLIP_TYPE type;
   ASH_WINDOW map;
   Integer numrect;
   CLIP_RECT rect;
} CLIP_INFO_B, * CLIP_INFO;





typedef struct _ASH_DRAWINFO {
   Integer safety;
   GC context;
   GC text_context;
   GC full_context;
   GC full_text_context;
   CLIP_INFO_B clip;
   CLIP_INFO_B outer_clip;
   Boolean use_clip;
   Boolean out_clip;
   Boolean clear_text;
   Boolean nofree;
   Byte    fill_style;
   Byte    line_style;
   Byte    font;
   ASH_WINDOW source;
   ASH_DRAWINFO next;
   ASH_WINDOW window;
} __DRAWINFO;


typedef struct _ASH_WINDOW {		/* window definition		*/
   Integer safety;			/*    value to insure window	*/
   BOX coords;				/*    window coordinate system	*/
   BOX view;				/*    view coordinate system	*/
   Boolean inv_x;			/*    x direction		*/
   Boolean inv_y;			/*    y direction		*/
   COORD base;				/*    location in parent	*/
   COORD view_map;			/*    mapping coords		*/
   COORD full_map;			/*    full mapping from view	*/
   COORD root_map;			/*    mapping to root window	*/
   ASH_WINDOW parent;			/*    parent window		*/
   DISPLAY   display;			/*    display for window	*/
#ifdef X_SAVED_BITMAP
   Window   full_win;			/*    full window/pixmap	*/
#else
   Pixmap   full_win;			/*    full window/pixmap	*/
#endif
   Window   view_win;			/*    view window for drawing	*/
   Window   x_win;			/*    main window for X usage	*/
   ASH_DRAWINFO draw;			/*    draw info for window	*/
   Short depth;
   Short border_width;
   Boolean use_view;			/*    draw in view window	*/
   Boolean  inited;			/*    window is initialized	*/
   Boolean visible;			/*    window is visible 	*/
   Boolean frame;			/*    window is frame		*/
   Boolean courteous;			/*    window is courteous	*/
   Boolean our_court;			/*    faking courteuos windows	*/
   Boolean  saved;			/*    window shd be saved	*/
   Boolean  removed;			/*    window removed		*/
   Boolean  independent;		/*    window is independent	*/
   Boolean  resize;			/*    window was resized	*/
   Boolean  region_refresh;		/*    refresh by regions	*/
   Boolean  many_regions;		/*    too many regions to refresh */
   Boolean noclear;			/*    no initial clear		*/
   Boolean retained;			/*    using X retained windows	*/
   Boolean redraw_input;		/*    use input stream for redraw */
   Boolean use_pixmap;			/*    off_screen window 	*/
   Boolean noredirect;			/*    no redirection for window */
   Boolean rootmap_valid;		/*    root window mapping valid */
   Function_Ptr refresh;		/*    user refresh function	*/
   ASH_SENSE sensitive; 		/*    list of sensitive regions */
   CONTROL control;			/*    controlling routine	*/
   Universal inputdata;
   ASH_CURSOR cursor;
   Boolean cursoron;
   Pixmap bkg_pixmap;
   Integer bkg_pixel;
   ASH_COLOR_TABLE colormap;
#ifndef COURT_IMAGE
   Pixmap under_image;
#else
   XImage * under_image;
#endif
   ASH_WINDOW nextroot;
   ASH_WINDOW grab_by;
   ASH_WINDOW grab_text_by;
   CLIP_RECT damage;
   THREAD thread;
   BWE_SEMA * sema;
   Integer threadct;
   ASH_LOCK lock;
   ASH_WINDOW lock_by;
   ASH_DRAWINFO defaults;
} __WINDOW;





typedef struct _SENSEBOX {		/* sensitive region definition	*/
   ASH_SENSE nextsense; 		/*    pointer to next one	*/
   BOX region;				/*    region of this one	*/
   ASH_WINDOW window;			/*    window of this one	*/
   ASH_SENSE_TYPE value;		/*    value for pattern/color	*/
} __SENSEBOX;





typedef struct _CONTROL {		/* control information		*/
   Function_Ptr routine;		/*    control routine		*/
   CONTROL nextcontrol; 		/*    previous routine		*/
} __CONTROL;





/************************************************************************/
/*									*/
/*	X Definitions							*/
/*									*/
/************************************************************************/


#define INPUT_EVENT_MASK	KeyPressMask|KeyReleaseMask|		\
				ButtonPressMask|ButtonReleaseMask|	\
				PointerMotionMask

#define WINDOW_EVENT_MASK	ExposureMask|VisibilityChangeMask|	\
				   EnterWindowMask|LeaveWindowMask

#define GRAB_EVENT_MASK 	ButtonPressMask|ButtonReleaseMask|	\
				   EnterWindowMask|LeaveWindowMask|	\
				   PointerMotionMask

#define SENSITIVE_MASK		PointerMotionMask|ButtonPressMask|	\
				   ButtonReleaseMask


#define ROOT_EVENT_MASK 	WINDOW_EVENT_MASK|StructureNotifyMask

#define XROOT_EVENT_MASK	0





/************************************************************************/
/*									*/
/*	Macro definitions						*/
/*									*/
/************************************************************************/


#define XMAPVIEW(w,v)	((w)->inv_x ? (w)->view_map.x - (v) : (v) - (w)->view_map.x)
#define YMAPVIEW(w,v)	((w)->inv_y ? (w)->view_map.y - (v) : (v) - (w)->view_map.y)

#define XMAPXVIEW(w,v)	 ((w)->inv_x ? (w)->view.lx - (v) : (v) - (w)->view.lx)
#define YMAPXVIEW(w,v)	 ((w)->inv_y ? (w)->view.ty - (v) : (v) - (w)->view.ty)

#define XMAPVFULL(w,v)	((v) - (w)->full_map.x)
#define YMAPVFULL(w,v)	((v) - (w)->full_map.y)

#define XUNMAPVIEW(w,v)   ((w)->inv_x ? (w)->view_map.x - (v) : (v) + (w)->view_map.x)
#define YUNMAPVIEW(w,v)   ((w)->inv_y ? (w)->view_map.y - (v) : (v) + (w)->view_map.y)

#define XUNMAPXVIEW(w,v)   ((w)->inv_x ? (w)->view.lx - (v) : (v) + (w)->view.lx)
#define YUNMAPXVIEW(w,v)   ((w)->inv_y ? (w)->view.ty - (v) : (v) + (w)->view.ty)

#define CHECKWIN(w,rtn) if (w == NULL || w->safety != SAFETY) FATAL("Bad window passed to rtn ")

#define DRAW_BEGIN(w)		ASH_draw_begin(w,TRUE)
#define DRAW_END(w)		ASH_draw_end(w,TRUE)
#define PROPERTY_BEGIN(w)	ASH_draw_begin(w,FALSE)
#define PROPERTY_END(w) 	ASH_draw_end(w,FALSE);
#define WINDRAW_BEGIN(w)	ASH_draw_begin(w,FALSE)
#define WINDRAW_END(w)		ASH_draw_end(w,FALSE);

#define DISPLAYOF(w)	((w)->display->display)
#define PROPDISPLAYOF(d) DISPLAYOF((d)->window)
#define SCREENOF(w)	((w)->display->screen)
#define DRAWOF(w)	((w)->safety == PROP_SAFETY ? ((ASH_DRAWINFO) (w)) : (w)->draw);
#define FONTOF(f)	(((f) < MAX_FONTS) ? (f) : ASHinq_font(f))

#define L_PROTECT(w)	ASHlock(w)
#define L_UNPROTECT(w)	ASHunlock(w)





/************************************************************************/
/*									*/
/*	Trace/debug/entry definitions					*/
/*									*/
/************************************************************************/


#define TRACE if (ASH__debugfg & ASH_TRACE_ON) ASH_trace
#define ERROR(m) ASH_error(m)
#define FATAL(m) { ERROR(m); abort(); }
#define CHECKINIT if (!ASH__initedflag) ASHinit(ASH_MODE_DISPLAY)
#define ENTER CHECKINIT; TRACE





/************************************************************************/
/*									*/
/*	System definitions						*/
/*									*/
/************************************************************************/


#ifndef FD_SET
#undef NBBY
#undef FD_SETSIZE
#define NBBY	8		/* number of bits in a byte */
/*
 * Select uses bit masks of file descriptors in longs.
 * These macros manipulate such bit fields (the filesystem macros use chars).
 * FD_SETSIZE may be defined by the user, but the default here
 * should be >= NOFILE (param.h).
 */
#define FD_SETSIZE	32

typedef long		fd_mask;
#define NFDBITS (sizeof(fd_mask) * NBBY)	/* bits per mask */
#ifndef howmany
#define howmany(x, y)	(((x)+((y)-1))/(y))
#endif

#define FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif




/************************************************************************/
/*									*/
/*	General functions and definitions				*/
/*									*/
/************************************************************************/


extern	Integer 	ASH__debugfg;
extern	Boolean 	ASH__initedflag;
extern	FILE *		ASH__debugf;

extern	void		ASH_close_display();
extern	DISPLAY 	ASH_find_display();
extern	DISPLAY 	ASH_inq_top_display();
extern	void		ASH_for_all_displays();
extern	void		ASH_error();
extern	void		ASH_trace();





/************************************************************************/
/*									*/
/*	Window management functions					*/
/*									*/
/************************************************************************/


extern	Boolean 	ASH__exiting;

extern	void		ASH_window_init();
extern	void		ASH_window_disp_init();
extern	void		ASH_setup_window();
extern	void		ASH_call_for_tree();
extern	ASH_WINDOW	ASH_find_ash_window();
extern	ASH_WINDOW	ASH_define_window();





/************************************************************************/
/*									*/
/*	Screen management functions					*/
/*									*/
/************************************************************************/


extern	void		ASH_screen_init();
extern	void		ASH_setup_maps();




/************************************************************************/
/*									*/
/*	Window-drawing interface					*/
/*									*/
/************************************************************************/


extern	void		ASH_windraw_init();
extern	void		ASH_windraw_disp_init();
extern	Boolean 	ASH_inq_batched();
extern	void		ASH_draw_begin();
extern	void		ASH_draw_end();
extern	Pixmap		ASH_window_to_pixmap();
extern	Pixmap		ASH_make_pixmap();
extern	void		ASH_window_refresh();
extern	void		ASH_region_refresh();
extern	void		ASH_fix_clip();
extern	Pixmap		ASH_copy_pixmap();
extern	void		ASH_save_under_image();
extern	void		ASH_restore_under_image();
extern	void		ASH_flush_output();





/************************************************************************/
/*									*/
/*	Drawing functions						*/
/*									*/
/************************************************************************/


extern	void		ASH_draw_init();



/************************************************************************/
/*									*/
/*	Property routines						*/
/*									*/
/************************************************************************/


extern	Integer 	ASH__flip_mask;
extern	String		ASH__known_colors[];

extern	void		ASH_property_init();
extern	void		ASH_property_disp_init();
extern	void		ASH_new_drawinfo();
extern	void		ASH_full_drawinfo();
extern	void		ASH_free_drawinfo();
extern	void		ASH_free_full_drawinfo();
extern	Font		ASH_real_font();




/************************************************************************/
/*									*/
/*	Cursor functions						*/
/*									*/
/************************************************************************/


extern	void		ASH_cursor_init();
extern	void		ASH_cursor_disp_init();





/************************************************************************/
/*									*/
/*	Font functions							*/
/*									*/
/************************************************************************/


extern	void		ASH_font_init();





/************************************************************************/
/*									*/
/*	Input interface definitions					*/
/*									*/
/************************************************************************/


extern	void		ASH_input_init();
extern	Boolean 	ASH_event_check_save();
extern	void		ASH_desensitize();
extern	void		ASH_remove_enter();





/************************************************************************/
/*									*/
/*	Utility routines						*/
/*									*/
/************************************************************************/


extern	void		ASH_util_init();





/************************************************************************/
/*									*/
/*	Animation routines						*/
/*									*/
/************************************************************************/


extern	void		ASH_anim_init();





/************************************************************************/
/*									*/
/*	Resource manager routines					*/
/*									*/
/************************************************************************/


extern	void		ASH_rm_init();
extern	void		ASH_rm_disp_init();
extern	void		ASH_set_properties();
extern	void		ASH_set_wm_properties();





/************************************************************************/
/*									*/
/*	Icon routines							*/
/*									*/
/************************************************************************/


extern	void		ASH_icon_init();





/************************************************************************/
/*									*/
/*	Lock routines							*/
/*									*/
/************************************************************************/


extern	void		ASH_lock_init();
extern	Boolean 	ASH_lock_remove();
extern	Boolean 	ASH_lock_refresh();




/************************************************************************/
/*									*/
/*	BPIO interface							*/
/*									*/
/************************************************************************/


extern	void		BPIO_init();
extern	void		BPIO_future_events();





/* end of ash_local.h */
