/************************************************************************/
/*									*/
/*		ash_fill.h						*/
/*									*/
/*	Initial fill patterns for ASH					*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


/* Copyright 1984 Joseph N. Pato, Brown University - All rights reserved.    */
/*
** Last edited by jsb on Fri Nov 16 12:47:33 EST 1984
**	Nov 16 84  jsb: added Halftone (2) and Dk. Halftone (4).  rearranged
**			patterns.  bumped the last two (ifdef'd at the end).
**	Oct  4 83  jnp: original
*/

static short ASH__default_fillstyles[16*16] = {
/*0*/ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* HOLLOW	*/

/*1*/ 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,	/* SOLID	*/
/*1*/ 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,	/* SOLID	*/
/*1*/ 0xffff, 0xffff, 0xffff, 0xffff,			/* SOLID	*/

/*2*/ 0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555,	/* Halftone	*/
/*2*/ 0xaaaa, 0x5555, 0xaaaa, 0x5555, 0xaaaa, 0x5555,	/* Halftone	*/
/*2*/ 0xaaaa, 0x5555, 0xaaaa, 0x5555,			/* Halftone	*/

/*3*/ 0x2222, 0x8888, 0x2222, 0x8888, 0x2222, 0x8888,	/* Lt. Halftone */
/*3*/ 0x2222, 0x8888, 0x2222, 0x8888, 0x2222, 0x8888,	/* Lt. Halftone */
/*3*/ 0x2222, 0x8888, 0x2222, 0x8888,			/* Lt. Halftone */

/*4*/ 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777,	/* Dk. Halftone */
/*4*/ 0xdddd, 0x7777, 0xdddd, 0x7777, 0xdddd, 0x7777,	/* Dk. Halftone */
/*4*/ 0xdddd, 0x7777, 0xdddd, 0x7777,			/* Dk. Halftone */

/*5*/ 0x0808, 0x0000, 0x8080, 0x0000, 0x0808, 0x0000,	/* very light	*/
/*5*/ 0x8080, 0x0000, 0x0808, 0x0000, 0x8080, 0x0000,	/* very light	*/
/*5*/ 0x0808, 0x0000, 0x8080, 0x0000,			/* very light	*/

/*6*/ 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa,	/* Thin Vstripe */
/*6*/ 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa,	/* Thin Vstripe */
/*6*/ 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa,			/* Thin Vstripe */

/*7*/ 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000,	/* Thin Hstripe */
/*7*/ 0xffff, 0x0000, 0xffff, 0x0000, 0xffff, 0x0000,	/* Thin Hstripe */
/*7*/ 0xffff, 0x0000, 0xffff, 0x0000,			/* Thin Hstripe */

/*8*/ 0x9999, 0xcccc, 0x6666, 0x3333, 0x9999, 0xcccc,	/* Thin Lstripe */
/*8*/ 0x6666, 0x3333, 0x9999, 0xcccc, 0x6666, 0x3333,	/* Thin Lstripe */
/*8*/ 0x9999, 0xcccc, 0x6666, 0x3333,			/* Thin Lstripe */

/*9*/ 0x3333, 0x6666, 0xcccc, 0x9999, 0x3333, 0x6666,	/* Thin Rstripe */
/*9*/ 0xcccc, 0x9999, 0x3333, 0x6666, 0xcccc, 0x9999,	/* Thin Rstripe */
/*9*/ 0x3333, 0x6666, 0xcccc, 0x9999,			/* Thin Rstripe */

/*a*/ 0xcccc, 0xcccc, 0xcccc, 0xcccc, 0xcccc, 0xcccc,	/* Thik Vstripe */
/*a*/ 0xcccc, 0xcccc, 0xcccc, 0xcccc, 0xcccc, 0xcccc,	/* Thik Vstripe */
/*a*/ 0xcccc, 0xcccc, 0xcccc, 0xcccc,			/* Thik Vstripe */
							
/*b*/ 0xffff, 0xffff, 0x0000, 0x0000, 0xffff, 0xffff,	/* Thik Hstripe */
/*b*/ 0x0000, 0x0000, 0xffff, 0xffff, 0x0000, 0x0000,	/* Thik Hstripe */
/*b*/ 0xffff, 0xffff, 0x0000, 0x0000,			/* Thik Hstripe */
							
/*c*/ 0xf0f0, 0x7878, 0x3c3c, 0x1e1e, 0x0f0f, 0x8787,	/* Thik Lstripe */
/*c*/ 0xc3c3, 0xe1e1, 0xf0f0, 0x7878, 0x3c3c, 0x1e1e,	/* Thik Lstripe */
/*c*/ 0x0f0f, 0x8787, 0xc3c3, 0xe1e1,			/* Thik Lstripe */
							
/*d*/ 0x0f0f, 0x1e1e, 0x3c3c, 0x7878, 0xf0f0, 0xe1e1,	/* Thik Rstripe */
/*d*/ 0xc3c3, 0x8787, 0x0f0f, 0x1e1e, 0x3c3c, 0x7878,	/* Thik Rstripe */
/*d*/ 0xf0f0, 0xe1e1, 0xc3c3, 0x8787,			/* Thik Rstripe */

/*e*/ 0x7777, 0x7777, 0x2222, 0x2222, 0x7777, 0x7777,	/* Stipple (1)	*/
/*e*/ 0x2222, 0x2222, 0x7777, 0x7777, 0x2222, 0x2222,	/* Stipple (1)	*/
/*e*/ 0x7777, 0x7777, 0x2222, 0x2222,			/* Stipple (1)	*/

/*f*/ 0x0606, 0x0707, 0x0e0e, 0x0606, 0x2020, 0x7070,	/* Stipple (2)	*/
/*f*/ 0xd0d0, 0x6060, 0x0606, 0x0707, 0x0e0e, 0x0606,	/* Stipple (2)	*/
/*f*/ 0x4040, 0x7070, 0xe0e0, 0x6060,			/* Stipple (2)	*/

#ifdef BOZO_PATTERNS
/*e*/ 0xffff, 0x8f8f, 0x1f1f, 0xffff, 0xffff, 0xf8f8,	/* Stipple (5)	*/
/*e*/ 0xf1f1, 0xfdfd, 0xffff, 0x8f8f, 0x1f1f, 0xffff,	/* Stipple (5)	*/
/*e*/ 0xffff, 0xf8f8, 0xf1f1, 0xfdfd,			/* Stipple (5)	*/

/*f*/ 0xffff, 0xbfbf, 0xcfcf, 0xffff, 0xffff, 0xfcfc,	/* Stipple (6)	*/
/*f*/ 0xf9f9, 0xffff, 0xffff, 0xbfbf, 0xcfcf, 0xffff,	/* Stipple (6)	*/
/*f*/ 0xffff, 0xfcfc, 0xf9f9, 0xffff,			/* Stipple (6)	*/

/*f*/ 0xf0f0, 0xf0f0, 0x0f0f, 0x0f0f, 0x0f0f, 0x0f0f,	/* Checkered	*/
/*f*/ 0x0f0f, 0x0f0f, 0x0f0f, 0x0f0f, 0xf0f0, 0xf0f0,	/* Checkered	*/
/*f*/ 0xf0f0, 0xf0f0, 0xf0f0, 0xf0f0,			/* Checkered	*/
#endif
};





/* end of ash_fill.h */
