/************************************************************************/
/*									*/
/*		pearmain.c						*/
/*									*/
/*	Main module for PEAR editor package				*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#define PEAR_MAIN

#include "pear_local.h"






/************************************************************************/
/*									*/
/*	Variable definitions						*/
/*									*/
/************************************************************************/


	Boolean 	PEAR__initedflag = FALSE;
	Integer 	PEAR__tracelvl = 0;
	PROT_DECL;




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


#ifdef	LIB
static			pear_cleanup();
#endif




/************************************************************************/
/*									*/
/*	PEAR_init -- initialize the module				*/
/*									*/
/************************************************************************/


void
PEARinit()
{
   TRACE("PEARinit");

   PROT_INIT;

   PROTECT;

   if (!PEAR__initedflag) {

#ifdef LIB
      BROWNregister_cleanup(pear_cleanup);
#endif

      PEAR_win_init();
      PEAR_menu_init();
      PEAR_edit_init();
      PEAR_ext_init();
      PEAR_depend_init();

      PEAR__initedflag = TRUE;
    }

   UNPROTECT;
};





#ifdef LIB
static
pear_cleanup()
{
   PEAR__tracelvl = 0;
   PEAR__initedflag = 0;
};
#endif





/************************************************************************/
/*									*/
/*	PEARtrace -- set tracing level					*/
/*									*/
/************************************************************************/


void
PEARtrace(lvl)
   Integer lvl;
{
   PEAR__tracelvl = lvl;
};






/************************************************************************/
/*									*/
/*	PEAR_message -- send message to user				*/
/*									*/
/************************************************************************/


void
PEAR_message(w,msg)
   ASH_WINDOW w;
   String msg;
{
   Character buf[1024];

   if (RIPinq_area_window(RIP_AREA_STATUS) != NULL) {
      RIPstatus(msg);
    }
   else {
      sprintf(buf,"\n%s\n%%M  %%a",msg);
      STEMdialog1(w,buf);
    };
};





/************************************************************************/
/*									*/
/*	PEAR_trace -- output trace information				*/
/*									*/
/************************************************************************/


void
PEAR_trace(msg,a1,a2,a3,a4,a5,a6,a7,a8,a9)
   String msg;
   Integer a1,a2,a3,a4,a5,a6,a7,a8,a9;
{
   Character mbf[1024];

   sprintf(mbf,msg,a1,a2,a3,a4,a5,a6,a7,a8,a9);

   printf("PEAR: %s\n",mbf);
};






/************************************************************************/
/*									*/
/*	PEAR_error -- handle error condition for PEAR		       */
/*									*/
/************************************************************************/


/* VARARGS1 */

void
PEAR_error(msg,a1,a2,a3,a4)
   String msg;
   Integer a1,a2,a3,a4;
{
   Character mbf[1024],mbf1[1024];

   ITRACE("PEAR_error %s",msg);

   sprintf(mbf,msg,a1,a2,a3,a4);
   sprintf(mbf1,"ERROR (PEAR) : %s",mbf);

   fprintf(stderr,"%s\n",msg);
   fflush(stderr);
};





/* end of pearmain.c */
