/************************************************************************/
/*									*/
/*		pearext.c						*/
/*									*/
/*	External interface for PEAR object editor package		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "pear_local.h"



/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


static	Function_Ptr		request_fct;
static	Function_Ptr		value_fct;
static	Function_Ptr		assign_fct;
static	Function_Ptr		insert_fct;
static	Function_Ptr		insarc_fct;
static	Function_Ptr		delarc_fct;
static	Function_Ptr		remove_fct;
static	Function_Ptr		select_fct;
static	Function_Ptr		update_fct;
static	Function_Ptr		typein_fct;
static	Function_Ptr		depend_fct;
static	Function_Ptr		eval_fct;
static	Function_Ptr		conn_fct;
static	Function_Ptr		hit_fct;
static	Function_Ptr		cupd_fct;
static	Function_Ptr		refresh_fct;






/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/






/************************************************************************/
/*									*/
/*	PEAR_ext_init -- module initialization				*/
/*									*/
/************************************************************************/


void
PEAR_ext_init()
{
   ITRACE("PEAR_ext_init");

   request_fct = NULL;
   value_fct = NULL;
   assign_fct = NULL;
   insert_fct = NULL;
   insarc_fct = NULL;
   delarc_fct = NULL;
   remove_fct = NULL;
   select_fct = NULL;
   update_fct = NULL;
   typein_fct = NULL;
   depend_fct = NULL;
   eval_fct = NULL;
   conn_fct = NULL;
   hit_fct = NULL;
   cupd_fct = NULL;
   refresh_fct = NULL;
};





/************************************************************************/
/*									*/
/*	PEARregister_interface -- set up external interface		*/
/*									*/
/************************************************************************/


void
PEARregister_interface(rqst,val,asgn,isrt,arc,rmv,darc,sel,
			  upd,typ,dep,evl,conn,hit,cupd,refr)
   Function_Ptr rqst;
   Function_Ptr val;
   Function_Ptr asgn;
   Function_Ptr isrt;
   Function_Ptr arc;
   Function_Ptr rmv;
   Function_Ptr darc;
   Function_Ptr sel;
   Function_Ptr upd;
   Function_Ptr typ;
   Function_Ptr dep;
   Function_Ptr evl;
   Function_Ptr conn;
   Function_Ptr hit;
   Function_Ptr cupd;
   Function_Ptr refr;
{
   ENTER("PEARregister_interface");

   request_fct = rqst;
   value_fct = val;
   assign_fct = asgn;
   insert_fct = isrt;
   insarc_fct = arc;
   remove_fct = rmv;
   delarc_fct = darc;
   select_fct = sel;
   update_fct = upd;
   typein_fct = typ;
   depend_fct = dep;
   eval_fct = evl;
   conn_fct = conn;
   hit_fct = hit;
   cupd_fct = cupd;
   refresh_fct = refr;
};





/************************************************************************/
/*									*/
/*	PEAR_ext_request_value -- get value to use from user		*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_request_value(w,t,vp,tp)
   ASH_WINDOW w;
   Universal t;
   Universal *vp;
   Universal *tp;
{
   register Boolean fg;

   *vp = NULL;
   *tp = NULL;

   if (request_fct == NULL) fg = FALSE;
   else {
      fg = (*request_fct)(w,t,vp,tp);
    };

   ITRACE("PEAR_ext_request_value 0x%x 0x%x => %d (0x%x : 0x%x)",w,t,fg,*vp,*tp);

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_ext_gelo_value -- get value from displayed object		*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_gelo_value(obj,acttypfg,vp,tp)
   GELO_OBJECT obj;
   Boolean acttypfg;
   Universal *vp;
   Universal *tp;
{
   register Boolean fg;
   Universal s,f,idx,v,t;

   fg = FALSE;
   if (value_fct != NULL) {
      s = GELOinq_source_object(obj);
      if (s != NULL) {
	 f = GELOinq_source_field(obj);
	 idx = GELOinq_source_index(obj);
	 v = GELOinq_user_structure(obj);
	 t = GELOinq_source_type(obj);
	 fg = (*value_fct)(s,f,idx,acttypfg,&v,&t);
       };
    };

   if (!fg) {
      v = GELOinq_user_structure(obj);
      t = GELOinq_source_type(obj);
      fg = (v != NULL);
    };

   *vp = v;
   *tp = t;

   ITRACE("PEAR_ext_gelo_value 0x%x %d => %d (0x%x : 0x%x)",obj,acttypfg,fg,v,t);

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_ext_assign_value -- assign to a field			*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_assign_value(w,obj,val,typ,valfg,copyfg,autofg,cntfg)
   ASH_WINDOW w;
   GELO_OBJECT obj;
   Universal val,typ;
   Boolean valfg,copyfg,autofg,cntfg;
{
   register Boolean fg;
   Universal s,f,idx,t;

   ITRACE("PEAR_ext_assign_value 0x%x 0x%x %d %d %d %d",obj,val,valfg,copyfg,autofg,cntfg);

   fg = FALSE;
   if (assign_fct != NULL) {
      if (cntfg) {
	 s = GELOinq_user_structure(obj);
	 f = GELOinq_contents(obj);
	 t = GELOinq_source_type(obj);
	 if (s == NULL || f == NULL) cntfg = FALSE;
	 else {
	    fg = (*assign_fct)(w,s,f,-1,t,val,typ,valfg,copyfg,autofg);
	  };
       };
      if (!cntfg) {
	 s = GELOinq_source_object(obj);
	 if (s != NULL) {
	    f = GELOinq_source_field(obj);
	    idx = GELOinq_source_index(obj);
	    t = GELOinq_source_type(obj);
	    fg = (*assign_fct)(w,s,f,idx,t,val,typ,valfg,copyfg,autofg);
	  }
	 else {
	    PEAR_message(ASHinq_top(),"Can't assign to valueless object");
	  };
       };
    };

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_ext_layout_value -- insert node into layout		*/
/*	PEAR_ext_layout_arc_insert -- insert arc into layout		 */
/*	PEAR_ext_layout_arc_remove -- remove arc from layout		*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_layout_value(layv,last,val,valfg,copy,after,first)
   Universal layv;
   GELO_OBJECT last;
   Universal val;
   Boolean valfg,copy;
   Boolean after,first;
{
   Universal s,f,idx;
   register Boolean fg;

   ITRACE("PEAR_ext_layout_value 0x%x 0x%x 0x%x %d %d %d %d",
	     layv,last,val,valfg,copy,after,first);

   fg = FALSE;
   if (insert_fct != NULL) {
      if (last != NULL) {
	 s = GELOinq_source_object(last);
	 f = GELOinq_source_field(last);
	 idx = GELOinq_source_index(last);
       }
      else {
	 s = NULL;
	 f = NULL;
	 idx = -1;
       };
      fg = (*insert_fct)(layv,s,f,idx,val,valfg,copy,after,first);
    };

   return fg;
};






Boolean
PEAR_ext_layout_arc_insert(layv,from,to)
   Universal layv;
   GELO_OBJECT from,to;
{
   Universal s1,f1,idx1,s2,f2,idx2;
   register Boolean fg;

   ITRACE("PEAR_ext_layout_arc_insert 0x%x 0x%x 0x%x",layv,from,to);

   fg = FALSE;
   if (insarc_fct != NULL) {
      if (from == NULL) return FALSE;
      s1 = GELOinq_source_object(from);
      f1 = GELOinq_source_field(from);
      idx1 = GELOinq_source_index(from);
      if (s1 == NULL) return FALSE;
      if (to == NULL) {
	 s2 = NULL;
	 f2 = NULL;
	 idx2 = -1;
       }
      else {
	 s2 = GELOinq_source_object(to);
	 f2 = GELOinq_source_field(to);
	 idx2 = GELOinq_source_index(to);
	 if (s2 == NULL) return FALSE;
       };
      fg = (*insarc_fct)(layv,s1,f1,idx1,s2,f2,idx2);
    };

   return fg;
};





Boolean
PEAR_ext_layout_arc_remove(layv,from,to)
   Universal layv;
   GELO_OBJECT from,to;
{
   Universal s1,f1,idx1,s2,f2,idx2;
   register Boolean fg;

   ITRACE("PEAR_ext_layout_arc_remove 0x%x 0x%x 0x%x",layv,from,to);

   fg = FALSE;
   if (delarc_fct != NULL) {
      if (from == NULL || to == NULL) return FALSE;
      s1 = GELOinq_source_object(from);
      f1 = GELOinq_source_field(from);
      idx1 = GELOinq_source_index(from);
      s2 = GELOinq_source_object(to);
      f2 = GELOinq_source_field(to);
      idx2 = GELOinq_source_index(to);
      if (s1 == NULL || s2 == NULL) return FALSE;
      fg = (*delarc_fct)(layv,s1,f1,idx1,s2,f2,idx2);
    };

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_ext_layout_remove -- remove node/arc from layout		*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_layout_remove(obj)
   GELO_OBJECT obj;
{
   register Boolean fg;
   Universal s,f,idx;

   ITRACE("PEAR_ext_layout_remove 0x%x",obj);

   fg = FALSE;
   if (remove_fct != NULL) {
      s = GELOinq_source_object(obj);
      if (s == NULL) {
	 PEAR_message(ASHinq_top(),"Nothing to remove");
	 return FALSE;
       };
      f = GELOinq_source_field(obj);
      idx = GELOinq_source_index(obj);
      fg = (*remove_fct)(s,f,idx);
    };

   return fg;
};






/************************************************************************/
/*									*/
/*	PEAR_ext_select -- handle selections				*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_select(obj,btn)
   GELO_OBJECT obj;
   Integer btn;
{
   register Boolean fg;
   register Universal v;

   ITRACE("PEAR_ext_select 0x%x %d",obj,btn);

   fg = FALSE;
   if (select_fct != NULL) {
      v = GELOinq_user_structure(obj);
      if (v == NULL && GELOinq_source_object(obj) == NULL &&
	     GELOinq_parent(obj) != NULL) {
	 fg = FALSE;
       }
      else fg = TRUE;

      fg = (*select_fct)(v,btn,fg);
    };

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_ext_update -- handle update request			*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_update(obj,ffg)
   GELO_OBJECT obj;
   Boolean ffg;
{
   register Boolean fg;
   register Universal v;

   ITRACE("PEAR_ext_update 0x%x %d",obj,ffg);

   fg = TRUE;
   if (update_fct != NULL) {
      v = GELOinq_user_structure(obj);
      if (v != NULL) fg = (*update_fct)(v,ffg);
    };

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_ext_typein -- check for applicable typein			*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_typein(ch,obj,obj1,obj2)
   Integer ch;
   GELO_OBJECT obj,obj1,obj2;
{
   register Universal v,v1,v2,v3;
   register Boolean fg;

   ITRACE("PEAR_ext_typein 0x%x 0x%x",obj,ch);

   if (typein_fct == NULL) fg = FALSE;
   else if (FKEY_TEST_PLAIN(ch)) {
      if (obj == NULL) v = NULL;
      else v = GELOinq_user_structure(obj);
      if (obj1 == NULL) v1 = NULL;
      else v1 = GELOinq_user_structure(obj1);
      if (obj2 == NULL) v2 = NULL;
      else v2 = GELOinq_user_structure(obj2);
      while (obj != NULL) {
	 obj = GELOinq_parent(obj);
	 if (obj == NULL) break;
	 v3 = GELOinq_user_structure(obj);
	 if (v3 != v) break;
       };
      if (obj == NULL) v3 = NULL;
      fg = (*typein_fct)(ch-FKEY_FIRST,v,v1,v2,v3);
    }
   else fg = FALSE;

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_ext_depend_notify -- handle dependency interface		*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_depend_notify(pd,obj,newfg)
   PEAR_DATA pd;
   Universal obj;
   Boolean newfg;
{
   register Boolean fg;

   ITRACE("PEAR_ext_depend_notify 0x%x 0x%x %d",pd,obj,newfg);

   if (depend_fct != NULL) {
      fg = (*depend_fct)(pd->window,obj,newfg);
    }
   else fg = FALSE;

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_ext_evaluate -- handle evaluation requests 		*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_evaluate(obj,type)
   Universal obj;
   Integer type;
{
   register Boolean fg;

   ITRACE("PEAR_ext_evaluate 0x%x %d",obj,type);

   fg = TRUE;

   if (eval_fct != NULL) {
      fg = (*eval_fct)(obj,type);
    };

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_ext_conn_port -- get port for a connection 		*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_conn_port(from,to,arc,tofg,portp,sportp)
   GELO_OBJECT from;
   GELO_OBJECT to;
   GELO_OBJECT arc;
   Boolean tofg;
   GELO_PORT * portp;
   Integer * sportp;
{
   Universal f,t,a;
   register Boolean fg;

   ITRACE("PEAR_ext_conn_port 0x%x 0x%x 0x%x %d",from,to,arc,tofg);

   f = GELOinq_user_structure(from);
   t = (to == NULL ? NULL : GELOinq_user_structure(to));
   a = (arc == NULL ? NULL : GELOinq_user_structure(arc));

   if (conn_fct == NULL) fg = FALSE;
   else {
      fg = (*conn_fct)(f,t,a,tofg,portp,sportp);
    };

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_ext_hit -- handle hit in application spot of editor	*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_hit(pd,x,y,ch,btn)
   PEAR_DATA pd;
   Integer x,y;
   Integer ch;
   Integer btn;
{
   register Boolean fg;

   ITRACE("PEAR_ext_hit 0x%x %d %d 0x%x 0x%x",pd,x,y,ch,btn);

   if (hit_fct == NULL) fg = TRUE;
   else {
      fg = (*hit_fct)(pd->window,x,y,ch,btn);
    };

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_ext_inq_cmd_update -- check if application is doing cmd upd*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_inq_cmd_update(pd)
   PEAR_DATA pd;
{
   ITRACE("PEAR_ext_inq_cmd_update");

   if (cupd_fct == NULL) return FALSE;

   return (*cupd_fct)(pd);
};





/************************************************************************/
/*									*/
/*	PEAR_ext_refresh -- notify user of refresh			*/
/*									*/
/************************************************************************/


void
PEAR_ext_refresh(pd)
   PEAR_DATA pd;
{
   if (refresh_fct != NULL) (*refresh_fct)(pd->window);
};





/************************************************************************/
/*									*/
/*	PEAR_ext_inq_do_depend -- check if application doing depends	*/
/*									*/
/************************************************************************/


Boolean
PEAR_ext_inq_do_depend()
{
   ITRACE("PEAR_ext_inq_do_depend");

   return (depend_fct != NULL);
};





/* end of pearext.c */



