/************************************************************************/
/*									*/
/*		pearedit.c						*/
/*									*/
/*	Editing routines for PEAR picture editor package		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "pear_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	void			begin_update();
static	void			edit_update();
static	int			port_compute();




/************************************************************************/
/*									*/
/*	PEAR_edit_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
PEAR_edit_init()
{
   ITRACE("PEAR_edit_init");

   GELOconnect_port_routine(port_compute);
};





/************************************************************************/
/*									*/
/*	PEAR_edit_replace -- handle replace command			*/
/*									*/
/************************************************************************/


int
PEAR_edit_replace(pd,menu,btn)
   PEAR_DATA pd;
   String menu;
   String btn;
{
   Universal v,t;
   Boolean vfg,copyfg,autofg,cntfg;
   register Boolean fg;

   ITRACE("PEAR_edit_replace 0x%x %s %s",pd,menu,btn);

   if (pd->update_delay) return FALSE;

   if (pd->selects[SELECT1] == NULL) {
      PEAR_message(pd->window,"Nothing to replace");
      return FALSE;
    }
   else if (!PEAR_ext_gelo_value(pd->selects[SELECT1],TRUE,&v,&t)) {
      PEAR_message(pd->window,"No value associated with selection");
      return FALSE;
    };

   copyfg = FALSE;
   autofg = FALSE;
   cntfg = FALSE;

   if (STREQL(btn,"Set Contents") || STREQL(btn,"Copy Contents")) {
      cntfg = TRUE;
    };

   if (STREQL(btn,"New Value") || STREQL(btn,"Delete")) {
      vfg = TRUE;
      v = NULL;
      t = NULL;
    }
   else if (STREQL(btn,"Expand")) {
      vfg = FALSE;
      v = NULL;
      t = NULL;
      autofg = TRUE;
    }
   else if (pd->selects[SELECT2] == NULL) {
      vfg = FALSE;
      v = NULL;
      t = NULL;
    }
   else {
      if (!PEAR_ext_gelo_value(pd->selects[SELECT2],TRUE,&v,&t)) {
	 PEAR_message(pd->window,"No value associated with second selection");
	 return FALSE;
       };
      if (STREQL(btn,"Copy Value") || STREQL(btn,"Copy Contents")) copyfg = TRUE;
      vfg = TRUE;
    };

   begin_update(pd,pd->selects[SELECT1],pd->selinsets[SELECT1]);

   fg = PEAR_ext_assign_value(pd->window,pd->selects[SELECT1],v,t,vfg,copyfg,autofg,cntfg);

   if (fg) PEAR_ext_update(pd->selects[SELECT1],FALSE);

   edit_update(pd);

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_edit_insert -- handle INSERT command			*/
/*									*/
/************************************************************************/


int
PEAR_edit_insert(pd,menu,btn)
   PEAR_DATA pd;
   String menu;
   String btn;
{
   register GELO_OBJECT last,lay;
   Universal layv,layt;
   Universal lastv,lastt;
   Universal val;
   Boolean after,first,copy,valfg;
   register Boolean fg;

   ITRACE("PEAR_edit_insert 0x%x %s %s",pd,menu,btn);

   if (pd->update_delay) return FALSE;

   if (STREQL(btn,"Insert")) {
      after = FALSE;
      copy = FALSE;
    }
   else if (STREQL(btn,"Append")) {
      after = TRUE;
      copy = FALSE;
    }
   else if (STREQL(btn,"Insert Copy")) {
      after = FALSE;
      copy = TRUE;
    }
   else {
      after = TRUE;
      copy = TRUE;
    };

   last = NULL;
   for (lay = pd->selects[SELECT1]; lay != NULL; lay = GELOinq_parent(lay)) {
      if (GELOinq_flavor(lay) == GELO_FLAVOR_LAYOUT) break;
      last = lay;
    };

   if (lay == NULL || !PEAR_ext_gelo_value(lay,TRUE,&layv,&layt)) {
      PEAR_message(pd->window,"No place in insert");
      return FALSE;
    };

   first = (last == NULL);

   if (pd->selects[SELECT2] == NULL) {
      val = NULL;
      valfg = FALSE;
      if (copy && last != NULL && PEAR_ext_gelo_value(last,TRUE,&lastv,&lastt)) {
	 val = lastv;
	 valfg = TRUE;
       };
    }
   else if (!PEAR_ext_gelo_value(pd->selects[SELECT2],TRUE,&lastv,&lastt)) {
      PEAR_message(pd->window,"No value to insert");
      val = NULL;
      valfg = FALSE;
    }
   else {
      val = lastv;
      valfg = TRUE;
    };

   if (STRNEQ(menu,"DUMMY")) begin_update(pd,lay,pd->selinsets[SELECT1]);

   fg = PEAR_ext_layout_value(layv,last,val,valfg,copy,after,first);

   if (fg) PEAR_ext_update(lay,FALSE);

   if (STRNEQ(menu,"DUMMY")) edit_update(pd);

   return fg;
};






/************************************************************************/
/*									*/
/*	PEAR_edit_remove -- handle REMOVE command			*/
/*									*/
/************************************************************************/


int
PEAR_edit_remove(pd,menu,btn)
   PEAR_DATA pd;
   String menu;
   String btn;
{
   register GELO_OBJECT last,lay;
   Universal layv,layt;
   register Boolean fg;

   ITRACE("PEAR_edit_remove 0x%x %s %s",pd,menu,btn);

   if (pd->update_delay) return FALSE;

   if (pd->selects[SELECT1] == NULL) {
      PEAR_message(pd->window,"Must select object to remove or delete");
      return FALSE;
    };

   last = NULL;
   for (lay = pd->selects[SELECT1]; lay != NULL; lay = GELOinq_parent(lay)) {
      if (GELOinq_flavor(lay) == GELO_FLAVOR_LAYOUT) break;
      last = lay;
    };

   if (STREQL(btn,"Remove")) {
      if (lay == NULL || last == NULL ||
	     !PEAR_ext_gelo_value(lay,TRUE,&layv,&layt)) {
	 PEAR_message(pd->window,"Nothing to remove");
	 return FALSE;
       };
    }
   else {
      if (last != pd->selects[SELECT1] || lay == NULL) {
	 return PEAR_edit_replace(pd,menu,btn);
       };
    };

   begin_update(pd,lay,pd->selinsets[SELECT1]);

   fg = PEAR_ext_layout_remove(last);

   if (fg) PEAR_ext_update(last,FALSE);

   edit_update(pd);

   return fg;
};






/************************************************************************/
/*									*/
/*	PEAR_edit_arc -- add an arc to a layout command 		*/
/*									*/
/************************************************************************/


int
PEAR_edit_arc(pd,menu,btn)
   PEAR_DATA pd;
   String menu;
   String btn;
{
   register GELO_OBJECT last,last2,lay,lay2,sel2;
   Universal layv,layt;
   Boolean delfg;
   register Boolean fg;

   ITRACE("PEAR_edit_arc 0x%x %s %s",pd,menu,btn);

   fg = TRUE;

   if (pd->update_delay) return FALSE;

   if (STREQL(btn,"Remove Arc")) delfg = TRUE;
   else delfg = FALSE;

   last = NULL;
   for (lay = pd->selects[SELECT1]; lay != NULL; lay = GELOinq_parent(lay)) {
      if (GELOinq_flavor(lay) == GELO_FLAVOR_LAYOUT) break;
      last = lay;
    };

   sel2 = pd->selects[SELECT2];
   if (STREQL(btn,"Connect New") && last != NULL) {
      sel2 = NULL;
    }
   else if (sel2 == NULL) {
      if (delfg)
	 PEAR_message(pd->window,"Target of arc to remove must be specified");
      else
	 PEAR_message(pd->window,"Target of arc to add must be specified");
      fg = FALSE;
    };

   if (fg && pd->selects[SELECT1] == NULL) {
      if (delfg)
	 PEAR_message(pd->window,"Source of arc to remove must be specified");
      else
	 PEAR_message(pd->window,"Source of arc to add must be specified");
      fg = FALSE;
    };

   if (fg && (lay == NULL || !PEAR_ext_gelo_value(lay,TRUE,&layv,&layt))) {
      if (delfg)
	 PEAR_message(pd->window,"No place in delete arc");
      else
	 PEAR_message(pd->window,"No place in insert arc");
      fg = FALSE;
    };

   last2 = NULL;
   lay2 = NULL;
   if (fg && sel2 != NULL) {
      for (lay2 = sel2; lay2 != NULL; lay2 = GELOinq_parent(lay2)) {
	 if (GELOinq_flavor(lay2) == GELO_FLAVOR_LAYOUT) break;
	 last2 = lay2;
       };
      if (lay2 != lay || lay2 == NULL) {
	 PEAR_message(pd->window,"Source and target of arc must be in the same layout");
	 fg = FALSE;
       };
    };

   if (fg && last == NULL) {
      if (last2 == NULL && lay2 == lay) {
	 PEAR_select(pd,SELECT2,NULL,FALSE,FALSE,TRUE);
	 fg = PEAR_edit_insert(pd,menu,"Append");
	 return fg;
       };
      PEAR_message(pd->window,"Source of arc must be in a layout");
      fg = FALSE;
    };

   PEAR_select(pd,SELECT1,NULL,FALSE,FALSE,TRUE);
   PEAR_select(pd,SELECT2,NULL,FALSE,FALSE,TRUE);

   if (fg) {
      begin_update(pd,lay,pd->selinsets[SELECT1]);

      if (delfg) {
	 fg = PEAR_ext_layout_arc_remove(layv,last,last2);
       }
      else {
	 fg = PEAR_ext_layout_arc_insert(layv,last,last2);
       };

      if (fg) PEAR_ext_update(lay,FALSE);

      edit_update(pd);
    };

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_edit_select -- handle selection of objects 		*/
/*									*/
/************************************************************************/


/* VARARGS3 */

int
PEAR_edit_select(pd,menu,btn,selobj)
   PEAR_DATA pd;
   String menu;
   String btn;
   GELO_OBJECT selobj;
{
   register GELO_OBJECT obj;
   register Integer btnno;
   register Boolean fg;

   ITRACE("PEAR_edit_select 0x%x %s %s",pd,menu,btn);

   if (pd->update_delay) return FALSE;

   fg = TRUE;

   if (STREQL(btn,"Make Current")) {
      btnno = 0;
      obj = pd->selects[SELECT1];
      if (obj == NULL) {
	 PEAR_message(pd->window,"Nothing to make current");
	 fg = FALSE;
       };
    }
   else if (STREQL(btn,"Mouse1")) {
      btnno = 1;
      obj = selobj;
    }
   else if (STREQL(btn,"Mouse2")) {
      btnno = 2;
      obj = selobj;
    }
   else if (STREQL(btn,"Mouse3")) {
      btnno = 3;
      obj = selobj;
    }
   else if (STREQL(btn,"Mouse4")) {
      btnno = 4;
      obj = selobj;
    }
   else if (STREQL(btn,"Mouse5")) {
      btnno = 5;
      obj = selobj;
    }
   else if (STREQL(btn,"Mouse6")) {
      btnno = 6;
      obj = selobj;
    }
   else if (STREQL(btn,"Mouse7")) {
      btnno = 7;
      obj = selobj;
    }
   else fg = FALSE;

   if (fg) fg = PEAR_ext_select(obj,btnno);

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_edit_create -- handle new object creation			*/
/*									*/
/************************************************************************/


int
PEAR_edit_create(pd,menu,btn)
   PEAR_DATA pd;
   String menu;
   String btn;
{
   Universal v,t;
   Boolean fg;

   ITRACE("PEAR_edit_create 0x%x %s %s",pd,menu,btn);

   if (pd->update_delay) return FALSE;

   fg = TRUE;

   if (pd->selects[SELECT2] == NULL) {
      if (!PEAR_ext_request_value(pd->window,NULL,&v,&t)) fg = FALSE;
    }
   else {
      if (!PEAR_ext_gelo_value(pd->selects[SELECT2],TRUE,&v,&t)) {
	 PEAR_message(pd->window,"No value associated with second selection");
	 fg = FALSE;
       };
    };

   if (!fg) ;
   else if (STREQL(btn,"New Inset")) {
      pd->inobject = v;
      pd->intype = t;
      pd->in_depend = FALSE;
      pd->in_changed = FALSE;
      PEAR_insetrefresh(pd,TRUE);
    }
   else if (pd->object == NULL) {
      pd->object = v;
      pd->type = t;
      PEAR_refresh(pd,TRUE,FALSE,FALSE);
    }
   else {
      PEAR_message(pd->window,"Can't replace top level value");
      fg = FALSE;
    };

   return fg;
};





/************************************************************************/
/*									*/
/*	PEAR_edit_update -- handle user update/compile request		*/
/*									*/
/************************************************************************/


int
PEAR_edit_update(pd,menu,btn)
   PEAR_DATA pd;
   String menu;
   String btn;
{
   register GELO_OBJECT obj;

   ITRACE("PEAR_edit_update 0x%x %s %s",pd,menu,btn);

   if (pd->update_delay) return FALSE;

   if (STREQL(btn,"Fixup")) obj = pd->topgeloobj;
   else obj = pd->selects[SELECT1];

   if (obj != NULL) {
      PEAR_ext_update(obj,TRUE);
    }
   else {
      PEAR_message(pd->window,"Nothing to fix or update");
    };

   return TRUE;
};





/************************************************************************/
/*									*/
/*	PEAR_update_obj -- update a single object			*/
/*									*/
/************************************************************************/


void
PEAR_update_obj(pd,obj,infg)
   PEAR_DATA pd;
   GELO_OBJECT obj;
   Boolean infg;
{
   Universal v,t;
   Integer sty;
   GELO_OBJECT nobj,onobj;
   register Boolean layfg,cmpfg;
   register Integer i;

   ITRACE("PEAR_update_obj 0x%x 0x%x %d",pd,obj,infg);

   for (sty = 0; sty < MAX_SELECT; ++sty) {
      if (pd->selects[sty] == obj) break;
    };
   if (sty >= MAX_SELECT) sty = -1;

   layfg = (GELOinq_flavor(obj) == GELO_FLAVOR_LAYOUT);
   nobj = GELOinq_parent(obj);
   if (GELOinq_flavor(obj) == GELO_FLAVOR_DATA && nobj != NULL &&
	  GELOinq_flavor(nobj) == GELO_FLAVOR_TILED &&
	  ((GELO_SHAPE) GELOinq_attribute(obj,GELO_DATA_ATTR_SHAPE) == GELO_SHAPE_FLD_PTR ||
	      (GELO_SHAPE) GELOinq_attribute(obj,GELO_DATA_ATTR_SHAPE) == GELO_SHAPE_NULL_PTR)) {
      nobj = GELOinq_parent(nobj);
    };

   if (!layfg && nobj != NULL && GELOinq_flavor(nobj) == GELO_FLAVOR_LAYOUT) {
      PEAR_update_obj(pd,nobj,infg);
    }
   else if (PEAR_ext_gelo_value(obj,TRUE,&v,&t)) {
      onobj = APPLEgelo_create(v,t,NULL,layfg,pd);
      cmpfg = GELOcompare(obj,onobj,&obj,&nobj);
      if (!cmpfg) {
	 for (i = 0; i < MAX_SELECT; ++i) {
	    PEAR_select(pd,i,NULL,FALSE,FALSE,TRUE);
	  };
	 if (infg) {
	    if (pd->ingeloobj == obj) pd->ingeloobj = nobj;
	    GELOwindow_replace(pd->insetwin,obj,nobj);
	    GELOwindow_free(pd->insetwin,obj);
	    pd->in_changed = TRUE;
	  }
	 else {
	    if (pd->topgeloobj == obj) pd->topgeloobj = nobj;
	    GELOwindow_replace(pd->gelowin,obj,nobj);
	    GELOwindow_free(pd->gelowin,obj);
	  };
	 if (sty >= 0) PEAR_select(pd,sty,nobj,infg,FALSE,TRUE);
	 GELOwindow_free_except(pd->gelowin,onobj,nobj);
       }
      else {
	 GELOwindow_free(pd->gelowin,onobj);
       };
    }
   else if (infg) {
      PEAR_insetrefresh(pd,TRUE);
    }
   else {
      PEAR_refresh(pd,TRUE,FALSE,TRUE);
    };
};






/************************************************************************/
/*									*/
/*	PEAR_update_begin -- begin update for object			*/
/*	PEARupdate_end_command -- handle end of command for updates	*/
/*									*/
/************************************************************************/


void
PEAR_update_begin(pd)
   PEAR_DATA pd;
{
   ITRACE("PEAR_update_begin 0x%x",pd);

   if (pd->update_delay) return;

   begin_update(pd,NULL,FALSE);
};





void
PEARupdate_end_command(pd)
   PEAR_DATA pd;
{
   ITRACE("PEARupdate_end_command 0x%x",pd);

   if (pd->update_delay) {
      edit_update(pd);
    };
};





/************************************************************************/
/*									*/
/*	begin_update-- begin updating an object 			*/
/*	edit_update -- finish updating object				*/
/*									*/
/************************************************************************/


static void
begin_update(pd,obj,infg)
   PEAR_DATA pd;
   GELO_OBJECT obj;
   Boolean infg;
{
   register GELO_OBJECT nobj;
   register Boolean layfg;

   DTRACE("begin_update 0x%x 0x%x %d",pd,obj,infg);

   if (obj != NULL) {
      layfg = (GELOinq_flavor(obj) == GELO_FLAVOR_LAYOUT);
      nobj = GELOinq_parent(obj);
    }
   else {
      layfg = FALSE;
      nobj = NULL;
    };

   if (!layfg && nobj != NULL && GELOinq_flavor(nobj) == GELO_FLAVOR_LAYOUT) {
      begin_update(pd,nobj,infg);
    }
   else {
      pd->update_delay = TRUE;
      if (infg) {
	 pd->update_selobj = obj;
	 pd->update_obj = NULL;
       }
      else {
	 pd->update_selobj = NULL;
	 pd->update_obj = obj;
       };
      pd->update_all = FALSE;
      pd->update_selall = FALSE;
    };
};





static void
edit_update(pd)
   PEAR_DATA pd;
{
   DTRACE("edit_update 0x%x",pd);

   if (pd->update_selobj != NULL || pd->update_selall) {
      if (pd->update_selall) pd->update_selobj = pd->ingeloobj;
      PEAR_update_obj(pd,pd->update_selobj,TRUE);
    };

   if (pd->update_obj != NULL || pd->update_all) {
      if (pd->update_all) pd->update_obj = pd->topgeloobj;
      PEAR_update_obj(pd,pd->update_obj,FALSE);
    };

   pd->update_delay = FALSE;
};






/************************************************************************/
/*									*/
/*	port_compute -- compute port for node				*/
/*									*/
/************************************************************************/


static int
port_compute(from,to,arc,tofg,port,sport)
   GELO_OBJECT from;
   GELO_OBJECT to;
   GELO_OBJECT arc;
   Boolean tofg;
   GELO_PORT * port;
   Integer *sport;
{
   register Boolean fg;

   ITRACE("port_compute 0x%x 0x%x 0x%x %d",from,to,arc,tofg);

   if (from == NULL) return FALSE;
   if (to == NULL && from != arc) return FALSE;

   fg = PEAR_ext_conn_port(from,to,arc,tofg,port,sport);

   return fg;
};





/* end of pearedit.c */
