/************************************************************************/
/*									*/
/*		pear_local.h						*/
/*									*/
/*	Local definitions for the PEAR picture editor			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#define PROT_NAME	PEAR__sema
#include <bwethread.h>

#include <ctype.h>
#include <DATATYPES.h>
#include <ash.h>
#include <bio.h>
#include <stem.h>
#include <leaf.h>
#include <sequence.h>
#include <gelo.h>
#include <apple.h>
#include "pear.h"
#include <biokeys.h>

#include "apple_gelo.h"





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_SELECT	7

#define SELECT1 	1
#define SELECT2 	2
#define SELECT3 	3
#define DOWN_SELECT	4
#define EXEC_SELECT	5

#define GELO_METHOD_SELECTABLE	0x10000




/************************************************************************/
/*									*/
/*	Data Type Definitions						*/
/*									*/
/************************************************************************/


typedef struct _PEAR_DATA *	PEAR_DATA;




typedef struct _PEAR_DATA {
   Universal	id;
   ASH_WINDOW	window;
   ASH_WINDOW	gelowin;
   ASH_WINDOW	menuwin;
   ASH_WINDOW	vscroll;
   ASH_WINDOW	hscroll;
   ASH_WINDOW	insetwin;
   Universal	object;
   Universal	type;
   Universal	inobject;
   Universal	intype;
   GELO_OBJECT	topgeloobj;
   GELO_OBJECT	geloobj;
   String	match;
   GELO_OBJECT	ingeloobj;
   Integer	last_x,last_y;
   Integer	down_x,down_y;
   Integer	down_fg;
   GELO_OBJECT	update_obj;
   GELO_OBJECT	update_selobj;
   Boolean	update_delay;
   Boolean	update_all;
   Boolean	update_selall;
   Boolean	havegelo;
   Boolean	haveingelo;
   Boolean	redraw;
   Boolean	insetredraw;
   Boolean	showinset;
   Boolean	in_depend;
   Boolean	in_changed;
   GELO_OBJECT	selects[MAX_SELECT];
   Boolean	selinsets[MAX_SELECT];
} PEAR_DATA_B;





/************************************************************************/
/*									*/
/*	Storage 							*/
/*									*/
/************************************************************************/


extern	Sequence	PEAR__all_pear;






/************************************************************************/
/*									*/
/*	Tracing Definitions						*/
/*									*/
/************************************************************************/


extern	Boolean 	PEAR__initedflag;
extern	Integer 	PEAR__tracelvl;


#define TRACE if (PEAR__tracelvl & PEAR_TRACE_ON) PEAR_trace
#define ITRACE if (PEAR__tracelvl & PEAR_TRACE_INT) PEAR_trace
#define DTRACE if (PEAR__tracelvl & PEAR_TRACE_DBG) PEAR_trace

#define ERROR(m) PEAR_error(m)
#define FATAL(m) { ERROR(m); ABORT; }
#define ABORT	 abort()

#define CHECKINIT if (!PEAR__initedflag) PEARinit();
#define ENTER	CHECKINIT; TRACE




/************************************************************************/
/*									*/
/*	Internal entries						*/
/*									*/
/************************************************************************/


extern	void			PEAR_message();
extern	void			PEAR_trace();
extern	void			PEAR_error();

extern	void			PEAR_win_init();
extern	void			PEAR_refresh();
extern	void			PEAR_insetrefresh();
extern	void			PEAR_finish();
extern	void			PEAR_select();
extern	void			PEAR_set_scroll();

extern	void			PEAR_menu_init();
extern	void			PEAR_menu_define();
extern	int			PEAR_inset_btn();
extern	int			PEAR_update_btn();
extern	int			PEAR_emphasize_btn();
extern	int			PEAR_zoom_btn();

extern	void			PEAR_edit_init();
extern	int			PEAR_edit_replace();
extern	int			PEAR_edit_insert();
extern	int			PEAR_edit_remove();
extern	int			PEAR_edit_arc();
extern	int			PEAR_edit_create();
extern	int			PEAR_edit_select();
extern	int			PEAR_edit_update();
extern	void			PEAR_update_obj();
extern	void			PEAR_update_begin();

extern	void			PEAR_ext_init();
extern	Boolean 		PEAR_ext_request_value();
extern	Boolean 		PEAR_ext_gelo_value();
extern	Boolean 		PEAR_ext_assign_value();
extern	Boolean 		PEAR_ext_layout_value();
extern	Boolean 		PEAR_ext_layout_arc_insert();
extern	Boolean 		PEAR_ext_layout_arc_remove();
extern	Boolean 		PEAR_ext_layout_remove();
extern	Boolean 		PEAR_ext_select();
extern	Boolean 		PEAR_ext_update();
extern	Boolean 		PEAR_ext_typein();
extern	Boolean 		PEAR_ext_depend_notify();
extern	Boolean 		PEAR_ext_evaluate();
extern	Boolean 		PEAR_ext_conn_port();
extern	Boolean 		PEAR_ext_hit();
extern	Boolean 		PEAR_ext_inq_cmd_update();
extern	Boolean 		PEAR_ext_inq_do_depend();
extern	void			PEAR_ext_refresh();

extern	void			PEAR_depend_init();




/* end of pear_local.h */



