/************************************************************************/
/*									*/
/*		pear.h							*/
/*									*/
/*	External definitions for using the PEAR picture editor		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "ash.h"




/************************************************************************/
/*									*/
/*	Parameter Definitions						*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Type Definitions						*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	Tracing Definitions						*/
/*									*/
/************************************************************************/



#define PEAR_TRACE_OFF	0		/* tracing off			*/
#define PEAR_TRACE_ON	0x1		/* trace external entries	*/
#define PEAR_TRACE_INT	0x2		/* trace internal entries	*/
#define PEAR_TRACE_DBG	0x4		/* trace local routines 	*/





/************************************************************************/
/*									*/
/*	Entries 							*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void		PEARinit();
extern	void		PEARtrace();

extern	void		PEARedit();
extern	Boolean 	PEARupdate();
extern	void		PEARremove();

extern	void		PEARregister_interface();

extern	Boolean 	PEARdepend_update();
extern	void		PEARdepend_hilite();

extern	void		PEARupdate_end_command();

extern	void		PEARmenu_quit();

#else

extern "C" {
	void		PEARinit();
	void		PEARtrace(int);

	void		PEARedit(ASH_WINDOW ...);
	void		PEARupdate(ASH_WINDOW);
	void		PEARremove(ASH_WINDOW);

	void		PEARregister_interface(...);

	Boolean 	PEARdepend_update(...);
	void		PEARdepend_hilite(...);

	void		PEARupdate_end_command(...);

	void		PEARmenu_quit(ASH_WINDOW);
};

#endif




/* end of pear.h */

