/************************************************************************/
/*									*/
/*		applewin.c						*/
/*									*/
/*	Window management for APPLE type picture editor package 	*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "apple_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define FILL_STYLE	3



/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	Integer 	apple_control();
static	void		apple_refresh();
static	void		apple_use_refresh();
static	void		free_apple();
static	void		draw_apple();





/************************************************************************/
/*									*/
/*	Tables								*/
/*									*/
/************************************************************************/


#define STEM_WINDOW	1
#define GELO_WINDOW	2
#define FIELD_WINDOW	3
#define LEFT_PANE	5
#define RIGHT_PANE	6
#define TOP_PANE	7
#define BOTTOM_PANE	8
#define BOTTOM_FILL	9
#define DATA_AREA	10
#define USE_AREA	11



static LEAF_DATA	apple_leaf[] = {
   LEAF_ROOT(NULL),
   { STEM_WINDOW, LEAF_TYPE_PDM,
	{ LEAF_COORD_LX, LEAF_COORD_TEXT_LINE,
	     LEAF_COORD_RX, LEAF_COORD_TY },
	NULL, NULL },
   { LEFT_PANE, LEAF_TYPE_SHADE,
	{ LEAF_COORD_LX, LEAF_COORD_BY,
	    LEAF_COORD_SIZE(15), LEAF_COORD_NEXT(STEM_WINDOW) },
	NULL, FILL_STYLE },
   { RIGHT_PANE, LEAF_TYPE_SHADE,
	{ LEAF_COORD_SIZE(15), LEAF_COORD_BY,
	    LEAF_COORD_NEXT(FIELD_WINDOW), LEAF_COORD_NEXT(STEM_WINDOW) },
	NULL, FILL_STYLE },
   { TOP_PANE, LEAF_TYPE_SHADE,
	{ LEAF_COORD_NEXT(LEFT_PANE), LEAF_COORD_SIZE(15),
	     LEAF_COORD_NEXT(RIGHT_PANE), LEAF_COORD_NEXT(STEM_WINDOW) },
	NULL, FILL_STYLE },
   { BOTTOM_PANE, LEAF_TYPE_SHADE,
	{ LEAF_COORD_NEXT(LEFT_PANE), LEAF_COORD_BY,
	     LEAF_COORD_NEXT(RIGHT_PANE), LEAF_COORD_SIZE(15) },
	NULL, FILL_STYLE },
   { BOTTOM_FILL, LEAF_TYPE_SHADE,
	{ LEAF_COORD_NEXT(LEFT_PANE), LEAF_COORD_NEXT(BOTTOM_PANE),
	     LEAF_COORD_NEXT(RIGHT_PANE), LEAF_COORD_SIZE(32) },
	NULL, FILL_STYLE },
   { GELO_WINDOW, LEAF_TYPE_WINDOW,
	{ LEAF_COORD_NEXT_LINE(LEFT_PANE), LEAF_COORD_NEXT_LINE(BOTTOM_FILL),
	     LEAF_COORD_NEXT_LINE(RIGHT_PANE), LEAF_COORD_NEXT_LINE(TOP_PANE) },
	APPLE_window_btn, NULL },
   { FIELD_WINDOW, LEAF_TYPE_STEM,
	{ LEAF_COORD_REL_LINE(75), LEAF_COORD_BY,
	     LEAF_COORD_RX, LEAF_COORD_NEXT(STEM_WINDOW) },
	APPLE_field_button, NULL },
   { USE_AREA, LEAF_TYPE_WINDOW,
	{ LEAF_COORD_NEXT_LINE(LEFT_PANE), LEAF_COORD_NEXT_LINE(BOTTOM_PANE),
	     LEAF_COORD_NEXT_LINE(RIGHT_PANE), LEAF_COORD_SIZE_LINE(16) },
	APPLE_use_btn, NULL },
   LEAF_END
};





/************************************************************************/
/*									*/
/*	APPLE_win_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
APPLE_win_init()
{
   ITRACE("APPLE_win_init");
};





/************************************************************************/
/*									*/
/*	APPLEdisplay -- set up a APPLE display in given window		*/
/*									*/
/************************************************************************/


APPLE_ID
APPLEdisplay(window,handle)
   ASH_WINDOW window;
   Universal handle;
{
   register APPLE_DATA ad;

   ENTER("APPLEdisplay 0x%x 0x%x",window,handle);

   ad = PALLOC(APPLE_DATA_B);

   ad->window = window;
   ad->handle = handle;
   ad->menu_win = NULL;
   ad->field_win = NULL;
   ad->picture = NULL;
   ad->first_picture = NULL;
   ad->prev_picture = NULL;
   ad->mode = APPLE_MODE_NONE;
   ad->draw_win = NULL;
   ad->use_window = NULL;
   ad->grid = DEFAULT_GRID;
   ad->numfield = 0;
   ad->fields = NULL;
   ad->selection = NULL;
   ad->use_select = 0;
   ad->draw_x = 1;
   ad->draw_y = 1;
   ad->show_grid = FALSE;
   ad->newfields = TRUE;

   LEAFsetup_window(window,apple_leaf,ad);
   LEAFset_control(window,apple_control);

   APPLE_get_picture(ad);

   draw_apple(ad);

   return (APPLE_ID) ad;
};





/************************************************************************/
/*									*/
/*	apple_control -- handle ASH control messages			*/
/*									*/
/************************************************************************/


static Integer
apple_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   register APPLE_DATA ad;

   ITRACE("apple_control %s 0x%x",msg,w);

   ad = (APPLE_DATA) ASHinq_user_data(w);
   if (ad == NULL) return ASH_CONTROL_REJECT;

   if (STREQL(msg,"ASH$REMOVE")) {
      ad->window = NULL;
      ASHset_user_data(w,NULL);
      free_apple(ad);
    };

   return ASH_CONTROL_REJECT;
};





/************************************************************************/
/*									*/
/*	apple_refresh -- drawing window refresh routine 		*/
/*	apple_use_refresh -- use window refresh routines		*/
/*									*/
/************************************************************************/


static void
apple_refresh(w)
   ASH_WINDOW w;
{
   register APPLE_DATA ad;

   ITRACE("apple_refresh 0x%x",w);

   ad = (APPLE_DATA) ASHinq_user_data(w);

   APPLE_draw_picture(ad);
};





static void
apple_use_refresh(w)
   ASH_WINDOW w;
{
   register APPLE_DATA ad;

   ITRACE("apple_use_refresh 0x%x",w);

   ad = (APPLE_DATA) ASHinq_user_data(ASHinq_parent(w));
   ASHset_user_data(w,-1);

   APPLE_draw_usearea(ad);
};





/************************************************************************/
/*									*/
/*	free_apple -- free APPLE data on window removal 		*/
/*									*/
/************************************************************************/


static void
free_apple(ad)
   APPLE_DATA ad;
{
   DTRACE("free_apple 0x%x",ad);

   free(ad);
};





/************************************************************************/
/*									*/
/*	draw_apple -- fill in the apple window				*/
/*									*/
/************************************************************************/


static void
draw_apple(ad)
   APPLE_DATA ad;
{
   DTRACE("draw_apple 0x%x",ad);

   LEAFredraw(ad->window);

   if (ad->draw_win == NULL) {
      ad->draw_win = LEAFinq_window(ad->window,GELO_WINDOW,0);
      if (ad->draw_win != NULL) {
	 ASHset_region_refresh(ad->draw_win,apple_refresh);
	 BIOnew_input_window(ad->draw_win);
	 BIOset_cursor(ad->draw_win,TRUE);
	 BIOset_cursor_standard(ad->draw_win,ASH_CURSOR_ARROW_UL);
	 ASHset_user_data(ad->draw_win,ad);
       };
    };

   if (ad->field_win == NULL) {
      ad->field_win = LEAFinq_window(ad->window,FIELD_WINDOW,0);
    };

   if (ad->use_window == NULL) {
      ad->use_window = LEAFinq_window(ad->window,USE_AREA,0);
      ASHset_user_data(ad->use_window,-1);
      ASHset_refresh(ad->use_window,apple_use_refresh);
    };

   if (ad->menu_win == NULL) {
      ad->menu_win = LEAFinq_window(ad->window,STEM_WINDOW,0);
      APPLE_menu_define(ad);
    }
   else {
      APPLE_menu_setup(ad);
    };

   APPLE_field_menu_setup(ad);

   APPLE_draw_picture(ad);
};





/* end of applewin.c */
