/************************************************************************/
/*									*/
/*		applesave.c						*/
/*									*/
/*	Routines to save known type pictures in APPLE			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "apple_local.h"






/************************************************************************/
/*									*/
/*	Variable definitions						*/
/*									*/
/************************************************************************/


#define HASH_SIZE	399

typedef struct _ENTRY {
   Universal	type;
   APPLE_GELO_OBJECT object;
} * ENTRY, ENTRY_B;




static	Sequence	hash_table[HASH_SIZE];





/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	ENTRY		find_entry();
static	void		force_delete();






/************************************************************************/
/*									*/
/*	APPLE_save_init -- module initialization			 */
/*									*/
/************************************************************************/


void
APPLE_save_init()
{
   register Integer i;

   ITRACE("APPLE_save_init");

   for (i = 0; i < HASH_SIZE; ++i) hash_table[i] = NULL;
};





/************************************************************************/
/*									*/
/*	APPLEsave_clear -- clear saved definition of type		*/
/*									*/
/************************************************************************/


void
APPLEsave_clear(t)
   Universal t;
{
   TRACE("APPLEsave_clear 0x%x",t);

   APPLE_save_enter(t,NULL);
};





/************************************************************************/
/*									*/
/*	APPLEsave_clear_all -- clear all saved definitions		*/
/*									*/
/************************************************************************/


void
APPLEsave_clear_all()
{
   Integer i;
   Sequence l;
   ENTRY e;

   TRACE("APPLEsave_clear_all");


   for (i = 0; i < HASH_SIZE; ++i) {
      forin (e,ENTRY,l,hash_table[i]) {
	 if (e->type != NULL && e->object != NULL) APPLE_save_enter(e->type,NULL);
       };
    };
};





/************************************************************************/
/*									*/
/*	APPLE_save_find -- find object for type 			*/
/*									*/
/************************************************************************/


APPLE_GELO_OBJECT
APPLE_save_find(type)
   Universal type;
{
   register ENTRY e;

   ITRACE("APPLE_save_find 0x%x",type);

   e = find_entry(type);

   return e->object;
};





/************************************************************************/
/*									*/
/*	APPLE_save_enter -- enter type-object pair			*/
/*									*/
/************************************************************************/


void
APPLE_save_enter(type,obj)
   Universal type;
   APPLE_GELO_OBJECT obj;
{
   register ENTRY e;
   APPLE_GELO_OBJECT oobj;

   ITRACE("APPLE_save_enter 0x%x 0x%x",type,obj);

   e = find_entry(type);

   if (e->object == obj) return;

   PROTECT;

   force_delete(obj,FALSE);

   oobj = e->object;
   e->object = obj;

   if (oobj != NULL) force_delete(oobj,TRUE);

   UNPROTECT;
};






/************************************************************************/
/*									*/
/*	APPLE_save_append -- add to saved type-object pair		*/
/*									*/
/************************************************************************/


void
APPLE_save_append(type,obj)
   Universal type;
   APPLE_GELO_OBJECT obj;
{
   register ENTRY e;
   register APPLE_GELO_OBJECT ago,lobj,xobj;

   ITRACE("APPLE_save_append 0x%x 0x%x",type,obj);

   e = find_entry(type);

   PROTECT;

   xobj = NULL;
   for (lobj = e->object; lobj != NULL; lobj = lobj->alternative) {
      if (lobj->cond_fct == NULL && lobj->cond_match == NULL && !lobj->cond_null &&
	     !lobj->cond_nested && !lobj->cond_array && !lobj->cond_layout)
	 break;
      xobj = lobj;
    };

   for ( ; obj != NULL; obj = lobj) {
      lobj = obj->alternative;
      obj->alternative = NULL;

      force_delete(obj,FALSE);

      if (obj->cond_fct != NULL || obj->cond_match != NULL || obj->cond_null ||
	     obj->cond_nested || obj->cond_array || obj->cond_layout) {
	 if (xobj == NULL) {
	    obj->alternative = e->object;
	    e->object = obj;
	  }
	 else {
	    obj->alternative = xobj->alternative;
	    xobj->alternative = obj;
	  };
	 xobj = obj;
       }
      else {
	 if (e->object == NULL) e->object = obj;
	 else {
	    for (ago = e->object; ago->alternative != NULL; ago = ago->alternative);
	    ago->alternative = obj;
	  };
       };
    };

   UNPROTECT;
};






/************************************************************************/
/*									*/
/*	find_entry -- find entry for given type 			*/
/*									*/
/************************************************************************/


static ENTRY
find_entry(type)
   Universal type;
{
   register Integer h;
   register Sequence l;
   register ENTRY e;

   DTRACE("find_entry 0x%x",type);

   PROTECT;

   h = ((unsigned int) type)%HASH_SIZE;
   h = abs(h);
   forin (e,ENTRY,l,hash_table[h]) {
      if (e->type == type) break;
    };

   if (EMPTY(l)) {
      e = PALLOC(ENTRY_B);
      e->type = type;
      e->object = NULL;
      hash_table[h] = CONS(e,hash_table[h]);
    };

   UNPROTECT;

   return e;
};





/************************************************************************/
/*									*/
/*	force_delete -- force object deletion/saving			*/
/*									*/
/************************************************************************/


static void
force_delete(obj,fg)
   APPLE_GELO_OBJECT obj;
   Boolean fg;
{
   register APPLE_GELO_OBJECT ago;

   DTRACE("force_delete 0x%x %d",obj,fg);

   for (ago = obj; ago != NULL; ago = ago->alternative)
      ago->nodelete = !fg;

   if (obj != NULL && fg) APPLEfree_picture(ago);
};





/* end of applesave.c */
