/************************************************************************/
/*									*/
/*		applemain.c						*/
/*									*/
/*	Main module for APPLE editor package				*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#define APPLE_MAIN

#include "apple_local.h"






/************************************************************************/
/*									*/
/*	Variable definitions						*/
/*									*/
/************************************************************************/


	Boolean 	APPLE__initedflag = FALSE;
	Integer 	APPLE__tracelvl = 0;

	PROT_DECL;




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


#ifdef	LIB
static			apple_cleanup();
#endif




/************************************************************************/
/*									*/
/*	APPLE_init -- initialize the module				 */
/*									*/
/************************************************************************/


void
APPLEinit()
{
   TRACE("APPLEinit");

   PROT_INIT;

   PROTECT;

   if (!APPLE__initedflag) {

#ifdef LIB
      BROWNregister_cleanup(apple_cleanup);
#endif

      APPLE_win_init();
      APPLE_menu_init();
      APPLE_edit_init();
      APPLE_draw_init();
      APPLE_pic_init();
      APPLE_ext_init();
      APPLE_gelo_init();
      APPLE_save_init();
      APPLE_copy_init();

      APPLE__initedflag = TRUE;
    };

   UNPROTECT;
};





#ifdef LIB
static
apple_cleanup()
{
   APPLE__tracelvl = 0;
   APPLE__initedflag = 0;
};
#endif





/************************************************************************/
/*									*/
/*	APPLEtrace -- set tracing level 				 */
/*									*/
/************************************************************************/


void
APPLEtrace(lvl)
   Integer lvl;
{
   APPLE__tracelvl = lvl;
};






/************************************************************************/
/*									*/
/*	APPLE_message -- send message to user				*/
/*									*/
/************************************************************************/


void
APPLE_message(w,msg)
   ASH_WINDOW w;
   String msg;
{
   Character buf[1024];

   if (RIPinq_area_window(RIP_AREA_STATUS) != NULL) {
      RIPstatus(msg);
    }
   else {
      sprintf(buf,"\n%s\n%%M  %%a",msg);
      STEMdialog1(w,buf);
    };
};





/************************************************************************/
/*									*/
/*	APPLE_trace -- output trace information 			 */
/*									*/
/************************************************************************/


void
APPLE_trace(msg,a1,a2,a3,a4,a5,a6,a7,a8,a9)
   String msg;
   Integer a1,a2,a3,a4,a5,a6,a7,a8,a9;
{
   Character mbf[1024];

   sprintf(mbf,msg,a1,a2,a3,a4,a5,a6,a7,a8,a9);

   printf("APPLE: %s\n",mbf);
};






/************************************************************************/
/*									*/
/*	APPLE_error -- handle error condition for APPLE 		 */
/*									*/
/************************************************************************/


/* VARARGS1 */

void
APPLE_error(msg,a1,a2,a3,a4)
   String msg;
   Integer a1,a2,a3,a4;
{
   Character mbf[1024],mbf1[1024];

   ITRACE("APPLE_error %s",msg);

   sprintf(mbf,msg,a1,a2,a3,a4);
   sprintf(mbf1,"ERROR (APPLE) : %s",mbf);

   fprintf(stderr,"%s\n",msg);
   fflush(stderr);
};





/* end of applemain.c */
