/************************************************************************/
/*									*/
/*		applepic.c						*/
/*									*/
/*	Picture management for APPLE type picture editor package	*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "apple_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	APPLE_GELO		copy_picture_elt();




/************************************************************************/
/*									*/
/*	APPLE_copy_init -- module initialization			*/
/*									*/
/************************************************************************/


void
APPLE_copy_init()
{
   ITRACE("APPLE_copy_init");
};





/************************************************************************/
/*									*/
/*	APPLEfree_picture -- free picture				*/
/*									*/
/************************************************************************/


void
APPLEfree_picture(ago)
   APPLE_GELO_OBJECT ago;
{
   register APPLE_GELO_OBJECT ag1;

   TRACE("APPLEfree_picture 0x%x",ago);

   for (ag1 = ago; ag1 != NULL; ) {
      ago = ag1;
      ag1 = ag1->alternative;
      ago->alternative = NULL;
      if (!ago->nodelete && ago->inuse == 0) {
	 APPLE_free_picture_elt(ago->object);
	 free(ago);
       };
    };
};





/************************************************************************/
/*									*/
/*	APPLEcopy_picture -- copy picture				*/
/*									*/
/************************************************************************/


APPLE_GELO_OBJECT
APPLEcopy_picture(ago)
   APPLE_GELO_OBJECT ago;
{
   register APPLE_GELO_OBJECT ag1;

   TRACE("APPLEcopy_picture 0x%x",ago);

   if (ago == NULL) return NULL;

   ag1 = PALLOC(APPLE_GELO_OBJECT_B);
   *ag1 = *ago;
   ag1->alternative = APPLEcopy_picture(ag1->alternative);
   ag1->layout_obj = NULL;
   ag1->object = copy_picture_elt(ag1->object);

   return ag1;
};





/************************************************************************/
/*									*/
/*	APPLE_free_picture_data -- free current pictures		*/
/*	APPLE_free_picture_elt -- free element of a picture		*/
/*	APPLE_free_component -- free layout component			*/
/*									*/
/************************************************************************/


void
APPLE_free_picture_data(ad)
   APPLE_DATA ad;
{
   ITRACE("APPLE_free_picture 0x%x",ad);

   APPLEfree_picture(ad->first_picture);

   ad->first_picture = NULL;
   ad->picture = NULL;
   ad->prev_picture = NULL;
};





void
APPLE_free_alternative(ad)
   APPLE_DATA ad;
{
   register APPLE_GELO_OBJECT ago;

   ITRACE("APPLE_free_alternative 0x%x",ad);

   if (ad->picture == NULL) return;

   ago = ad->picture;

   if (!ago->nodelete && ago->inuse == 0) {
      APPLE_free_picture_elt(ad->picture->object);
    };

   if (ad->picture->alternative == NULL) {
      ad->picture = ad->first_picture;
      ad->prev_picture = NULL;
    }
   else {
      ad->picture = ad->picture->alternative;
    };

   if (!ago->nodelete && ago->inuse == 0) free(ago);

   APPLE_set_picture_mode(ad);
};





void
APPLE_free_picture_elt(ag)
   APPLE_GELO ag;
{
   register APPLE_GELO_TILED til;
   register APPLE_GELO_LAYOUT lay;
   register Sequence l;
   register APPLE_GELO_COMPONENT c;
   register APPLE_GELO_TCONST cnst;
   register APPLE_GELO_TARC tarc;
   register APPLE_GELO agc;

   ITRACE("APPLE_free_picture_elt 0x%x",ag);

   if (ag == NULL) return;

   switch (ag->mode) {
      default :
	 break;
      case APPLE_MODE_TILED :
	 til = (APPLE_GELO_TILED) ag;
	 forin (c,APPLE_GELO_COMPONENT,l,til->components) {
	    if (c->object != NULL) APPLE_free_picture_elt(c->object);
	    APPLE_free_component(c);
	  };
	 LFREE(til->components);
	 forin (tarc,APPLE_GELO_TARC,l,til->arcs) {
	    free(tarc);
	  };
	 LFREE(til->arcs);
	 forin (cnst,APPLE_GELO_TCONST,l,til->constraints) {
	    free(cnst);
	  };
	 LFREE(til->constraints);
	 break;
      case APPLE_MODE_LAYOUT :
	 lay = (APPLE_GELO_LAYOUT) ag;
	 forin (agc,APPLE_GELO,l,lay->components) {
	    APPLE_free_picture_elt(agc);
	  };
	 LFREE(lay->components);
	 break;
    };

   free(ag);
};






void
APPLE_free_component(c)
   APPLE_GELO_COMPONENT c;
{
   ITRACE("APPLE_free_component 0x%x",c);

   free(c);
};





/************************************************************************/
/*									*/
/*	copy_picture_elt -- copy element of picture			*/
/*									*/
/************************************************************************/


static APPLE_GELO
copy_picture_elt(ag)
   APPLE_GELO ag;
{
   register APPLE_GELO_TILED til,tiln;
   register APPLE_GELO_LAYOUT lay,layn;
   register Sequence l,la,lb;
   register APPLE_GELO_COMPONENT c,cn;
   register APPLE_GELO_TCONST cnst,cnstn;
   register APPLE_GELO_TARC tarc,tarcn;
   register APPLE_GELO agc,agn;
   APPLE_GELO_FIELD fld,fldn;
   APPLE_GELO_BOX box,boxn;
   APPLE_GELO_ARC arc,arcn;
   APPLE_GELO_IGNORE ign,ignn;

   DTRACE("copy_picture_elt 0x%x",ag);

   if (ag == NULL) return NULL;

   agn = APPLE_new_object(ag->mode);

   switch (ag->mode) {
      default :
	 break;
      case APPLE_MODE_TILED :
	 til = (APPLE_GELO_TILED) ag;
	 tiln = (APPLE_GELO_TILED) agn;
	 *tiln = *til;
	 tiln->components = NULL;
	 forin (c,APPLE_GELO_COMPONENT,l,til->components) {
	    cn = PALLOC(APPLE_GELO_COMPONENT_B);
	    *cn = *c;
	    cn->object = copy_picture_elt(c->object);
	    tiln->components = APPEND(cn,tiln->components);
	  };
	 tiln->arcs = NULL;
	 forin (tarc,APPLE_GELO_TARC,l,til->arcs) {
	    tarcn = PALLOC(APPLE_GELO_TARC_B);
	    *tarcn = *tarc;
	    tiln->arcs = APPEND(tarcn,tiln->arcs);
	    la = tiln->components;
	    forin (c,APPLE_GELO_COMPONENT,lb,til->components) {
	       if (tarc->from == c) tarcn->from = CAR(APPLE_GELO_COMPONENT,la);
	       if (tarc->to == c) tarcn->to = CAR(APPLE_GELO_COMPONENT,la);
	       la = CDR(la);
	     };
	  };
	 tiln->constraints = NULL;
	 forin (cnst,APPLE_GELO_TCONST,l,til->constraints) {
	    cnstn = PALLOC(APPLE_GELO_TCONST_B);
	    *cnstn = *cnst;
	    tiln->constraints = APPEND(cnstn,tiln->constraints);
	    la = tiln->components;
	    forin (c,APPLE_GELO_COMPONENT,lb,til->components) {
	       if (cnst->from == c) cnstn->from = CAR(APPLE_GELO_COMPONENT,la);
	       if (cnst->to == c) cnstn->to = CAR(APPLE_GELO_COMPONENT,la);
	       la = CDR(la);
	     };
	  };
	 break;

      case APPLE_MODE_LAYOUT :
	 lay = (APPLE_GELO_LAYOUT) ag;
	 layn = (APPLE_GELO_LAYOUT) agn;
	 *layn = *lay;
	 layn->components = NULL;
	 forin (agc,APPLE_GELO,l,lay->components) {
	    layn->components = APPEND(copy_picture_elt(agc),layn->components);
	  };
	 break;

      case APPLE_MODE_FIELD :
	 fld = (APPLE_GELO_FIELD) ag;
	 fldn = (APPLE_GELO_FIELD) agn;
	 *fldn = *fld;
	 break;

      case APPLE_MODE_BOX :
	 box = (APPLE_GELO_BOX) ag;
	 boxn = (APPLE_GELO_BOX) agn;
	 *boxn = *box;
	 break;

      case APPLE_MODE_ARC :
      case APPLE_MODE_POINTER :
	 arc = (APPLE_GELO_ARC) ag;
	 arcn = (APPLE_GELO_ARC) agn;
	 *arcn = *arc;
	 break;

      case APPLE_MODE_IGNORE :
	 ign = (APPLE_GELO_IGNORE) ag;
	 ignn = (APPLE_GELO_IGNORE) agn;
	 *ignn = *ign;
	 break;
    };

   return agn;
};






/* end of applecopy.c */
