/************************************************************************/
/*									*/
/*		apple_local.h						*/
/*									*/
/*	Local definitions for the APPLE type picture editor		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#define PROT_NAME	APPLE__sema
#include <bwethread.h>

#include <ctype.h>
#include <DATATYPES.h>
#include <ash.h>
#include <bio.h>
#include <rip.h>
#include <stem.h>
#include <leaf.h>
#include <sequence.h>
#include <gelo.h>
#include "apple.h"

#include "apple_gelo.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MIN_GRID_SIZE	4
#define DEFAULT_GRID	16
#define MAX_GRID_SIZE	256

#define MAX_FIELD	128
#define MAX_NEW_FIELD	32

#define SELECT_FROM	((APPLE_GELO_COMPONENT) 1)
#define SELECT_TO	((APPLE_GELO_COMPONENT) 2)
#define SELECT_LABEL	((APPLE_GELO_COMPONENT) 3)

#define USE_SELECT_NONE 	0
#define USE_SELECT_USE		1
#define USE_SELECT_ONEUSE	2
#define USE_PREFIX		"Include  "
#define USE_PREFIX_LENGTH	9

#define GELO_METHOD_SELECTABLE	0x10000




/************************************************************************/
/*									*/
/*	Data Type Definitions						*/
/*									*/
/************************************************************************/


typedef struct _APPLE_DATA *APPLE_DATA;



typedef struct _APPLE_DATA {
   ASH_WINDOW window;
   Universal handle;
   ASH_WINDOW menu_win;
   ASH_WINDOW draw_win;
   ASH_WINDOW field_win;
   APPLE_MODE mode;
   APPLE_GELO_OBJECT picture;
   APPLE_GELO_OBJECT first_picture;
   APPLE_GELO_OBJECT prev_picture;
   APPLE_GELO_COMPONENT selection;
   Integer    use_select;
   APPLE_GELO usearc_select;
   ASH_WINDOW use_window;
   Integer    grid;
   Integer    numfield;
   Integer    draw_x, draw_y;
   APPLE_VALUE_B * fields;
   Boolean    show_grid;
   Boolean    newfields;
} APPLE_DATA_B;





/************************************************************************/
/*									*/
/*	Macros								*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Tracing Definitions						*/
/*									*/
/************************************************************************/


extern	Boolean 	APPLE__initedflag;
extern	Integer 	APPLE__tracelvl;


#define TRACE if (APPLE__tracelvl & APPLE_TRACE_ON) APPLE_trace
#define ITRACE if (APPLE__tracelvl & APPLE_TRACE_INT) APPLE_trace
#define DTRACE if (APPLE__tracelvl & APPLE_TRACE_DBG) APPLE_trace

#define ERROR(m) APPLE_error(m)
#define FATAL(m) { ERROR(m); ABORT; }
#define ABORT	 abort()

#define CHECKINIT if (!APPLE__initedflag) APPLEinit();
#define ENTER	CHECKINIT; TRACE




/************************************************************************/
/*									*/
/*	Internal entries						*/
/*									*/
/************************************************************************/


extern	void			APPLE_message();
extern	void			APPLE_trace();
extern	void			APPLE_error();

extern	void			APPLE_win_init();

extern	void			APPLE_menu_init();
extern	void			APPLE_menu_define();
extern	void			APPLE_menu_setup();
extern	void			APPLE_menu_prop_setup();
extern	void			APPLE_field_menu_setup();
extern	int			APPLE_field_button();
extern	int			APPLE_default_btn();
extern	int			APPLE_design_btn();
extern	int			APPLE_box_type_btn();
extern	int			APPLE_option_btn();

extern	void			APPLE_edit_init();
extern	int			APPLE_window_btn();
extern	int			APPLE_use_btn();

extern	void			APPLE_draw_init();
extern	void			APPLE_draw_picture();
extern	void			APPLE_grid_coords();
extern	void			APPLE_ash_coords();
extern	void			APPLE_draw_select();
extern	void			APPLE_redraw_component();
extern	void			APPLE_arc_box();
extern	void			APPLE_draw_usearea();

extern	void			APPLE_pic_init();
extern	void			APPLE_get_picture();
extern	void			APPLE_default_picture();
extern	void			APPLE_new_picture();
extern	void			APPLE_save_picture();
extern	void			APPLE_remove_alternative();
extern	void			APPLE_set_type();
extern	Integer 		APPLE_new_field();
extern	Boolean 		APPLE_change_grid();
extern	APPLE_GELO_COMPONENT	APPLE_add_component();
extern	Boolean 		APPLE_change_component();
extern	void			APPLE_set_picture_mode();
extern	void			APPLE_reget_fields();
extern	APPLE_GELO_OBJECT	APPLE_default_pattern();
extern	APPLE_GELO		APPLE_new_usefield();
extern	APPLE_GELO		APPLE_new_usearc();
extern	APPLE_VALUE		APPLE_layout_value();
extern	APPLE_GELO_TARC 	APPLE_tiled_connect();
extern	void			APPLE_tiled_connect_remove();
extern	APPLE_GELO_TCONST	APPLE_tiled_constraint();
extern	void			APPLE_tiled_constraint_remove();
extern	void			APPLE_fixup_load();
extern	APPLE_GELO		APPLE_new_object();

extern	void			APPLE_ext_init();
extern	APPLE_GELO_OBJECT	APPLE_ext_load_picture();
extern	void			APPLE_ext_save_picture();
extern	String			APPLE_ext_type_name();
extern	void			APPLE_ext_string();
extern	Integer 		APPLE_ext_inq_fields();
extern	Boolean 		APPLE_ext_new_field();
extern	void			APPLE_ext_notify();
extern	Universal		APPLE_ext_data_value();
extern	Boolean 		APPLE_ext_text_value();
extern	Integer 		APPLE_ext_inq_contents();
extern	Boolean 		APPLE_ext_inq_use_contents();
extern	Boolean 		APPLE_ext_inq_equals();
extern	Boolean 		APPLE_ext_test_null();
extern	Boolean 		APPLE_ext_inq_condition();
extern	Boolean 		APPLE_ext_inq_function();
extern	Boolean 		APPLE_ext_test_condition();
extern	Boolean 		APPLE_ext_inq_pointer();

extern	void			APPLE_gelo_init();

extern	void			APPLE_save_init();
extern	APPLE_GELO_OBJECT	APPLE_save_find();
extern	void			APPLE_save_enter();
extern	void			APPLE_save_append();

extern	void			APPLE_copy_init();
extern	void			APPLE_free_picture_data();
extern	void			APPLE_free_alternative();
extern	void			APPLE_free_picture_elt();
extern	void			APPLE_free_component();





/* end of apple_local.h */



