/************************************************************************/
/*									*/
/*		apple_gelo.h						*/
/*									*/
/*	APPLE structures for GELO object definition			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "sequence.h"



/************************************************************************/
/*									*/
/*	GELO object descriptor definitions				*/
/*									*/
/************************************************************************/


typedef struct _APPLE_VALUE *		APPLE_VALUE;

typedef struct _APPLE_GELO_OBJECT *	APPLE_GELO_OBJECT;

typedef struct _APPLE_GELO_BOX *	APPLE_GELO_BOX;
typedef struct _APPLE_GELO_LAYOUT *	APPLE_GELO_LAYOUT;
typedef struct _APPLE_GELO_ARC *	APPLE_GELO_ARC;
typedef struct _APPLE_GELO_FIELD *	APPLE_GELO_FIELD;
typedef struct _APPLE_GELO_TILED *	APPLE_GELO_TILED;
typedef struct _APPLE_GELO_IGNORE *	APPLE_GELO_IGNORE;

typedef struct _APPLE_GELO_COMPONENT *	APPLE_GELO_COMPONENT;
typedef struct _APPLE_GELO_TARC *	APPLE_GELO_TARC;
typedef struct _APPLE_GELO_TCONST *	APPLE_GELO_TCONST;
typedef struct _APPLE_GELO *		APPLE_GELO;




typedef enum _APPLE_MODE {
   APPLE_MODE_NONE,
   APPLE_MODE_TILED,
   APPLE_MODE_FIELD,
   APPLE_MODE_LAYOUT,
   APPLE_MODE_BOX,
   APPLE_MODE_ARC,
   APPLE_MODE_POINTER,
   APPLE_MODE_IGNORE,
} APPLE_MODE;




typedef struct _APPLE_VALUE {
   String name;
   Integer value;
} APPLE_VALUE_B;



typedef struct _APPLE_GELO_OBJECT {
   Universal cond_fct;
   String  cond_match;
   Boolean cond_null;
   Boolean cond_layout;
   Boolean cond_nested;
   Boolean cond_array;
   APPLE_GELO_OBJECT alternative;
   APPLE_GELO	layout_obj;
   APPLE_GELO	object;
   Sequence use;
   Sequence usearc;
   Boolean	nodelete;
   Short	inuse;
} APPLE_GELO_OBJECT_B;



typedef struct _APPLE_GELO_BOX {
   APPLE_MODE	mode;
   Boolean	fix_x;
   Boolean	fix_y;
   Integer	fill;
   GELO_SHAPE	shape;
   Integer	invert;
   Integer	linestyle;
   Integer	font;
   APPLE_VALUE_B value;
} APPLE_GELO_BOX_B;



typedef struct _APPLE_GELO_LAYOUT {
   APPLE_MODE	mode;
   Boolean	fix_x;
   Boolean	fix_y;
   GELO_METHOD	method;
   GELO_CONN_METHOD connmethod;
   Integer	boxed;
   Integer	white_space;
   Integer	shrinkage;
   Sequence	components;
   Boolean	unique;
   Boolean	fixed;
   Boolean	standard;
   Boolean	centered;
   Boolean	simple;
} APPLE_GELO_LAYOUT_B;



typedef struct _APPLE_GELO_ARC {
   APPLE_MODE	mode;
   Boolean	fix_x;
   Boolean	fix_y;
   GELO_PORT	fport;
   GELO_PORT	tport;
   APPLE_VALUE_B from;
   APPLE_VALUE_B to;
   APPLE_VALUE_B label;
   ASH_LINE_STYLE style;
   GELO_ARC_ARROW arrow;
   GELO_ARC_LABEL_LOC label_loc;
   GELO_ARC_LABEL_POS label_pos;
   String	match;
   Boolean label_box;
} APPLE_GELO_ARC_B;



typedef struct _APPLE_GELO_FIELD {
   APPLE_MODE	mode;
   Boolean	fix_x;
   Boolean	fix_y;
   GELO_PORT   fport;
   APPLE_VALUE_B value;
   String	match;
} APPLE_GELO_FIELD_B;



typedef struct _APPLE_GELO_TILED {
   APPLE_MODE	mode;
   Boolean	fix_x;
   Boolean	fix_y;
   Integer	max_x;
   Integer	max_y;
   Integer	boxed;
   Sequence	components;
   Sequence	arcs;
   Sequence	constraints;
} APPLE_GELO_TILED_B;



typedef struct _APPLE_GELO_IGNORE {
   APPLE_MODE	mode;
   Boolean	fix_x;
   Boolean	fix_y;
} APPLE_GELO_IGNORE_B;




typedef struct _APPLE_GELO_COMPONENT {
   Integer	lx;
   Integer	by;
   Integer	rx;
   Integer	ty;
   Boolean	fix_x;
   Boolean	fix_y;
   Integer	shrinkage;
   float	expand_x;
   float	expand_y;
   float	priority_x;
   float	priority_y;
   APPLE_GELO	object;
} APPLE_GELO_COMPONENT_B;




typedef struct _APPLE_GELO_TARC {
   GELO_PORT	fport;
   GELO_PORT	tport;
   APPLE_GELO_COMPONENT from;
   APPLE_GELO_COMPONENT to;
   ASH_LINE_STYLE style;
   GELO_ARC_ARROW arrow;
} APPLE_GELO_TARC_B;



typedef struct _APPLE_GELO_TCONST {
   APPLE_GELO_COMPONENT from;
   APPLE_GELO_COMPONENT to;
   Boolean	from_y;
   Boolean	to_y;
   float	multiplier;
   float	addend;
} APPLE_GELO_TCONST_B;



typedef struct _APPLE_GELO {
   APPLE_MODE	mode;
   Boolean	fix_x;
   Boolean	fix_y;
} APPLE_GELO_B;





/************************************************************************/
/*									*/
/*	Special items							*/
/*									*/
/************************************************************************/


#define APPLE_SELF_NAME "$SELF"
#define APPLE_DATA_NAME "$DATA"
#define APPLE_INDEX_NAME "$INDEX"





/************************************************************************/
/*									*/
/*	Functions							*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void			APPLEfree_picture();
extern	APPLE_GELO_OBJECT	APPLEcopy_picture();

#else

extern "C" {
	void			APPLEfree_picture(APPLE_GELO_OBJECT);
	APPLE_GELO_OBJECT	APPLEcopy_picture(APPLE_GELO_OBJECT);
}

#endif




/* end of apple_gelo.h */
