/************************************************************************/
/*									*/
/*		apple.h 						*/
/*									*/
/*	External definitions for using the APPLE type picture editor	*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "ash.h"
#include "gelo.h"



/************************************************************************/
/*									*/
/*	Parameter Definitions						*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Type Definitions						*/
/*									*/
/************************************************************************/


typedef struct _APPLE_DATA *	APPLE_ID;




/************************************************************************/
/*									*/
/*	Tracing Definitions						*/
/*									*/
/************************************************************************/



#define APPLE_TRACE_OFF  0		/* tracing off			*/
#define APPLE_TRACE_ON	 0x1		/* trace external entries	*/
#define APPLE_TRACE_INT  0x2		/* trace internal entries	*/
#define APPLE_TRACE_DBG  0x4		/* trace local routines 	*/





/************************************************************************/
/*									*/
/*	Entries 							*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void		APPLEinit();
extern	void		APPLEtrace();

extern	APPLE_ID	APPLEdisplay();

extern	void		APPLEmenu_quit();

extern	void		APPLEregister_external();
extern	int		APPLEforce_save();
extern	int		APPLEforce_restart();
extern	int		APPLEforce_fields();
extern	void		APPLEallow_new_fields();

extern	GELO_OBJECT	APPLEgelo_create();

extern	void		APPLEsave_clear();
extern	void		APPLEsave_clear_all();

#else

extern "C" {
	void		APPLEinit();
	void		APPLEtrace(int);

	APPLE_ID	APPLEdisplay(ASH_WINDOW ...);

	void		APPLEmenu_quit(APPLE_ID);

	void		APPLEregister_external(...);
	int		APPLEforce_save(APPLE_ID);
	int		APPLEforce_restart(APPLE_ID);
	int		APPLEforce_fields(APPLE_ID);
	void		APPLEallow_new_fields(APPLE_ID,int);

	GELO_OBJECT	APPLEgelo_create(...);

	void		APPLEsave_clear(...);
	void		APPLEsave_clear_all();
}

#endif




/* end of apple.h */

