/*
 * Copyright (C) 1989 by Kenneth Almquist.
 */

#include <stdio.h>
#include <sgtty.h>	/* for atty.h */
#include "atty.h"
#include "attyed.h"



int outstate;
int column;
char outline[COLUMNS];
char prompt[COLUMNS];
int promptlen;
int param[2];
char strparam[256];
int nparam;
char *strparamp;
char esccmd;
int *curnumber;
int promptcode;
int promptset;
char lastoutline[COLUMNS];
int lastoutlinelen;


/*
 * All output passes through the outchars routine.  The routine keeps
 * track of the current column and identifies escape sequences that
 * are interpreted by atty itself.
 */

outchars(p, n)
      char *p;
      int n;
      {
      char c;
      int newcol;
      int i;
      char *savep;
      char *q;
      int savecol = column;

      savep = p;
      switch (outstate) {
      case 0:
      state0:	/* base state */
	    while (--n >= 0) {
		  c = *p++;
		  if (c >= ' ' && c <= '~') {
			if (column < COLUMNS)
			      outline[column] = c;
			column++;
		  } else if (c == '\t') {
			newcol = (column + 8) &~ 07;
			while (column < newcol && column < COLUMNS)
			      outline[column++] = ' ';
			column = newcol;
		  } else if (c == '\r') {
			if ((lastoutlinelen = column) > COLUMNS)
				lastoutlinelen = COLUMNS;
			bcopy(outline, lastoutline, lastoutlinelen);
			column = 0;
		  } else if (c == '\033') {	/* ESCAPE */
			outstate = 1;
			goto state1;
		  } else if (c == '\b') {
			if (column > 0)
			      column--;
		  }
	    }
	    break;
      case 1:
      state1:	/* escape character seen */
	    if (--n < 0)
		  break;
	    c = *p++;
	    if (c == '[') {
		  outstate = 2;
		  nparam = 0;
		  param[0] = param[1] = 0;
		  curnumber = NULL;
		  goto state2;
	    } else if (c == ']') {
		  if (p - 2 > savep) {
			dispoff(savecol);
			outreal(savep, p - 2 - savep);
		  }
		  outstate = 3;
		  goto state3;
	    } else if (c == 'H') {	/* ESC H = home on some terminals */
		  column = 0;
		  outstate = 0;
		  goto state0;
	    } else {
		  outstate = 0;
		  goto state0;
	    }
      case 2:
      state2:	/* ESC [ seen */
	    while (--n >= 0) {
		  c = *p++;
		  if (c >= '0' && c <= '9') {
			if (curnumber != NULL) {
			      *curnumber = *curnumber * 10 + c - '0';
			} else if (nparam < 2) {
			      curnumber = &param[nparam++];
			      *curnumber = c - '0';
			}
		  } else if (c == '?') {
			/* ignore it for now */
		  } else if (c == ';') {
			curnumber = NULL;
		  } else {
			goto gotescape;
		  }
	    }
	    break;

gotescape:
	    /* got a complete escape sequence */
	    switch (c) {
		  case 'H':
			column = param[1] > 0? param[1] - 1 : 0;
			break;
		  case 'C':
			column += param[0];
			break;
		  case 'D':
			if ((column -= param[0]) < 0)
			      column = 0;
			break;
		  case 'L':  case'M':
			column = 0;
			break;
		  case 'J':
			if (param[0] == 1 || param[0] == 2) {
			      for (i = 0 ; i < column && i < COLUMNS; i++)
				    outline[i] = ' ';
			}
			break;
	    }
	    outstate = 0;
	    goto state0;
      case 3:
      state3:	/* got ESC ], which introduces an atty control sequence */
	    if (--n < 0)
		  break;
	    c = *p++;
	    if (c == 'P' || c == 'I' || c == 'D') {
		  esccmd = c;
		  strparamp = strparam;
		  outstate = 4;
		  goto state4;
	    } else {
		  dispoff(savecol);
		  ttyoutc('\033');
		  ttyoutc(']');
		  ttyoutc(c);
		  savep = p - 1;
		  outstate = 0;
		  goto state0;
	    }
	    break;
      case 4:
      state4:	/* reading prompt following ESC ] P */
	    while (--n >= 0) {
		  c = *p++;
		  if (c == '\n') {
			*strparamp = '\0';
			goto myesc;
		  }
		  if (c != '\r' && strparamp < &strparam[255]) {
			*strparamp++ = c;
		  }
	    }
	    break;

myesc:
	    /* got an ESC ] ... sequence */
	    switch (esccmd) {
	    case 'P':
		  if (promptset) {
			freezedisp(0);
#ifdef notdef
			if (column != 0) {
			      ttyoutc('\r');
			      ttyoutc('\n');
			}
			for (column = 0 ; prompt[column] ; column++)
			      ttyoutc(prompt[column]);
			bcopy(prompt, outline, column);
#endif
		  }
		  dispoff(savecol);
		  q = strparam;
		  i = 0;
		  while (*q >= '0' && *q <= '9') {
			i = 10 * i + *q - '0';
			q++;
		  }
		  if (*q == ';')
			q++;
		  promptcode = i;
		  if (strlen(q) > COLUMNS - 1)
      			q[COLUMNS - 1] = '\0';
		  strcpy(prompt, q);
		  promptset = 1;
		  break;
	    case 'D':
		  promptset = 0;
		  break;
	    case 'I':
		  insertchars(strparam, strlen(strparam));
		  break;
	    }
	    savep = p;
	    outstate = 0;
	    goto state0;
      }
      if (outstate < 3 && savep != p) {
	    dispoff(savecol);
	    outreal(savep, p - savep);
      }
}
