/*
 * Copyright (C) 1989 by Kenneth Almquist.  All rights reserved.
 * This file is part of atty, which is distributed under the terms specified
 * by the Atty General Public License.  See the file named LICENSE.
 *
 * This file defines the interface between the editor and the rest of
 * atty.  First come things defined in atty and exported to the editor.
 */

#define MAXLLEN 254		/* maximum line length (excluding newline) */
#define COLUMNS 132		/* maximum screen width we expect */


struct mode {
      int intr;			/* interrupt character */
      int quit;			/* quit character */
      int erase;		/* erase character */
      int kill;			/* kill character */
      int eof;			/* eof character */
      int susp;			/* suspend character */
      int echo;			/* set if echo turned on */
};


extern struct mode ttymode;	/* various info about the tty */
extern short ospeed;		/* output speed (as returned by gtty) */
extern int promptset;		/* true if prompt specified by the user */
extern char prompt[COLUMNS];	/* the prompt, if any */
extern int column;		/* column for writing output to (see below) */
extern char outline[COLUMNS];	/* current output line */
extern char lastoutline[COLUMNS]; /* last complete line of output */
extern int lastoutlinelen;	/* lenght of lastoutline */


#ifdef __STDC__
void ttyoutc(int);		/* write a character to the tty */
void outreal(char *, int);	/* write a block of characters to the tty */
void senddata(char *, int);	/* send a line to the process */
void badinit(char *);		/* edinit failed; print message and exit */
#else
void ttyoutc();
void outreal();
void senddata();
void badinit();
#endif



/*
 * Now routines provide by the editor.
 */

#ifdef __STDC__
void edinit(char *);		/* initialize the editor */
void newttychars(void);		/* called when ttymode changes */
void newscrnwidth(int);		/* called when the screen width changes */
void inchar(int);		/* called to input a character */
void edflush(void);		/* discard any input */
void refresh(void);		/* turn display on and update it */
void dispoff(int);		/* turn display off */
void freezedisp(int);		/* freeze the editor display */
void insertchars(char *, int);	/* insert characters into input buffer */
#else
void edinit();
void newttychars();
void newscrnwidth();
void inchar();
void edflush();
void refresh();
void dispoff();
void freezedisp();
void insertchars();
#endif
