echo '.TH ATTY 1'
echo ".ds d `pwd`/atty.bind"
cat <<\!
..SH NAME
atty \- alternative tty driver
..SH SYNOPSYS
..B atty
..B -ls
..B -c
..I command
[
..I bindings-file
]
..SH COPYRIGHT
..if n Copyright (C) 1989 by Kenneth Almquist.
..if t Copyright \(co 1989 by Kenneth Almquist.  
..SH DESCRIPTION
..I Atty
is an alternative to
..IR tty (4).
It puts the terminal in
..I cbreak
mode to suppress the line editing normally done by
..IR tty (4)
..PP
Most of the standard
..IR tty (4)
features (except for the ones relating to input line editing) are supported.
Skip to the the section titled
..I "Getting Started"
if you just want an introduction to
..IR atty .
..PP
When
..I atty
starts up, it runs the shell specified by the environment variable
SHELL.  It sets the environment variable ATTY to inform programs that
they are running under \fIatty\fR.
If the
..B -l
option is given, the shell is made a login shell (by prepending a minus
sign to arg zero).
Normally suspending the shell will cause
..I atty
to suspend itself.  The
..B -s
option causes
..I atty
to restart a suspended shell instead.
The
..B -c
option causes the shell to run the specified command before reading commands
from the standard input.  This only works with
..IR ash (1).
(I use it to make the prompt of my top level shell different from the
default ``@\ '' \fIwithout\fR passing PS1 as an environment variable,
which would change the prompt for subshells as well as the top level shell.)
..PP
The optional
..I bindings-file
controls the key bindings used by the editor (see
..IR kbind (1)).
If
..I bindings-file
is omitted,
..I atty
use the file "$HOME/.bindc" as the bindings file if it exists;
otherwise it uses the system default binding file ``\*dc''.
..PP
Several escape sequences are handled specially by
..IR atty .
``ESC ] P''
introduces a prompt.  The remainder of the line consists of a sequence
of digits giving the program ID, a semicolon, and the text of the
prompt.
``ESC ] D newline'' deletes the current prompt (if any).
These two escape sequences can be used by shells (such as
..IR ash (1))
that know about
..IR atty .
``ESC ] I'' inserts text in the input buffer.  The remainder of the
line contains the text to be inserted.  This is used by the
..B -c
option of
..IR fmatch (1).
..PP
Clearing the ODDP bit in the sgtty structure (``stty -odd'') turns off
the special input editing features of
..I atty
and causes the normal
..IR tty (4)
input editing to be done.
..PP
When the prompt is set (via ``ESC ] P''),
..I atty
assumes that it can run the
..IR fmatch (1)
program by inputing a command line preceded by an FS character (octal 34).
..sp 2
..B "Getting Started"
..PP
This section gives an overview of the editiing features of
..I atty
when the default binding file is used.  For detailed descriptions of the
commands, see
..IR kbind (1).
..PP
Each command can be given a numeric prefix argument.  One way to do this
is to type ESC followed by the number.  Another is to type ^U.
^U multiplies the preceding prefix argument by 4 if one is given,
so a single ^U sets the prefix argument to 4, ^U ^U sets the prefix
argument to 16, and so on.  Typically, the prefix argument specifies the
number of times that a command is to be repeated.  Most commands will do
something sensible with a negative argument.
..PP
Printing characters are bound to the
..I self-insert
command, so to enter then you just type them.
Control characters are used for commands, but you can enter them by
preceding them with ^V.
..PP
Several commands correspond to functions normally provided by
..IR tty (4).
DEL (^?) sends an interrupt signal, FS (^\e) sends a quit signal, and
^Z sends a stop signal.  The first two of these normally flush
..IR atty 's
input buffer.  ^D generate an end of file when typed on an empty line.
(Otherwise it deletes the following character.)  These keys are the ones
that you are most likely to want to re-bind; see below.
..PP
There are several commands for moving around on a line.  ^F moves forward
one character and ^B moves backward one character.  ESC f and ESC b move
forward and backword by words rather than characters.  ESC a and ESC e
move to the beginning and the end of the line, respectively.
..PP
The commands that delete text generally save the deleted text in the
..IR "kill buffer" .
You can then get the text back by typing ^Y.  This feature is often
used to move text around.  Also, if you delete text by accident, you
can get it back by typing ^Y.
..PP
The most important deletion command is BACKSPACE, which deletes the
preceding character.  It only saves the deleted text to the kill buffer
if you gave an explicit prefix argument.  ^D is similar to BACKSPACE,
but deletes forwards rather than backwards.  (As a special case, ^D
generates an end of file when typed on an empty line.)  There are also
commands for deleting words:  ESC BACKSPACE deletes the preceding word and
ESC d deletes the following word.  Finally, ^W deletes everything between
the cursor and a location in the line known as the
..IR mark .
You can set the location of the mark by typing ^@.
..PP
One final text modification command worth mentioning is ^T, which transposes
the two preceding characters.
..PP
..I Atty
mantains a history of lines typed.  ^P moves to the preceding history line
and ^N moves to the next history line.  Both ^P and ^N skip blank lines.
^R does a reverse search through the history file for a specified regular
expression (which you type in, followed by a carriage return).  When
you go to a line, it is loaded into the input buffer where you can then
edit it.  (Editing it does not affect the contents of the actual history
file.)
..PP
When you type carriage return to send a line,
..I atty
moves to the end of the history file.  You can also send a line using
^J (NEWLINE); in this case
..I atty
will advance to the next line of the history file rather than moving to
the end.  ^J is useful for resending a series of lines.
ESC . inserts the last word of the last history line.  This
is useful for entering sequences like:
..in +1i
..nf
mkdir directory
cd directory
..fi
..in -1i
Finally, ``ESC ,'' inserts the last line of output.
..sp 2
..B "Changing Bindings"
..PP
If you want to change a few bindings, the best thing to do is to copy
the system binding file \*d to the file .bind in your home directory,
and then edit it.  As an example, suppose you are a closet VMS fanatic
and want to make CONTROL-C be your interrupt character.  You will find
that two of the lines in the .bind file read
..sp
..nf
	b	^C	upcase-char
and
	b	\e177	tty-intr
..fi
..sp
The first line binds ^C to upcase-char, a function that converts a
character to upper case.  The second line binds DELETE (written here
as \e177; it could also have been written as ^?) to tty-intr.  You
want CONTROL C to do what DELETE does in the standard binding file,
so change the ``upcase-char'' to ``tty-intr''.  Now both CONTROL C
and DELETE will generate an interrupt, which is perfectly legal.  In
practice you probably want to make DELETE delete the preceding character,
which you can do by binding it to delete-backward-char.  The resulting
lines look like:
..sp
..nf
	b	^C	tty-intr
and
	b	\e177	delete-backward-char
..fi
..PP
After you have set up the .bind file to your satisfaction, type
..sp
	kbind .bind
..sp
This will create a file named .bindc which
..I atty
will read instead of the default binding file.
\fIIf you omit this step, atty will ignore the \fR.bind\fI file and will
continue to use the default binding file.\fR  Atty doesn't look for a
\&.bind file, only a .bindc file.
..SH AUTHORS
Kenneth Almquist
..SH FILES
\*dc\h'0.5i'default binding file
..SH "SEE ALSO"
..ta 2i
\fIkbind\fR(1)
..SH BUGS
Atty could be more intelligent about updating the screen in some cases.
(The slowest terminals on the systems it was developed on were 9600 baud.)
..PP
The program does not create a /etc/utmp entry for the pseudo-terminal that
it uses.  This confuses
..IR talk (1).
..PP
Changing the line discipline will cause problems.  There are also a number
of race conditions.  This program really needs more operating system support.
(Stream pipes would help, but an acknowledgement should really be sent back
when data is read to allow prompts and input lines to be associated correctly.)
!
