/* ************************************************************************* *
 * PostScript Interpretor                   Fabien LELAQUAIS                 *
 *                                                                           *
 *   Fichier stroke.c                                                        *
 *      Stroke routines for PSint (previously in path.c).                    *
 *                           Version 4.05 on 07/06/90                        *
 * ************************************************************************* *
 *    This document may be distributed, used, or modified, but can NOT be    *
 *  sold nor incorporated in any way in any product.                         *
 *    Permission is granted to distribute modified versions of that software *
 *  under the condition that this notice remains in every source file.       *
 *    Every alteration of the original files should be marked as such.       *
 *    No warranty is assumed by the author on the concequencies of the use   *
 *  of this software. Any defection of this program is at your own risk,     *
 *  you have to assume the cost of any service, installation or repairs      *
 *  this program could generate.                                             *
 *                                                                           *
 *                          Fabien LELAQUAIS - ESIEE - lelaquaf@apo.esiee.fr *
 * ************************************************************************* */
#include "int.h"
#include "graph.h"

double sqrt();
#define distance(a, b) sqrt((a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y))

extern ps__errors ps__flattenpath();
extern void       resolve_dash();

/* ************************************************************************* *
 *     Compute fill element that encloses the line to be drawn, with the     *
 *  appropriate linecap and join (use miter if necessary)                    *
 * ************************************************************************* */
ps__object    tempCTM;
static double previousangle;
ps__path
compute_line(ps__path  path,
             ps__coord p0,
             ps__coord p1,
             ps_g_type previoustype,
             int       end)
{
  double      lineangle, linelength, c, s, angle,
              cos(), sin(), atan2(), fabs();
  ps__array  *CTM;

  if ((end==2) || (linelength = distance(p0, p1))) {
         /* Change coordinates so that line appears parrralllelll to X axis */
         /* with origin at beginning of line                                */
    if (end == 2) lineangle = previousangle+_PI_;
    else          lineangle = atan2(p1.y-p0.y, p1.x-p0.x);
    p0 = user_to_device(state->CTM, p0);
    CTM = (ps__array *)arr_val(tempCTM);
    CTM[4].value = new_real(p0.x);
    CTM[5].value = new_real(p0.y);
    c  = cos(lineangle);
    s  = sin(lineangle);
    CTM[0].value = new_real(mat(state->CTM, 0)*c + mat(state->CTM, 2)*s);
    CTM[1].value = new_real(mat(state->CTM, 1)*c + mat(state->CTM, 3)*s);
    CTM[2].value = new_real(mat(state->CTM, 2)*c - mat(state->CTM, 0)*s);
    CTM[3].value = new_real(mat(state->CTM, 3)*c - mat(state->CTM, 1)*s);
    p1.x = 0.0;
    p1.y = to_real(state->linewidth)/2;
    if (!end) {              /* If not an end request, draw wide line itself */
      path = new_element(path, ps_gt_move);
      path->element.move.point = user_to_device(tempCTM, p1);
      p0.x = linelength;
      p0.y = p1.y;
      path = new_element(path, ps_gt_line);
      path->element.line.point = user_to_device(tempCTM, p0);
      p0.y = -p1.y;
      path = new_element(path, ps_gt_line);
      path->element.line.point = user_to_device(tempCTM, p0);
      p0.x = 0.0;
      path = new_element(path, ps_gt_line);
      path->element.line.point = user_to_device(tempCTM, p0);
      path = new_element(path, ps_gt_close);
      }
    switch (previoustype) {
      case ps_gt_line :           /* Rotate to get Y axis right at mid-angle */
        angle = previousangle-lineangle;
        if (angle <  0)      angle += 2*_PI_;
        if (angle >= 2*_PI_) angle -= 2*_PI_;
        c  = cos(angle/2);
        s  = sin(angle/2);
        p0.x = mat(tempCTM, 0)*c + mat(tempCTM, 2)*s;
        p0.y = mat(tempCTM, 1)*c + mat(tempCTM, 3)*s;
        CTM[2].value = new_real(mat(tempCTM, 2)*c-mat(tempCTM, 0)*s);
        CTM[3].value = new_real(mat(tempCTM, 3)*c-mat(tempCTM, 1)*s);
        CTM[0].value = new_real(p0.x);
        CTM[1].value = new_real(p0.y);
        switch (int_val(state->linejoin)) {
          case JOIN_MITER :
          case JOIN_BEVEL :
            path = new_element(path, ps_gt_move);
            p0.x = p0.y = 0;
            path->element.move.point = user_to_device(tempCTM, p0);
            p0.y = (c==0)?0:fabs(p1.y/c);              /* Miter Y coordinate */
            path = new_element(path, ps_gt_line);
            p1.x = p1.y*s;
            if (angle < _PI_) p1.y *=  c;
            else              p1.y *= -c;
            path->element.line.point = user_to_device(tempCTM, p1);
            if ((int_val(state->linejoin) == JOIN_MITER) &&      /* MITER ?? */
                (s != 1)                                 &&
                (1/(1-fabs(s)) <= to_real(state->miterlimit))) {
              path = new_element(path, ps_gt_line);
              path->element.move.point = user_to_device(tempCTM, p0);
              }
            path = new_element(path, ps_gt_line);
            p1.x = -p1.x;
            path->element.line.point = user_to_device(tempCTM, p1);
            path = new_element(path, ps_gt_close);
            break;
          case JOIN_ROUND :
            path = new_element(path, ps_gt_move);
            p0.x = -p1.y; p0.y = 0;
            path->element.line.point = user_to_device(tempCTM, p0);
            path = new_element(path, ps_gt_curve);
            p0.y = .552*p1.y;
            path->element.curve.point1 = user_to_device(tempCTM, p0);
            p0.x = -p0.y; p0.y = p1.y;
            path->element.curve.point2 = user_to_device(tempCTM, p0);
            p0.x = 0;
            path->element.curve.point3 = user_to_device(tempCTM, p0);
            path = new_element(path, ps_gt_curve);
            p0.x = .552*p1.y;
            path->element.curve.point1 = user_to_device(tempCTM, p0);
            p0.y = p0.x; p0.x = p1.y;
            path->element.curve.point2 = user_to_device(tempCTM, p0);
            p0.y = 0;
            path->element.curve.point3 = user_to_device(tempCTM, p0);
            path = new_element(path, ps_gt_close);
            break;
          default :
            ps__puts("** Invalid line join parameter **");
          }
        break;
      case ps_gt_none :
        switch (int_val(state->linecap)) {
          case CAP_BUTT   : break;
          case CAP_ROUND  :
            path = new_element(path, ps_gt_move);
            p0.y = -p1.y; p0.x = 0;
            path->element.line.point = user_to_device(tempCTM, p0);
            path = new_element(path, ps_gt_curve);
            p0.x = -.552*p1.y;
            path->element.curve.point1 = user_to_device(tempCTM, p0);
            p0.y = p0.x; p0.x = -p1.y;
            path->element.curve.point2 = user_to_device(tempCTM, p0);
            p0.y = 0;
            path->element.curve.point3 = user_to_device(tempCTM, p0);
            path = new_element(path, ps_gt_curve);
            p0.y = .552*p1.y;
            path->element.curve.point1 = user_to_device(tempCTM, p0);
            p0.x = -p0.y; p0.y = p1.y;
            path->element.curve.point2 = user_to_device(tempCTM, p0);
            p0.x = 0;
            path->element.curve.point3 = user_to_device(tempCTM, p0);
            path = new_element(path, ps_gt_close);
            break;
          case CAP_SQUARE :
            break;
          default :
            ps__puts("** Invalid line cap parameter **");
          }
      }
    previousangle = lineangle;
    return path;
    }
  else                            /* Null length line. Don't create anything */
    return path;
  }

/* -------------------------***********************------------------------- */
ps__errors
ps__strokepath()
{
  ps__path  path,
            newpath = NULL,
            newhead = NULL,
            free_element();
  ps__coord lastmove, currentpos, firstlinepoint;
  ps_g_type previoustype = ps_gt_none;

  previousangle = 0;
           /* Replaces current path with one containing filling informations */
  ps__flattenpath();
  resolve_dash();
  for (path = state->path; path; path = path->next) {
    switch (path->type) {
      case ps_gt_move :
        if (previoustype == ps_gt_line) {
          newpath = compute_line(newpath,
                      device_to_user(currentpos, state->CTM, NULL),
                      device_to_user(currentpos, state->CTM, NULL),
                      ps_gt_none, 2);
          newpath = compute_line(newpath,
                      device_to_user(firstlinepoint, state->CTM, NULL),
                      device_to_user(lastmove,       state->CTM, NULL),
                      ps_gt_none, 1);
          }
        if (previoustype != ps_gt_move)
          newpath = new_element(newpath, ps_gt_move);
        lastmove =  currentpos      =
        newpath->element.move.point = path->element.move.point;
        break;
      case ps_gt_line  :
        newpath = compute_line(newpath,
                    device_to_user(currentpos,               state->CTM, NULL),
                    device_to_user(path->element.line.point, state->CTM, NULL),
                    previoustype, 0);
        currentpos = path->element.line.point;
        if (previoustype == ps_gt_move) firstlinepoint = currentpos;
        break;
      case ps_gt_close :
        newpath = compute_line(newpath,               /* Join with last line */
                               device_to_user(currentpos, state->CTM, NULL),
                               device_to_user(lastmove,   state->CTM, NULL),
                               previoustype, 0);
        { double    angle = previousangle;           /* Join with first line */
          newpath = compute_line(newpath,
                              device_to_user(lastmove,       state->CTM, NULL),
                              device_to_user(firstlinepoint, state->CTM, NULL),
                              previoustype, 1);
          previousangle = angle; }
        currentpos = lastmove;
        break;
      }
    previoustype = path->type;
    if (!newhead) newhead = newpath;
    }
  if (previoustype == ps_gt_line) {            /* Add caps on trailing lines */
    newpath = compute_line(newpath,
                           device_to_user(currentpos, state->CTM, NULL),
                           device_to_user(currentpos, state->CTM, NULL),
                           ps_gt_none, 2);
    compute_line(newpath,
                 device_to_user(lastmove,       state->CTM, NULL),
                 device_to_user(firstlinepoint, state->CTM, NULL),
                 ps_gt_none, 1);
    }
  free_path(state->path);                                 /* Create new path */
  if (state->path = newhead) for (path = newhead; path->next; path=path->next);
  state->pqueue = path;
  return ps_e_operationok;
  }

/* -------------------------***********************------------------------- */
extern ps__path charpath;
ps__errors
ps__stroke()
{
  ps__path  current;
  double    linewidth, fabs();
  ps__coord last_move, cur_point;
  extern ps__errors ps__fill(), ps__newpath();

  if (charpath) return ps_e_operationok;
  if (state->device) {
    linewidth = to_real(state->linewidth)*
            (mat(state->CTM, 0)*mat(state->CTM, 3) - 
             mat(state->CTM, 1)*mat(state->CTM, 2))/2;
    if (fabs(linewidth) < 1.5) {
      ps__flattenpath();
      resolve_dash();
      for (current = state->path; current; current = current->next) {
        switch (current->type) {
          case ps_gt_move  :
            cur_point = last_move = current->element.move.point;
            break;
          case ps_gt_line  :
            ps__DoLine(cur_point, current->element.line.point);
            cur_point = current->element.move.point;
            break;
          case ps_gt_curve :
            ps__puts("** CURVE in STROKE !!! **");
            break;
          case ps_gt_close :
            ps__DoLine(cur_point, last_move);
            cur_point = last_move;
            break;
          }
        }
      }
         /*     linewidth is bigger than 1 pixel.
               Lines will be rendered by filling their body,
             created depending on the cap, join, and width parameter. */
    else {
      ps__strokepath();
      ps__fill();
      }
    }
  return ps__newpath();
  }
