/* ************************************************************************* *
 * PostScript Interpretor                   Fabien LELAQUAIS                 *
 *                                                                           *
 *   Fichier fill.c                                                          *
 *       Filling algorithms for PSint.                                       *
 *                           Previously in `main.c'                          *
 *                           Version 4.02 on 15/05/88                        *
 * ************************************************************************* *
 *    This document may be distributed, used, or modified, but can NOT be    *
 *  sold nor incorporated in any way in any product.                         *
 *    Permission is granted to distribute modified versions of that software *
 *  under the condition that this notice remains in every source file.       *
 *    Every alteration of the original files should be marked as such.       *
 *    No warranty is assumed by the author on the concequencies of the use   *
 *  of this software. Any defection of this program is at your own risk,     *
 *  you have to assume the cost of any service, installation or repairs      *
 *  this program could generate.                                             *
 *                                                                           *
 *                          Fabien LELAQUAIS - ESIEE - lelaquaf@apo.esiee.fr *
 * ************************************************************************* */
#include "int.h"

char *parsing;

/* ************************************************************************* */
char ps_numbers[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
ps__object
check_value(char *text)
{
  char     decimal_point =    0,
           base          =    0,
           exponant      =    0,
           new_base      =   10,
           minus         =    0,
           minus_exp     =    0,
           any_digit     =    0,
          *p             = text;
  long     value         =    0,
           mantissa      =    0,
           int_entered;
  double   fraction      =    0,
           real_entered;
  ps__type type          = ps_t_int;
  
  if (*p == '-') {
    p++;
    minus = 1; 
    }
  if (*p == '+') p++;
  if ((*p != '.') && ((*p < '0') || (*p > '9'))) type = ps_t_invalid;
  else {
    for ( ; *p && (type != ps_t_invalid); p++) {
      char c = *p, *q, order;
      if ((c>='a') && (c<='z')) c -= 'a'-'A';                   /* Majuscule */
      for (q = ps_numbers, order = 0; *q && *q != c; q++, order++);
      if (*q && (order<new_base)) {
        value = value*new_base+order;
        any_digit++;
        }
      else {
        switch (c) {
         case '#' :
           if (!base && !minus && !decimal_point && !exponant &&
               (value>1) && (value<37)) {
             base = 1; new_base = value; any_digit = 0; value = 0;
             }
           else type = ps_t_invalid;
           break;
          case '.' :                              
            if (!base && !decimal_point && !exponant) {
              mantissa      = value;
              decimal_point = 1; 
              any_digit     = 0; 
              value         = 0;
              }
            else type = ps_t_invalid;
            break;
          case 'E' :
            if (!base && !exponant) {
              exponant = 1;
              if (decimal_point) {
                fraction = value;
                for (; any_digit--; fraction /= 10);
                }
              else
                mantissa = value;
              any_digit = 0;
              value = 0;
              if (*(p+1) == '+') p++;
              if (*(p+1) == '-') {
                minus_exp = 1;
                p++;
                }
              }
            else type = ps_t_invalid;
           break;
           default  : type = ps_t_invalid;
           }
        }
      }
    }
  if (type != ps_t_invalid) {
    if (decimal_point || exponant) type = ps_t_real;
    else
      if (!any_digit) type = ps_t_invalid;
    }
  switch(type) {
    case ps_t_int  :
      int_entered = (minus)?-value:value;
      break;
    case ps_t_real :
      if (!exponant) {
        fraction = value;
        for (; any_digit; any_digit--, fraction /= 10);
        }
     real_entered = mantissa+fraction;
     if (minus) real_entered *= -1;
     if (exponant) {
       fraction = 10;
       if (minus_exp) fraction = .1;
       for (; value--; real_entered *= fraction);
       }
     break;
     default : return new_object(ps_t_invalid);
     }
  return (type == ps_t_int)?new_int(int_entered):new_real(real_entered);
  }

/* ************************************************************************* *
 *  Get next command :                                                       *
 *  Checks cases '(', ')', '[', ']', '{', '}', '<', '>', '%'                 */
/* ------------------------------------------------------------------------- */
/*      Procedures constructions allocation routines :                       */
/* ------------------------------------------------------------------------- */
typedef struct _proc {
 ps__object    object;
 struct _proc *next;
 } proc, *procp;
procp free_procs = NULL;
procp
alloc_proc()
{
  if (!free_procs) return ps_alloc(sizeof(proc));
  else {
    procp ret = free_procs;
    free_procs = free_procs->next;
    return ret;
    }
  }
/* ------------------------------------------------------------------------- */
void
free_proc(procp one_proc)
{
  one_proc->next = free_procs;
  free_procs     = one_proc;
  }
/* ------------------------------------------------------------------------- */

#define isblankseparator(x) ((x == ' ')  || (x == '\t') || (x == '\n') ||\
                             (x == '\r') || (x == EOF)  || (x == 0x04))
#define isseparator(x)   (isblankseparator(x) || (x == '(') || (x == ')') || \
                          (x == '<') || (x == '>') || \
                          (x == '[') || (x == ']') || (x == '{') || \
                          (x == '}') || (x == '%') || (x == '/'))
static short       braces = 0;
ps__object
get_next_command(ps__object *input)
{
  char       *p;
  extern ps__object closemark_object;
  ps__object  object;
  int         c, proclength;
  procp       prochead = NULL, newproc;
  
  do {
    c = getin(*input);
    if (!isblankseparator(c))
      switch ((char)c) {
        case '(' : {
          short parenthesis = 1;
          p = (char *) parsing;
          while (parenthesis)
            switch (c = getin(*input)) {
              case '('  : parenthesis++; *p++ = '('; break;
              case ')'  : parenthesis--; if (parenthesis) *p++ = ')'; break;
              case '\\' :
                switch(c = getin(*input)) {
                  case '\n' : break;
                  case '\\' : *p++ = '\\';   break;
                  case 'e'  : *p++ = '\033'; break;          /* Escape char. */
                  case 'n'  : *p++ = '\n';   break;
                  case 't'  : *p++ = '\t';   break;
                  case 'b'  : *p++ = '\b';   break;
                  case 'r'  : *p++ = '\r';   break;
/*                  case '('  : *p++ = '(';    break;
                    case ')'  : *p++ = ')';    break; */
                  default   :                  /* Un code octal, sinon rien. */
                    if ((c >= '0') && (c <= '7')) {
                      short code = c-'0', nombre = 1;
                      while (((c = getin(*input))>='0') &&
                              (c<='7') && (nombre < 4)) {
                        code = (code << 3)+c-'0';
                        nombre++;
                        }
                      *p++ = code;
                      getout(*input, c);
                      }
                    else
                      *p++ = c;
                  break;
                }
              break;
            default  :
              *p++ = c;
            }
          *p = 0;
          return new_string(parsing, (int)(p-parsing));
          }
        case '<' : {
          short anglebracket = 1, code = 0, digit = 0, value;
          p = (char *) parsing;
          while (anglebracket)
            switch (c = getin(*input)) {
              case '>' : anglebracket = 0; break;
              case '0' : case '1' : case '2' : case '3' : case '4' :
              case '5' : case '6' : case '7' : case '8' : case '9' :
                value = c-'0';
              if (digit) { code += value; *p++ = code; }
              else         code = value<<4;
              digit = 1-digit;
              break;
            case 'A' : case 'B' : case 'C' : case 'D' : case 'E' : case 'F' :
              c -= 'A'-'a';
            case 'a' : case 'b' : case 'c' : case 'd' : case 'e' : case 'f' :
              value = c-'a'+10;
              if (digit) { code += value; *p++ = code; }
              else         code = value<<4;
              digit = 1-digit;
              break;
            }
          if (digit) *p++ = code;
          *p = 0;
          return new_string(parsing, (int)(p-parsing));
          }
        case '[' : return mark_object;
        case ']' : return closemark_object;
        case '{' :                               /* Parsing procedures input */
          braces++;
          proclength = 0;
          object = get_next_command(input);
          while (object.type != ps_t_null) {
            newproc = alloc_proc();
            newproc->object = object;
            newproc->next   = prochead;
            prochead        = newproc;
            proclength++;
            object = get_next_command(input);
            }
          object = new_array(proclength);
          for (newproc = prochead;
               proclength;
               proclength--,
               newproc=prochead) {
            MORE_REFS(newproc->object);
            arr_ob(object, proclength-1) = newproc->object;
            prochead = newproc->next;
            free_proc(newproc);
            }
          if (newproc) ps__puts("*** Bad error parsing procedure ***");
          return cvx(object);
        case '}' :
          if (!braces) return invalid_object;
          braces--;
          return null_object;
        case '%' :
          while (((c = getin(*input)) != '\n') && (c != EOF));
          break;
        case '/' :
          p = (char *) parsing;
          do {
            c = getin(*input);
            *p++ = c;
            } while (!isseparator(c));
          getout(*input, c);
          *--p = 0;
          return new_name(parsing, (int)(p-parsing));
        case ')' :
        case '>' : return invalid_object;
        default  :
          p    = (char *) parsing;
          do {
            *p++ = c;
            c = getin(*input);
            } while (!isseparator(c));
          getout(*input, c);
          *p = 0;
          object = check_value(parsing);
          return (object.type==ps_t_invalid)
             ? cvx((braces) ? new_name(parsing, (int)(p-parsing))
                            : do_name(parsing))
             : object;
        }
    } while (c != EOF);
  if (input->type == ps_t_file) fclose(file_val(*input));
  return null_object;
  }

