/* ************************************************************************* *
 * PostScript Interpretor                   Fabien LELAQUAIS                 *
 *                                                                           *
 *   Fichier inout.c                                                         *
 *       Input-Output routines for PSint.                                    *
 *                           Version 2.00 on 16/02/88                        *
 * ************************************************************************* *
 *    This document may be distributed, used, or modified, but can NOT be    *
 *  sold nor incorporated in any way in any product.                         *
 *    Permission is granted to distribute modified versions of that software *
 *  under the condition that this notice remains in every source file.       *
 *    Every alteration of the original files should be marked as such.       *
 *    No warranty is assumed by the author on the concequencies of the use   *
 *  of this software. Any defection of this program is at your own risk,     *
 *  you have to assume the cost of any service, installation or repairs      *
 *  this program could generate.                                             *
 *                                                                           *
 *                          Fabien LELAQUAIS - ESIEE - lelaquaf@apo.esiee.fr *
 * ************************************************************************* */
#include <stdio.h>

/* ------------------------------------------------------------------------- */
ps__getchar()
{  return getchar();      }
/* ------------------------------------------------------------------------- */
ps__getc(FILE *f)
{ if (f == stdin)
    return ps__getchar();
  else
    return getc(f);
  }
/* ------------------------------------------------------------------------- */
ps__ungetc(int c, FILE *f)
{ 
  return ungetc(c,f);
  }

/* ------------------------------------------------------------------------- */
ps__putchar(int c)
{  return putchar(c);  }
/* ------------------------------------------------------------------------- */
ps__putc(int c, FILE *f)
{ if ((f == stdout) || (f == stderr))
    return ps__putchar(c);
  else
    return putc(c, f);
  }

/* ------------------------------------------------------------------------- */
ps__puts(char *m)
{
  return puts(m);
  }

#if AMIGA
/* ------------------------------------------------------------------------- */
ps__printf(char *format, long a1, long a2, long a3, long a4)
{
  return printf(format, a1, a2, a3, a4);
  }
#else
char output_buffer[1024];
/* ------------------------------------------------------------------------- */
ps__printf(char *format, int arguments)
{
  char *args = (char *)&arguments;

  vsprintf(output_buffer, format, args);
  return printf(output_buffer);
  }
#endif /* AMIGA */

/* ------------------------------------------------------------------------- */
ps__fflush(FILE *f)
{
  return fflush(f);
  }
