/* ************************************************************************* *
 * PostScript Interpretor                   Fabien LELAQUAIS                 *
 *                                                                           *
 *   Fichier graph.h                                                         *
 *                           Version 3.00 on 24/02/89                        *
 * ************************************************************************* *
 *    Graphic management object declaration header file.                     *
 * ************************************************************************* *
 *    This document may be distributed, used, or modified, but can NOT be    *
 *  sold nor incorporated in any way in any product.                         *
 *    Permission is granted to distribute modified versions of that software *
 *  under the condition that this notice remains in every source file.       *
 *    Every alteration of the original files should be marked as such.       *
 *    No warranty is assumed by the author on the concequencies of the use   *
 *  of this software. Any defection of this program is at your own risk,     *
 *  you have to assume the cost of any service, installation or repairs      *
 *  this program could generate.                                             *
 *                                                                           *
 *                          Fabien LELAQUAIS - ESIEE - lelaquaf@apo.esiee.fr *
 * ************************************************************************* */
#define JOIN_MITER 0
#define JOIN_ROUND 1
#define JOIN_BEVEL 2
#define CAP_BUTT   0
#define CAP_ROUND  1
#define CAP_SQUARE 2

#define MAX_FONTDIRECTORY_SIZE 30                   /* not more but 30 fonts */
                                                    /* Elements graphiques : */
typedef struct {                                        /* Betes coordonnees */
 double x, y;   }                ps__coord;
                                          /* Construction du Path PostScript */
typedef enum
 { ps_gt_none,
   ps_gt_move,
   ps_gt_line,
   ps_gt_curve,
   ps_gt_close } ps_g_type;
typedef struct
 { ps__coord point; } ps_g_move;
typedef ps_g_move ps_g_line;
typedef struct
 { ps__coord point1, point2, point3; } ps_g_curve;
typedef struct _path {
 ps_g_type     type;
 union {
  ps_g_move  move;
  ps_g_line  line;
  ps_g_curve curve;
  }            element;
 struct _path *next;
 } *ps__path, ps__path_element;

typedef struct _show {
  ps__coord     width, awidth, cwidth;
  short         achar, charcode;
  ps__object    font, proc;
  char         *cache;
  struct _show *next;
  } *ps__show_p, ps__show_t;

typedef struct _state {
  ps__object     CTM;
  struct {
   float r, g, b; } color;
  ps__coord      cp;
  ps__path       path,
                 pqueue,
                 clip, 
                 default_clip;
  ps__object     gray,
                 font,
                 linewidth,
                 linecap,
                 linejoin,
                 flatness,
                 miterlimit,
                 dasharray,
                 dashoffset,
                 frameproc,
                 transferproc;
  char          *device;
  ps__show_p     show;
  struct _state *next;
  unsigned short save_level;
  } *ps__state, ps__state_t;

typedef struct _cache {
  int            charcode;
  int            cx, cy;                 /* Coordinates of lower left corner */
  double         wx, wy;                 /* Widths                           */
  double         hash, matrix[4];
  char          *device;
  struct _cache *next;
  } ps__cache;

extern int       showcharcode;
extern ps__coord showwidth;

#define mat(ob, i) to_real(arr_ob(ob, i))

extern ps__state  state;

extern ps__object default_matrix;

extern ps__coord  user_to_device(),
                  duser_to_device(),
                  device_to_user(),
                  ddevice_to_user();

extern ps__path   new_element();
extern ps__cache *char_is_in_cache();

/* ************************************************************************* *
 *                Device-associated routines                                 *
 * ************************************************************************* */
extern void *ps__CreateWindow(int, int),    /* sizes x & y */
            *ps__CreateCache(int, int),

             ps__KillWindow(void *),
             ps__KillCache(void *),
             ps__CloseCache(),
             ps__DoCache(ps__cache *, ps__coord),

             ps__Erase(),
             ps__DoTrapeze(int, int, int, int,
                           int, int),
             ps__DoLine(ps__coord, ps__coord),
             ps__WritePixels(int, int, int, unsigned char *);

