/* ************************************************************************* *
 * PostScript Interpretor                   Fabien LELAQUAIS                 *
 *                                                                           *
 *   Fichier fillalgorithm.c                                                 *
 *       Filling algorithm for PSint.                                        *
 *                           Version 2.00 on 16/02/88                        *
 * Crispin Goswell algorithm Version 4.00 on 22/03/90                        *
 *     modified and improved Version 4.01 on 13/04/90                        *
 *               //          Version 4.03 on 21/06/90                        *
 * ************************************************************************* *
 *    This document may be distributed, used, or modified, but can NOT be    *
 *  sold nor incorporated in any way in any product.                         *
 *    Permission is granted to distribute modified versions of that software *
 *  under the condition that this notice remains in every source file.       *
 *    Every alteration of the original files should be marked as such.       *
 *    No warranty is assumed by the author on the concequencies of the use   *
 *  of this software. Any defection of this program is at your own risk,     *
 *  you have to assume the cost of any service, installation or repairs      *
 *  this program could generate.                                             *
 *                                                                           *
 *                          Fabien LELAQUAIS - ESIEE - lelaquaf@apo.esiee.fr *
 * ************************************************************************* */
#include "int.h"
#include "graph.h"
#include "fill.h"

/*
#define VERBOSE
 */
/* ************************************************************************ */
segment liste[MAX_EDGES];
int     nsegments;
static  segments *segstack = NULL, *seglist = NULL;
static  int currentX;

/* ************************************************************************ */
static void
killpair(segments edge)
{
  extern void draw_trapeze(segments, int);


  if (edge->pair) {
    draw_trapeze(edge, currentX);
    edge->pair->X0 = edge->pair->X    = currentX;
    edge->pair     = edge->pair->pair = NULL;
    }
  edge->X0 = edge->X = currentX;
  }

/* ************************************************************************ */
static void
compute_edges(unsigned long mask, int nstack)
{
  extern   void draw_trapeze(segments, int);
  register segments up_edge;
  register int      i,
                    countp = 0, countc = 0;  /* Counters in path or in clip */
  
  for (i = 0; i < nstack; i++) {
    int dp = 0, dc = 0;                    /* Increments in path or in clip */
    
    if (segstack[i]->clip) dc = segstack[i]->dir;
    else                   dp = segstack[i]->dir;
                    /* (In clip, entering path) or (in path, entering clip) */
    if ((      (countc+dc)  && !(mask&countp) && (mask&(countp+dp))) ||
        ((mask&(countp+dp)) && !      countc  &&       (countc+dc)))
      up_edge = segstack[i];
    else
                      /* (In clip, exiting path) or (in path, exiting clip) */
      if ((      (countc+dc)  && (mask&countp) && !(mask &(countp+dp))) ||
          ((mask&(countp+dp)) &&       countc  && !       (countc+dc))) {
        if ((up_edge->pair != segstack[i]) || segstack[i]->up) {
          if (up_edge->pair) {
            draw_trapeze(up_edge, up_edge->X);
            up_edge->pair->X0       = up_edge->pair->X;
            up_edge->pair->pair->X0 = up_edge->pair->pair->X;
            up_edge->pair->pair     = NULL;
            }
          if (segstack[i]->pair) {
            draw_trapeze(segstack[i], segstack[i]->X);
            segstack[i]->pair->X0       = segstack[i]->pair->X;
            segstack[i]->pair->pair->X0 = segstack[i]->pair->pair->X;
            segstack[i]->pair->pair     = NULL;
            }
          up_edge->pair     = segstack[i];
          segstack[i]->pair = up_edge;
          up_edge->X0       = segstack[i]->X0 = currentX;
          }
        up_edge->X      = segstack[i]->X = currentX;
        up_edge->up     = TRUE;
        segstack[i]->up = FALSE;
        }
      else
        killpair(segstack[i]);
    countp += dp;
    countc += dc;
    }
  if (countp || countc)
    ps__printf("*** In compute edges : %d %d ***\n", countp, countc);
  }

/* ************************************************************************ *
 *  Computed X coordinates list management                                  *
 * ************************************************************************ */
typedef struct _Xs {
  int         X;
  struct _Xs *next;
  } Xs;
static Xs *Xlist = NULL,
          *Xfree = NULL;

/* ************************************************************************ *
 *   addX : Inserts a new X coordinate in the Xlist, keeping the sorting OK *
 * ************************************************************************ */
static void
addX(int X)
{
  Xs *curr, *prev = NULL, *new;

#ifdef VERBOSE
  printf("Adding X : %d\n", X);
  for (curr=Xlist; curr; curr=curr->next)
    printf("    %6d\n", curr->X);
#endif /* VERBOSE */
  for (curr=Xlist; curr && (curr->X < X); prev=curr, curr=curr->next);
  if (!curr || (curr->X != X)) {
    if (Xfree) new = Xfree, Xfree = new->next;
    else       new = (Xs *)ps_alloc(sizeof(Xs));
    new->next = curr;
    new->X    = X;
    if (prev) prev->next = new;
    else      Xlist      = new;
    }
#ifdef VERBOSE
  printf("After :\n");
  for (curr=Xlist; curr; curr=curr->next)
    printf("    %6d\n", curr->X);
#endif /* VERBOSE */
  }

/* ************************************************************************ *
 *   getX : Returns next X coordinate to look at, bigger that currentX      *
 * ************************************************************************ */
static void
getX(int *nextX)
{
  Xs *curr;

  for (curr=Xlist; curr && (curr->X <= currentX); curr=Xlist) {
    Xlist      = curr->next;
    curr->next = Xfree;
    Xfree      = curr;
    }
  if (curr) *nextX = curr->X;
#ifdef VERBOSE
  printf("Next X  : %d\n", *nextX);
#endif
  }

/* ************************************************************************ */
void
free_fill_algorithm_stuff()
{
  extern void ps_free();
  Xs         *x;

  while (x = Xlist) { Xlist = Xlist->next; ps_free(x); }
  while (x = Xfree) { Xfree = Xfree->next; ps_free(x); }
  if (segstack) ps_free(segstack);
  if (seglist)  ps_free(seglist);
  }

/* ************************************************************************ */
segcmpX(segments *a, segments *b) { return (*a)->X1-(*b)->X1; }

/* ************************************************************************ */
segcmpY(segments *a, segments *b)
{
#if 1
  int      sign;

  return (sign = (int)(intersectionY((*a), currentX+1) -
                       intersectionY((*b), currentX+1)))
               ? sign : ((*a)->Y2-(*b)->Y2);
#else
  int loop = currentX, result;

  if ((*a)->dY*(*b)->dX == (*a)->dX*(*b)->dY) return 0; /* Parallel ? */
  do {
    result = intersectionY((*a), loop)-intersectionY((*b), loop);
    loop++;
    } while (!result);
  return result;
#endif
  }

#ifndef MIN
#define MIN(a,b) (((a)<(b))?(a):(b))
#endif /* MIN */
#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif /* MAX */
/* ************************************************************************ */
void
do_fill(unsigned long mask)
{
  extern ps__path copy_path(), flatten();
  extern void     read_edges(), free_path(), ps_free();
  ps__path        pp, pc;           /* Flattenned normal path and clip path */
  int             h, i, j,                   /* Counters                    */
                  nstack,                    /* Number of segments in stack */
                  x1min, x1max, x2min, x2max,/* Segments bounding boxes     */
                  y1min, y1max, y2min, y2max,
                  intersection,              /* Intersection X coordinate   */
                  nextX,                     /* Next X to be treated        */
                  maxX;                      /* Max X to be treated         */
#if SECMAI
  double          det;
  double          a1, a2, b1, b2;
#else
  long            det;
#endif

  if (!state->path || !state->clip) return;
                                                            /* Load segments */
  nsegments = 0;
  read_edges(pp = flatten(copy_path(state->path)), FALSE);
  read_edges(pc = flatten(copy_path(state->clip)), TRUE);
  free_path(pp);
  free_path(pc);
  segstack = (segments *)ps_alloc(nsegments*sizeof(segments));
  seglist  = (segments *)ps_alloc(nsegments*sizeof(segments));
  for (i=0; i<nsegments; i++) seglist[i] = &liste[i];
                                /* Sort them by increasing left X coordinate */
  qsort(seglist, (unsigned)nsegments, sizeof(segments), segcmpX);

#ifdef VERBOSE
  printf("Liste triee des %d segments :\n", nsegments);
  for (i=0; i<nsegments; i++)
    printf("%d : {(%d,%d)-(%d,%d)} (%s) [%d, %d]\n", i,
      seglist[i]->X1, seglist[i]->Y1, seglist[i]->X2, seglist[i]->Y2,
      seglist[i]->clip ? "CLIP" : "PATH", seglist[i]->dX, seglist[i]->dY);
#endif /* VERBOSE */

  nextX = seglist[0]->X1;
  addX(nextX);
  maxX = seglist[0]->X2;
  for (i = 1; i < nsegments; i++) if (seglist[i]->X2 > maxX) maxX = seglist[i]->X2;

  h      = 0;
  nstack = 0;
  while ((h != nsegments) || nstack) {
    currentX = nextX;
    compute_edges(mask, nstack);
    nextX = maxX;
    for (; (h < nsegments) && (seglist[h]->X1 <= currentX); h++) {
      x1min = seglist[h]->X1;
      x1max = seglist[h]->X2;
      if (seglist[h]->Y1 < seglist[h]->Y2)
        y1min = seglist[h]->Y1, y1max = seglist[h]->Y2;
      else
        y1min = seglist[h]->Y2, y1max = seglist[h]->Y1;
      for (i = 0; i < nstack; i++) {               /* Find all intersections */
                 /* Quick look to see if segstack[i] and seglist[h] may intersect */
        x2min = segstack[i]->X1;
        x2max = segstack[i]->X2;
        if (segstack[i]->Y1 < segstack[i]->Y2)
          y2min = segstack[i]->Y1, y2max = segstack[i]->Y2;
        else
          y2min = segstack[i]->Y2, y2max = segstack[i]->Y1;
        if (!((x1min > x2max) || (x1max < x2min) ||      /* Overlapping      */
              (y1min > y2max) || (y1max < y2min))) {     /* Bounding Boxes ? */
                         /* Yes ! This intersection may exist. Check that... */
#if SECMAI
          a1 = (double)seglist[h]->dY/(double)seglist[h]->dX;
          b1 = (double)seglist[h]->Y1-a1*x1min;
          a2 = (double)segstack[i]->dY/(double)segstack[i]->dX;
          b2 = (double)segstack[i]->Y1-a2*x2min;
          if ((det = a1 - a2) != 0.0)
            intersection = (b2-b1)/det;
#else
          if ((det = seglist[h]->dX*segstack[i]->dY-
                     seglist[h]->dY*segstack[i]->dX) != 0.0)
            intersection = ((x1max*seglist[h]->Y1 -seglist[h] ->Y2*x1min)*
                              segstack[i]->dX-
                            (x2max*segstack[i]->Y1-segstack[i]->Y2*x2min)*
                              seglist[h] ->dX)/(double)det;
#endif
          else intersection = maxX;
          if ((intersection >= currentX) &&      /* Effective intersection ? */
              (intersection <= x1max)    && (intersection <= x2max))
            addX(intersection);
          }
        }
      segstack[nstack]       = seglist[h];
      segstack[nstack]->X0   = segstack[nstack]->X = seglist[h]->X1;
      segstack[nstack]->pair = NULL;
      segstack[nstack++]->up = FALSE;
      }
    getX(&nextX);
    if ((h != nsegments) && (seglist[h]->X1<nextX)) nextX = seglist[h]->X1;
    for (i = 0; i < nstack; i++) {
      if ((segstack[i]->X1>currentX) && (segstack[i]->X1<nextX)) nextX = segstack[i]->X1;
      if ((segstack[i]->X2>currentX) && (segstack[i]->X2<nextX)) nextX = segstack[i]->X2;
      }
    qsort((char *)segstack, (unsigned)nstack, sizeof(segments *), segcmpY);
    for (j = 0, i = 0; i < nstack; i++)
      if (segstack[i]->X2 > currentX) segstack[j++] = segstack[i];
      else                            killpair(segstack[i]);
    nstack = j;
    compute_edges(mask, nstack);
    }
  ps_free(seglist);
  ps_free(segstack);
  segstack = seglist = NULL;
  ps__DoTrapeze(0, 0, 0, 0, 0, 0);
  }

