/* ************************************************************************* *
 * PostScript Interpretor                   Fabien LELAQUAIS                 *
 *                                                                           *
 *   Fichier fill.h                                                          *
 *                           Version 4.03 on 21/06/90                        *
 * ************************************************************************* *
 *    Fichier de definitions de l'algorithme de remplissage de PSINT         *
 * ************************************************************************* *
 *    This document may be distributed, used, or modified, but can NOT be    *
 *  sold nor incorporated in any way in any product.                         *
 *    Permission is granted to distribute modified versions of that software *
 *  under the condition that this notice remains in every source file.       *
 *    Every alteration of the original files should be marked as such.       *
 *    No warranty is assumed by the author on the concequencies of the use   *
 *  of this software. Any defection of this program is at your own risk,     *
 *  you have to assume the cost of any service, installation or repairs      *
 *  this program could generate.                                             *
 *                                                                           *
 *                          Fabien LELAQUAIS - ESIEE - lelaquaf@apo.esiee.fr *
 * ************************************************************************* */

#define MAX_EDGES 4096

/* ************************************************************************* *
 *       +---------------------------> X                                     *
 *       |                                                                   *
 *       |     * (X1, Y1)                                                    *
 *       |      \                                                            *
 *       |       |                                                           *
 *       |        \                                                          *
 *       |         |                                                         *
 *       |          \                                                        *
 *       |           |                                                       *
 *       |            \                                                      *
 *       |             * (X2, Y2)                                            *
 *       V                                                                   *
 *       Y                                                                   *
 * ************************************************************************* */

typedef struct _seg
{
  int          X1, Y1, X2, Y2,
               X0, X, Y,
               dX, dY;
  short        dir, up, clip, used;
  struct _seg *pair;
  } segment, *segments;

#define intersectionY(e, x) (int)((double)e->Y2+(double)(x-e->X2)* e->dY/(double)(e->dX))


