/* ************************************************************************* *
 * PostScript Interpretor                   Fabien LELAQUAIS                 *
 *                                                                           *
 *   Fichier fill.c                                                          *
 *       Filling algorithms for PSint.                                       *
 *                           Version 2.00 on 16/02/88                        *
 *                           Version 4.03 on 21/06/90                        *
 *                                Improved for correct SECMAI usage          *
 * ************************************************************************* *
 *    This document may be distributed, used, or modified, but can NOT be    *
 *  sold nor incorporated in any way in any product.                         *
 *    Permission is granted to distribute modified versions of that software *
 *  under the condition that this notice remains in every source file.       *
 *    Every alteration of the original files should be marked as such.       *
 *    No warranty is assumed by the author on the concequencies of the use   *
 *  of this software. Any defection of this program is at your own risk,     *
 *  you have to assume the cost of any service, installation or repairs      *
 *  this program could generate.                                             *
 *                                                                           *
 *                          Fabien LELAQUAIS - ESIEE - lelaquaf@apo.esiee.fr *
 * ************************************************************************* */
#include "int.h"
#include "graph.h"
#include "fill.h"

extern ps__cache *currentcache;

extern ps__errors ps__newpath();
extern void       do_fill(), free_path();

/*
#define VERBOSE
*/

#define eomask  1L
#define nwmask -1L
ps__path pathout;

/* --------------------********************************-------------------- */
ps__errors
ps__initclip()
{
  extern ps__path copy_path();

  free_path(state->clip);
  state->clip = copy_path(state->default_clip);
  return ps_e_operationok;
  }

/* --------------------********************************-------------------- */
ps__errors
ps__clippath()
{
  extern ps__path copy_path();
  ps__path        path;

  free_path(state->path);
  path = state->path = copy_path(state->clip);
  if (path) {
    for (; path->next; path=path->next);
    if (state->pqueue = path) {
      switch (path->type) {
        case ps_gt_move :
        case ps_gt_line :
          state->cp = path->element.move.point;
          break;
        case ps_gt_curve :
          state->cp = path->element.curve.point3;
          break;
        default :
         for (path = state->path; path; path=path->next)
           if (path->type == ps_gt_move) state->cp = path->element.move.point;
        }
      }
    }
  return ps_e_operationok;
  }


/* ************************************************************************ */
void
draw_trapeze(segments top, int right)
{
  int left = top->X0,
      y1l,
      y2l,
      y1r,
      y2r;

#ifdef VERBOSE
printf("Drawing trapeze : {(%d,%d)-(%d,%d)}-{(%d,%d)-(%d,%d)} between %d and %d\n",
   top->X1,       top->Y1,       top->X2,       top->Y2,
   top->pair->X1, top->pair->Y1, top->pair->X2, top->pair->Y2,
   left, right);
#endif /* VERBOSE */

  y1l = intersectionY(top,       left);
  y2l = intersectionY(top->pair, left);
  y1r = intersectionY(top,       right);
  y2r = intersectionY(top->pair, right);

#if 0
  if (pathout || state->device || currentcache) {   /* Recompute precise Y's */
    }
#endif

  if (!pathout && (state->device || currentcache))
    ps__DoTrapeze(y1l, y2l, y1r, y2r, left, right);
  else {
    pathout = new_element(pathout, ps_gt_move);
    pathout->element.move.point.x = left;
    pathout->element.move.point.y = y1l;
    pathout = new_element(pathout, ps_gt_line);
    pathout->element.move.point.x = right;
    pathout->element.move.point.y = y1r;
    if (y1r != y2r) {                   /* Unuseful vertical right segment ? */
      pathout = new_element(pathout, ps_gt_line);
      pathout->element.move.point.x = right;
      pathout->element.move.point.y = y2r;
      }
    if (y1l != y2l) {                    /* Unuseful vertical left segment ? */
      pathout = new_element(pathout, ps_gt_line);
      pathout->element.move.point.x = left;
      pathout->element.move.point.y = y2l;
      }
    pathout = new_element(pathout, ps_gt_close);
    }
  }

extern ps__path charpath;

/* --------------------********************************-------------------- */
ps__errors
ps__fill()
{
  if (charpath) return ps_e_operationok;
  pathout = NULL;
  if (state->device || currentcache) do_fill(nwmask);
  return ps__newpath();
  }

/* --------------------********************************-------------------- */
ps__errors
ps__eofill()
{
  if (charpath) return ps_e_operationok;
  pathout = NULL;
  if (state->device || currentcache) do_fill(eomask);
  return ps__newpath();
  }

/* --------------------********************************-------------------- */
ps__errors
ps__clip()
{
  ps__path free_element(), begin;

  begin = pathout = new_element(NULL, ps_gt_none);
  do_fill(nwmask);
  ps__newpath();
#if 0
  if (state->path = state->pqueue = free_element(begin))
    for (; state->pqueue->next; state->pqueue = state->pqueue->next);
#else
  free_path(state->clip);
  state->clip = free_element(begin);
#endif
  return ps_e_operationok;
  }

/* --------------------********************************-------------------- */
ps__errors
ps__eoclip()
{
  ps__path free_element(), begin;

  begin = pathout = new_element(NULL, ps_gt_none);
  do_fill(eomask);
  ps__newpath();
#if 0
  if (state->path = state->pqueue = free_element(begin))
    for (; state->pqueue->next; state->pqueue = state->pqueue->next);
#else
  free_path(state->clip);
  state->clip = free_element(begin);
#endif
  return ps_e_operationok;
  }

/* ************************************************************************ */
extern segment  liste[MAX_EDGES];
extern unsigned int nsegments;

/* ************************************************************************ */
void
new_edge(ps__coord from, ps__coord to, int clip)
{
  if ((int)from.x == (int)to.x) return;
  if ((int)from.x  > (int)to.x) {
    liste[nsegments].X1  = to.x,   liste[nsegments].Y1  = to.y;
    liste[nsegments].X2  = from.x, liste[nsegments].Y2  = from.y;
    liste[nsegments].dir = -1;
    }
  else {
    liste[nsegments].X1  = from.x, liste[nsegments].Y1  = from.y;
    liste[nsegments].X2  = to.x,   liste[nsegments].Y2  = to.y;
    liste[nsegments].dir = 1;
    }
  liste[nsegments].dX = liste[nsegments].X2 - liste[nsegments].X1;
  liste[nsegments].dY = liste[nsegments].Y2 - liste[nsegments].Y1;
  liste[nsegments].used = FALSE;
  liste[nsegments++].clip = clip;
  }

/* ************************************************************************ */
void
read_edges(ps__path path, int clip)
{
  extern    void new_edge();
  ps__path  current;
  ps__coord move, here;
  ps_g_type previoustype = ps_gt_close;

  for (current = path; current;
       previoustype = current->type, current = current->next) {
    switch (current->type) {
      case ps_gt_move  :
        if (previoustype != ps_gt_close) new_edge(here, move, clip);
        move = here = current->element.move.point;
        break;
      case ps_gt_line  :
        new_edge(here, current->element.line.point, clip);
        here = current->element.line.point;
        break;
      case ps_gt_close :
        new_edge(here, move, clip);
        here = move;
        break;
      }
    if (nsegments == MAX_EDGES) {
      ps__puts("** Too many fill segments to read them all **");
      previoustype = ps_gt_close;
      break;
      }
    }
  if (previoustype != ps_gt_close) new_edge(here, move, clip);
  }

/* ************************************************************************ */
void
init_fill_stuff()
{
  new_operator("initclip", 0, 0, NONE, ps__initclip);
  new_operator("clippath", 0, 0, NONE, ps__clippath);
  new_operator("fill",     0, 0, NONE, ps__fill);
  new_operator("eofill",   0, 0, NONE, ps__eofill);
  new_operator("clip",     0, 0, NONE, ps__clip);
  new_operator("eoclip",   0, 0, NONE, ps__eoclip);
  }

/* ************************************************************************ */
void
free_fill_stuff()
{
  extern void free_fill_algorithm_stuff();

  free_fill_algorithm_stuff();
  }

