/* ************************************************************************* *
 * PostScript Interpretor                   Fabien LELAQUAIS                 *
 *                                                                           *
 *   Fichier error.c                                                         *
 *      Error handling routine for PSint.                                    *
 *                           Version 2.00 on 16/02/88                        *
 * ************************************************************************* *
 *    This document may be distributed, used, or modified, but can NOT be    *
 *  sold nor incorporated in any way in any product.                         *
 *    Permission is granted to distribute modified versions of that software *
 *  under the condition that this notice remains in every source file.       *
 *    Every alteration of the original files should be marked as such.       *
 *    No warranty is assumed by the author on the concequencies of the use   *
 *  of this software. Any defection of this program is at your own risk,     *
 *  you have to assume the cost of any service, installation or repairs      *
 *  this program could generate.                                             *
 *                                                                           *
 *                          Fabien LELAQUAIS - ESIEE - lelaquaf@apo.esiee.fr *
 * ************************************************************************* */
#include "int.h"
extern ps__object stop_object;

#if APOLLO
#include <math.h>

#ifndef TLOSS
struct exception {
	int type;
	char *name;
	double arg1;
	double arg2;
	double retval;
};

#define	DOMAIN		1
#define	SING		2
#define	OVERFLOW	3
#define	UNDERFLOW	4
#define	TLOSS		5
#define	PLOSS		6
#endif
/*
type :
  DOMAIN     argument domain error
  SING       argument singularity
  OVERFLOW   overflow range error
  UNDERFLOW  underflow range error
  TLOSS      total loss of significance
  PLOSS      partial loss of significance

 */
int
matherr(x)
register struct exception *x;
{
  switch (x->type) {
    case PLOSS :
      printf("** Error PLOSS (%s)\n", x->name);
      printf("** arg = %f, returned : %f\n", x->arg1, x->retval);
      return 1;
    case TLOSS :
      printf("** Error TLOSS (%s)\n", x->name);
      printf("** arg = %f, returned : %f\n", x->arg1, x->retval);
      return 1;
    default :
      printf("** Error %d\n", x->type);
      return 0;
    }
  }
#endif APOLLO

/* ************************************************************************* */
void
process_error(ps__errors error, ps__object object)
{
  ps__printf("[ ");
  switch(error) {
    case ps_e_syntaxerror        :
      ps__printf("Syntax Error");                 break;
    case ps_e_notimplemented     :
      ps__printf("Sorry... Not yet implemented"); break;
    case ps_e_stackunderflow     :
      ps__printf("Stack underflow");              break;
    case ps_e_stackoverflow      :
      ps__printf("Stack overflow");               break;
    case ps_e_dictstackunderflow :
      ps__printf("Dictionnary Stack underflow");  break;
    case ps_e_dictstackoverflow  :
      ps__printf("Dictionnary Stack overflow");   break;
    case ps_e_execstackunderflow :
      ps__printf("Exec Stack underflow");         break;
    case ps_e_execstackoverflow  :
      ps__printf("Exec Stack overflow");          break;
    case ps_e_undefinedresult    :
      ps__printf("Undefined Result");             break;
    case ps_e_undefined          : 
      ps__printf("Undefined");                    break;
    case ps_e_undefinedfilename  :
      ps__printf("Undefined File Name");          break;
     case ps_e_unmatchedmark     :
      ps__printf("Unmatched mark");               break;
    case ps_e_typecheck          :
      ps__printf("Wrong type");                   break;
    case ps_e_nocurrentpoint     :
      ps__printf("No Current Point");             break;
    case ps_e_rangecheck         :
      ps__printf("Range Check");                  break;
    case ps_e_limitcheck         :
      ps__printf("Limit Check");                  break;
    case ps_e_invalidexit        :
      ps__printf("Invalid Exit");                 break;
    case ps_e_invalidfont        :
      ps__printf("Invalid Font");                 break;
    case ps_e_dictfull           :
      ps__printf("Dictionnary full");             break;
    case ps_e_VMerror            :
      ps__printf("Virtual Memory Error");         break;
    case ps_e_IOerror            :
      ps__printf("IO Error");                     break;
    case ps_e_invalidrestore     :
      ps__printf("Invalid Restore");              break;
    case ps_e_invalidfileaccess  :
      ps__printf("Invalid File Access");          break;
    case ps_e_invalidaccess      :
      ps__printf("Invalid Access");               break;
    default                      :
      ps__printf("Unknown Error (%d)", error);
    }
  switch (object.type) {
    case ps_t_operator :
      ps__printf(" in offending operator %s", op_val(object).name);
      break;
    case ps_t_name :
      ps__printf(" parsing name ");
      obfcpy(object);
      break;
    }
  ps__printf(" ]\n");
  PUSH(execstack, stop_object);
  }

#if 0 
Liste des erreurs :
 dictfull
 dictstackoverflow
 dictstackunderflow
 errordict
 execstackoverflow
 handleerror
 interrupt
 invalidaccess
 invalidexit
 invalidfileccess
 invalidfont
 invalidrestore
 ioerror
 limitcheck
 nocurrentpoint
 rangecheck
 stackoverflow
 stackunderflow
 syntaxerror
 timeout
 typecheck
 undefined
 undefinedfilename
 undefinedresult
 unmatchedmark
 unregistred
 VMerror

Dans l'interpreteur ScriptPrinter :
errordict contient les cles suivantes :
/execstackoverflow 
/stackoverflow 
/dictstackunderflow 
/unregistered 
/VMerror 
/syntaxerror 
/invalidexit 
/dictstackoverflow 
/invalidfont 
/nocurrentpoint 
/undefinedresult 
/ioerror 
/invalidrestore 
/timeout 
/undefinedfilename 
undefined 
/handleerror 
interrupt 
/unmatchedmark 
/typecheck 
/invalidfileaccess 
/dictfull 
/stackunderflow 
/invalidaccess 
/rangecheck 
/limitcheck 

chaque cle est associee a la procedure :

{
  /ERROR_NAME {
    `dictionary' exch /errorname exch put
    `dictionary' exch /command   exch put
    `dictionary' /newerror true put
    `dictionary' /command get type /stringtype eq {
      `dictionary' /command get length 128 gt {
        `dictionary' /command get 0 128 getinterval
        `dictionary' exch /command exch put }
        if
      }
    if
    `dictionary' /errorname get /VMerror ne {
      `dictionary' /ostackarray get null eq {
        `dictionary' /estackarray 250 array put
        `dictionary' /ostackarray 500 array put
        `dictionary' /dstackarray 20 array put }
      if count
      `dictionary' /ostackarray get exch 0 exch getinterval astore
      `dictionary' exch /ostack exch put
      `dictionary' /dstack
      `dictionary' /dstackarray get dictstack put `dictionary' /
      estack `dictionary' /estackarray get execstack dup length 2 
      sub 0 exch getinterval put `dictionary' /ostack get
      aload pop }
    if
    `dictionary' /initializing get {handleerror } if
    stop }
  exec }

#endif /* 0 */
