/* ************************************************************************* *
 * PostScript Interpretor                   Fabien LELAQUAIS                 *
 *                                                                           *
 *   Fichier cache.c                                                         *
 *     Font cache routines for PSint                                         *
 *                           Version 3.00 on 24/02/89                        *
 * ************************************************************************* *
 *    This document may be distributed, used, or modified, but can NOT be    *
 *  sold nor incorporated in any way in any product.                         *
 *    Permission is granted to distribute modified versions of that software *
 *  under the condition that this notice remains in every source file.       *
 *    Every alteration of the original files should be marked as such.       *
 *    No warranty is assumed by the author on the concequencies of the use   *
 *  of this software. Any defection of this program is at your own risk,     *
 *  you have to assume the cost of any service, installation or repairs      *
 *  this program could generate.                                             *
 *                                                                           *
 *                          Fabien LELAQUAIS - ESIEE - lelaquaf@apo.esiee.fr *
 * ************************************************************************* */
#include "int.h"
#include "graph.h"

int cachelimit = 10000;     /* Maximum bytes allocated for a cache (100x100) */

ps__cache *caches[MAX_FONTDIRECTORY_SIZE];

extern int       showcharcode;
extern ps__coord showwidth;

/* ************************************************************************* */
ps__cache *
char_is_in_cache()
{
  ps__cache *c;
  extern     ps__object UniqueID;
  double     hash = mat(state->CTM, 0)+
                    mat(state->CTM, 1)+
                    mat(state->CTM, 2)+
                    mat(state->CTM, 3);

/* ATTENTION : se mefier de la notation  XXX_val(fonction()) */
  for (c = caches[font_val(dict_find_key(state->font, UniqueID))];
       c; c = c->next)
    if ((c->charcode  == showcharcode)       &&
        (c->hash      == hash)               &&
        (c->matrix[0] == mat(state->CTM, 0)) &&
        (c->matrix[1] == mat(state->CTM, 1)) &&
        (c->matrix[2] == mat(state->CTM, 2))) break;
  return c;
  }

/* --------------------*********************************-------------------- */
ps__errors
ps__cachestatus()
{
  PUSH(opstack, new_int(0));
  PUSH(opstack, new_int(0));
  PUSH(opstack, new_int(0));
  PUSH(opstack, new_int(0));
  PUSH(opstack, new_int(0));
  PUSH(opstack, new_int(0));
  return PUSH(opstack, new_int(cachelimit));
  }

/* --------------------*********************************-------------------- */
ps__cache *currentcache = NULL;
extern ps__path charpath;
int    lowcachex, lowcachey;
ps__errors
ps__setcachedevice(ps__object wx,  ps__object wy,
                   ps__object llx, ps__object lly,
                   ps__object urx, ps__object ury)
{
  int        z, xmin, ymin, xmax, ymax, fid;
  ps__cache *c;
  extern     ps__object UniqueID, FontMatrix;          /* Declared in font.c */
  ps__object fontm;

                         /* Compute character's bounding box in device space */
  xmin = xmax = mat(state->CTM, 0)*to_real(llx)
               +mat(state->CTM, 2)*to_real(lly)+mat(state->CTM, 4);
  ymin = ymax = mat(state->CTM, 1)*to_real(llx)
               +mat(state->CTM, 3)*to_real(lly)+mat(state->CTM, 5);
  if ((z=mat(state->CTM, 0)*to_real(llx)
        +mat(state->CTM, 2)*to_real(ury)+mat(state->CTM, 4)) > xmax) xmax = z;
  if (z < xmin) xmin = z;
  if ((z=mat(state->CTM, 1)*to_real(llx)
        +mat(state->CTM, 3)*to_real(ury)+mat(state->CTM, 5)) > ymax) ymax = z;
  if (z < ymin) ymin = z;
  if ((z=mat(state->CTM, 0)*to_real(urx)
        +mat(state->CTM, 2)*to_real(ury)+mat(state->CTM, 4)) > xmax) xmax = z;
  if (z < xmin) xmin = z;
  if ((z=mat(state->CTM, 1)*to_real(urx)
       +mat(state->CTM, 3)*to_real(ury)+mat(state->CTM, 5)) > ymax) ymax = z;
  if (z < ymin) ymin = z;
  if ((z=mat(state->CTM, 0)*to_real(urx)
        +mat(state->CTM, 2)*to_real(lly)+mat(state->CTM, 4)) > xmax) xmax = z;
  if (z < xmin) xmin = z;
  if ((z=mat(state->CTM, 1)*to_real(urx)
        +mat(state->CTM, 3)*to_real(lly)+mat(state->CTM, 5)) > ymax) ymax = z;
  if (z < ymin) ymin = z;
  showwidth.x = mat(state->CTM, 0)*to_real(wx)+
                mat(state->CTM, 2)*to_real(wy);
  showwidth.y = mat(state->CTM, 1)*to_real(wx)+
                mat(state->CTM, 3)*to_real(wy);
                       /* check if it goes into cache...                   */
  if (!charpath &&
      ((xmax-xmin+1)*(ymax-ymin+1) <= (cachelimit<<3)) &&
      (c = (ps__cache *)ps_alloc(sizeof(ps__cache)))) {
    c->next = caches[fid = font_val(dict_find_key(state->font, UniqueID))];
    caches[fid] = c;
    c->charcode    = showcharcode;
    c->device      = ps__CreateCache(xmax-xmin+1, ymax-ymin+1);
    c->cx          = xmin-mat(state->CTM, 4);
    c->cy          = ymin-mat(state->CTM, 5);
 /* state->CTM est deja modifiee pour que l'on se retrouve dans l'espace
    du caractere...Mais, il faut la recaluler car il a pu y avoir des
    scaling entre le debut de BuildChar et le setcachedevice       */
    fontm = dict_find_key(state->font, FontMatrix);
    c->wx = showwidth.x;
    c->wy = showwidth.y;
    c->hash  = (c->matrix[0] = mat(fontm, 0)*mat(state->next->CTM, 0) +
                               mat(fontm, 1)*mat(state->next->CTM, 2));
    c->hash += (c->matrix[1] = mat(fontm, 0)*mat(state->next->CTM, 1) +
                               mat(fontm, 1)*mat(state->next->CTM, 3));
    c->hash += (c->matrix[2] = mat(fontm, 2)*mat(state->next->CTM, 0) +
                               mat(fontm, 3)*mat(state->next->CTM, 2));
    c->hash += (c->matrix[3] = mat(fontm, 2)*mat(state->next->CTM, 1) +
                               mat(fontm, 3)*mat(state->next->CTM, 3));
    currentcache = c;
    lowcachex    = xmin;
    lowcachey    = ymin;
    arr_ob(state->CTM, 4) = new_real(mat(state->CTM, 4) - lowcachex);
    arr_ob(state->CTM, 5) = new_real(mat(state->CTM, 5) - lowcachey);
    }
  return ps_e_operationok;
  }

/* --------------------*********************************-------------------- */
ps__errors
ps__setcachelimit(ps__object num)
{
  cachelimit = int_val(num);
  return ps_e_operationok;
  }

/* ************************************************************************* */
void
init_cache_stuff()
{
  short loop;

  for (loop=0; loop<MAX_FONTDIRECTORY_SIZE; loop++) caches[loop] = NULL;
  new_operator("cachestatus",     0, 7, NONE, ps__cachestatus);
  new_operator("setcachedevice",  6, 0, "ir.ir.ir.ir.ir.ir",
                                        ps__setcachedevice);
  new_operator("setcachelimit",   1, 0, "i",
                                        ps__setcachelimit);
  }

/* ************************************************************************* */
void
free_cache_stuff()
{
  extern void ps_free();
  short       loop;
  ps__cache  *c;

  for (loop=0; loop<MAX_FONTDIRECTORY_SIZE; loop++)
    while (caches[loop]) {
      c            = caches[loop]->next;
      ps__KillCache(caches[loop]->device);
      ps_free(caches[loop]);
      caches[loop] = c;
      }
  }
