/* ************************************************************************* *
 * PostScript Interpretor                   Fabien LELAQUAIS                 *
 *                                                                           *
 *   Fichier X.c                                                             *
 *    Create PostScript Interpretor routines so that X workstations can      *
 *  manage all graphic routines and windowing.                               *
 *                           Version 3.50 on 19/02/90                        *
 *                                                                           *
 *  NOT YET OPERATIONNAL... I'M WORKING ON IT... IT'S JUST AN EXAMPLE...     *
 *                                                                           *
 * ************************************************************************* *
 *    This document may be distributed, used, or modified, but can NOT be    *
 *  sold nor incorporated in any way in any product.                         *
 *    Permission is granted to distribute modified versions of that software *
 *  under the condition that this notice remains in every source file.       *
 *    Every alteration of the original files should be marked as such.       *
 *    No warranty is assumed by the author on the concequencies of the use   *
 *  of this software. Any defection of this program is at your own risk,     *
 *  you have to assume the cost of any service, installation or repairs      *
 *  this program could generate.                                             *
 *                                                                           *
 *                          Fabien LELAQUAIS - ESIEE - lelaquaf@apo.esiee.fr *
 * ************************************************************************* */
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <sys/time.h>
#include <signal.h>
#include "int.h"
#include "graph.h"

extern int errno;
#define XC(Xfonc, m) {if (!Xfonc) \
                        printf("** Status %d (%s) **\n", errno, m);}


Display *MyDisplay;
int      MyScreen;
Window   MyWindow;
GC       MyGC;
Colormap MyCmap;
int      MyDepth;

/* ************************************************************************* */
void *
ps__CreateWindow(int sx, int sy)
{
  Window         W;
  unsigned short border_width = 2;
  XGCValues      vals;

  if (MyWindow) ps__KillWindow((void *)MyWindow);
  if (!(W = XCreateSimpleWindow(MyDisplay, RootWindow(MyDisplay, MyScreen),
              (short)0, (short)0, (short)sx, (short)sy, border_width,
              BlackPixel(MyDisplay, MyScreen),
              WhitePixel(MyDisplay, MyScreen)))) return NULL;
  XMapRaised(MyDisplay, W);
  XStoreName(MyDisplay, W, "PostScript Output");/* Name the window */
  XSetWindowColormap(MyDisplay, W, MyCmap);
  MyGC = XCreateGC(MyDisplay, W, 0, &vals);
  XFlush(MyDisplay);
  XSync(MyDisplay, False);
  MyWindow = W;
  return (void *)W;
  }

/* ************************************************************************* */
void
ps__KillWindow(void *W)
{
  if ((Window)W) {
    XFreeGC(MyDisplay, MyGC);
    XDestroyWindow(MyDisplay, (Window)W);
    XFlush(MyDisplay);
    }
  }

/* ************************************************************************* */
void *
ps__CreateCache(int sx, int sy)
{
  }

/* ************************************************************************* */
void
ps__CloseCache()
{
  }

/* ************************************************************************* */
void
ps__KillCache(void *Nothing_For_The_Moment)
{
  }

/* ************************************************************************* */
void
setXColor()
{
  XColor color;

  switch (MyDepth) {
    case 1 :
      XSetForeground(MyDisplay, MyGC, (to_real(state->gray)>.5)
                                       ? WhitePixel(MyDisplay, MyScreen)
                                       : BlackPixel(MyDisplay, MyScreen));
      break;
    case 4 :
      XSetForeground(MyDisplay, MyGC, (long)(15*(1-to_real(state->gray))));
      break;
    case 8 :
      XSetForeground(MyDisplay, MyGC, (long)(255*(1-to_real(state->gray))));
      break;
    }
  }

/* ************************************************************************* */
void
ps__DoCache(ps__cache *c, ps__coord pos)
{
  }

/* ************************************************************************* */
void
ps__Erase()
{
  XClearWindow(MyDisplay, MyWindow);
  XFlush(MyDisplay);
  }

/* ************************************************************************* */
void
ps__DoTrapeze(int ul, int ll, int ur, int lr, int left, int right)
{
  XPoint Points[4];

  setXColor();
  Points[0].x = left;  Points[0].y = ll;
  Points[1].x = left;  Points[1].y = ul;
  Points[2].x = right; Points[2].y = ur;
  Points[3].x = right; Points[3].y = lr;
  XFillPolygon(MyDisplay, MyWindow, MyGC,
               Points, 4, Convex, CoordModeOrigin);
  XFlush(MyDisplay);
  }

/* ************************************************************************* */
void
ps__DoLine(ps__coord p0, ps__coord p1)
{
  setXColor();
  XDrawLine(MyDisplay, MyWindow, MyGC,
            (int)p0.x, (int)p0.y, (int)p1.x, (int)p1.y);
  XFlush(MyDisplay);
  }

/* ************************************************************************* */
void
ps__WritePixels(int x, int y, int length, unsigned char *buf)
{
  }

/* ************************************************************************* */
init_device_stuff()
{
  if (!(MyDisplay = XOpenDisplay(NULL))) {
    puts("OpenDisplay failed. Not a X station ??");
    return -1;
    }
  MyScreen = DefaultScreen(MyDisplay);
  MyDepth  = DisplayPlanes(MyDisplay, MyScreen);
  if (MyDepth != 1) { /* If not a monochrome display */
    XColor color;
    short  i;

    MyCmap = DefaultColormap(MyDisplay, MyScreen);
    for (i=0; i<(1<<MyDepth); i++) {
      color.red    =
      color.blue   =
      color.green  = i<<(16-MyDepth);
      XAllocColor(MyDisplay, MyCmap, &color);
      }
    }
  return 0;
  }

/* ************************************************************************* */
void
free_device_stuff()
{
  if (MyGC)      XFreeGC(MyGC);
  if (MyDisplay) XCloseDisplay(MyDisplay);
  }

