/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/* Rexec program */

char rexec_rcsid[] = "$Revision: 1.34 $$Date: 89/01/31 09:55:46 $$Source: /usr/fsys/bullwinkle/b/isis/distrib/util/RCS/rexec.c,v $";
#include "isis.h"
#include "rexec.h"
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#if(SUN4)
#include "fork.h"
#endif

int     rexec_req();

int     CLIENT_PORT;
FILE    *rfile;

main(argc, argv)
  char **argv;
  {
        int reaper();
        unlink("rexec.log");
        if((rfile = fopen("rexec.log", "w", 0666)) == (FILE*)0)
            rfile = fopen("/dev/null", "w", 0666);
        while(argc-- > 1)
            switch(**++argv)
            {
              default:
              badarg:
                panic("Bad argument: <%s>\n", *argv);

              case '0': case '1': case '2': case '3': case '4':
              case '5': case '6': case '7': case '8': case '9':
                CLIENT_PORT = atoi(*argv);
                continue;
            }

        my_process_id = REXEC;
        isis_init(CLIENT_PORT);
        isis_task(reaper, "reaper");
#ifndef HPUX
        isis_signal(SIGCHLD, reaper);
#else
        isis_signal(SIGCLD, reaper);
#endif
        isis_entry(REXEC_REQ, rexec_req, "rexec_req", 0);
        /* Now enter ISIS main loop */
        isis_mainloop(0);
  }

reaper()
  {
        (void)wait(0);
  }

static char *args[MAX_ARGS], *env[MAX_ENV];

rexec_req(mp)
  register message *mp;
  {
        extern errno;
        address pname;
        char *prog = msg_getfield(mp, RE_PROG, 1, (int*)0);
        char *user = msg_getfield(mp, RE_USER, 1, (int*)0);
        char *passwd = msg_getfield(mp, RE_PASSWD, 1, (int*)0);
        register n, na, ne;

        pname = ADDRESS(my_site_no, my_site_incarn, 0, 0);
        na = msg_getfields(mp, RE_ARGS, args, (int*)0, MAX_ARGS-1);
        args[na] = 0;
        ne = msg_getfields(mp, RE_ENV, env, (int*)0, MAX_ENV-1);
        env[ne] = 0;
        fprintf(rfile, "rexec %d/%d: execve <%s> args < ", my_site_no, my_site_incarn, prog);
        for(n = 0; n < na; n++)
            fprintf(rfile, "%s ", args[n]);
        fprintf(rfile, "> env < ");
        for(n = 0; n < ne; n++)
            fprintf(rfile, "%s ", env[n]);
        fprintf(rfile, ">\n");
        fflush(rfile);
        if((pname.entry = runable(prog)) == 0 && (pname.process = fork()) == 0)
        {
            extern isis_socket;
            close(isis_socket);
            close(fileno(rfile));
            execve(prog, args, env);
            fprintf(rfile, "... rexec failed errno %d\n", errno);
            fprintf(stderr, "<isis-rexec> unable to execute ");
            perror(prog);
            exit(0);
        }
        else if(pname.entry != 0)
        {
            fprintf(rfile, "... rexec failed errno %d\n", errno);
            errno = pname.entry;
            fprintf(stderr, "<isis-rexec> unable to execute ");
            perror(prog);
        }
        if(pname.process == -1)
        {
            perror("fork");
            pname = NULLADDRESS;
        }
        fprintf(rfile, "... address is %d/%d:%d.0\n", pname.site, pname.incarn, pname.process, pname.entry);
        reply(mp, "%a", pname);
  }

runable(prog)
  char *prog;
  {
        struct stat s;
        register mode;
        if(prog == 0)
            return(EFAULT);
        if(stat(prog, &s) == -1)
            return(errno);
        mode = s.st_mode;
        if((mode&S_IFMT) != S_IFREG)
            return(EACCES);
        if((mode&S_ISUID) && (mode&S_IEXEC) == 0)
            return(EACCES);
        if((mode&S_ISGID) && (mode&(S_IEXEC>>3)) == 0)
            return(EACCES);
        if((mode&(S_IEXEC>>6)) == 0)
            return(EACCES);
        return(0);
  }
