/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
char prstat_rcsid[] = "$Revision: 1.34 $$Date: 89/01/31 09:55:43 $$Source: /usr/fsys/bullwinkle/b/isis/distrib/util/RCS/prstat.c,v $";
#include "isis.h"
#include <time.h>
#include "pr_stats.h"

int     rate = 10;
int     isis_portno;

#define pgtok(a)        ((a)/(1024/NBPG))

main(argc, argv)
  char **argv;
  {
        int isis_portno = 0, main_loop();
        while(--argc)
        {
            register n = atoi(*++argv);
            if(n > 0 && n < 300)
                rate = n;
            else if(n > 0 && n < 4096)
                isis_portno = n;
            else
                panic("Usage: prstat [port-no] rate");
        }
        isis_init(isis_portno);
        isis_mainloop(main_loop);
  }

struct isis_stats old_sbuf, new_sbuf, dt;

main_loop()
  {
        register count = 0;
        isis_start_done();
        printf("NT = tasks running now.  FORK = forks this cycle.  CTXT = context switches\n");
        printf("C+ = cbcasts started.  C- = cbcasts finished.  Same for A+, A-, G+, G\n");
        printf("GA = gbcast aborts.  FAN = average broadcast fanout\n");
        printf("CP = cbcast packets generated.  CM = messages they contained.\n");
        printf("CR = local cbcast deliveries.  DP = cbcast dups discarded.\n");
        printf("AS = astore rounds run.  SYS = messages client->system\n");
        printf("REP = messages system->clients.  FA = cached view faults.  LK = namespace lookups\n");
        printf("VC = View changes.  IS = Intersite packets sent.  IG = Intersite received.\n");
        printf("IM = Valid non-dup non-ack messages. NL, ND = Local/total deletable astore entries\n");
        print("SZ = Size of the protocols process in virtual k-bytes.  PF = page faults\n");
        printf("UCPU, SCPU: User and System CPU time in milliseconds.  %%: CPU percent usage by ISIS\n");
        pr_stats(&old_sbuf);
        old_sbuf.is_time -= rate;
        forever
        {
            if(count++ % 30 == 0)
                phdr();
            pr_stats(&new_sbuf);
            pstats();
            old_sbuf = new_sbuf;
            if(rate)
                sleep(rate);
        }
  }

phdr()
  {
        printf("\n  TIME   NT FORK CTXT  C+  C- A+ A- G+ G- GA FAN  CP  CM  CR  DP AS SYS REP FA LK VC  IS  IG  IM NL ND   SZ PF UCPU SCPU\n");
  }

pstats()
  {
        register n, pct, fanout, fanouth, fanoutl;
        int hr, mn, sec;
        register struct tm *tp;
        for(n = 0; n < S_NSTATS; n++)
            dt.is_stats[n] = new_sbuf.is_stats[n]-old_sbuf.is_stats[n];
        if((dt.is_time = new_sbuf.is_time-old_sbuf.is_time) < rate)
            panic("impossible dt_istime of %d = %d-%d\n", dt.is_time, new_sbuf.is_time, old_sbuf.is_time);
        pct = dt.is_ucpu = (new_sbuf.is_ucpu-old_sbuf.is_ucpu);
        pct += dt.is_scpu = (new_sbuf.is_scpu-old_sbuf.is_scpu);
        pct /= dt.is_time*10;
        if(fanout = dt.is_stats[S_CBSTART]+dt.is_stats[S_ABSTART]+dt.is_stats[S_GBSTART])
            fanout = dt.is_stats[S_FANOUT]*10/fanout;
        fanouth = fanout/10;
        fanoutl = fanout%10;
        tp = localtime(&new_sbuf.is_time);
        printf("%.2d:%.2d.%.2d%3d%5d%5d%4d%4d%3d%3d%3d%3d%3d%2d.%1d",
            tp->tm_hour, tp->tm_min, tp->tm_sec,
            new_sbuf.is_ntasks,
            dt.is_stats[S_NFORK],
            dt.is_stats[S_NSWTCH],
            dt.is_stats[S_CBSTART],
            dt.is_stats[S_CBDONE],
            dt.is_stats[S_ABSTART],
            dt.is_stats[S_ABDONE],
            dt.is_stats[S_GBSTART],
            dt.is_stats[S_GBDONE] - dt.is_stats[S_GBABORTS],
            dt.is_stats[S_GBABORTS],
            fanouth, fanoutl);
        printf("%4d%4d%4d%4d%3d%4d%4d%3d%3d%3d%4d%4d%4d%3d%3d%5d%3d%5d%5d%4d%%\n",
            dt.is_stats[S_CBSENT],
            dt.is_stats[S_CBCOUNT],
            dt.is_stats[S_CBDELIV],
            dt.is_stats[S_CBDUP],
            dt.is_stats[S_ASROUNDS],
            dt.is_stats[S_SYSCALLS],
            dt.is_stats[S_CLSENT],
            dt.is_stats[S_CFAULT],
            dt.is_stats[S_LOOKUP],
            dt.is_stats[S_VCHANGE],
            dt.is_stats[S_ISENT],
            dt.is_stats[S_IGOT],
            dt.is_stats[S_IMSGS], 
            new_sbuf.is_nlocdelete,
            new_sbuf.is_ndelete,
            0,
            0,
            dt.is_ucpu,
            dt.is_scpu,
            pct);
        fflush(stdout);
  }

pr_stats(buf)
  struct isis_stats *buf;
  {
        register message *mp = msg_newmsg();
        isis(PR_STATS, mp, buf, sizeof(isis_stats));
        msg_delete(mp);
  }
