/*
 *      ISIS release V1.1, Dec. 1988
 *      Export restrictions apply
 */
/*
 *      Log Manager: Initialization code for log manager at
 *                   time of ISIS startup.
 */

char lmgr_rcsid[] = "$Revision: 1.34 $$Date: 89/01/31 09:55:02 $$Source: /usr/fsys/bullwinkle/b/isis/distrib/util/RCS/lmgr.c,v $";
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <sys/errno.h>
#include "isis.h"

char *malloc();

main(argc, argv)
  int argc;
  char *argv[];
{
        int client_port, path_stat, mk_stat;
        int old_mask;
        char *isis_path, *logs_path, *rm_cmd;
        struct stat buf;

        client_port = 0;

        if (argc != 2) {
                fprintf(stderr, "usage: %s port\n", argv[0]);
                exit(-1); }

        client_port = atoi(argv[1]);
        if (client_port == 0) {
                fprintf(stderr, "usage: %s port\n", argv[0]);
                exit(-1); }

        isis_init(client_port);

        /* Set the ISIS directory path name and logs directory path name */

        isis_path = malloc(strlen(isis_dir) + 1);
        strcpy(isis_path, isis_dir);

        logs_path = malloc(strlen(isis_path) + sizeof(LOG_SUBDIR) + 2);
        strcpy(logs_path, isis_path);
        strcat(logs_path, "/");
        strcat(logs_path, LOG_SUBDIR);

        /* Check to make sure that the ISIS directory exists */

        path_stat = stat(isis_path, &buf);
        if (path_stat != 0) {
                perror("Log Manager: ISIS directory cannot be accessed");
                panic("Log Manager: Fatal Error"); }

        /* Check to make sure that the ISIS logs directory exists.
           If it does not, then create it. */

        path_stat = stat(logs_path, &buf);
        if ((path_stat != 0) && (errno != ENOENT)) {
                perror("Log Manager: ISIS logs directory cannot be accessed");
                panic("Log Manager: Fatal Error"); }
        if ((path_stat != 0) && (errno == ENOENT)) {
                old_mask = umask(0);
                mk_stat = mkdir(logs_path, 0777);
                umask(old_mask);
                if (mk_stat != 0) {
                        perror("Log Manager: Can't create ISIS logs directory");
                        panic("Log Manager: Fatal Error"); }
                printf("Log Manager: Created ISIS logs directory\n"); }

        /* Remove temporary log files */

        rm_cmd = malloc(strlen(logs_path) + sizeof(LOG_TSPEC) + 10);
        strcpy(rm_cmd, "/bin/rm ");
        strcat(rm_cmd, logs_path);
        strcat(rm_cmd, "/");
        strcat(rm_cmd, LOG_TSPEC);
        system(rm_cmd);

        printf("Log Manager: Startup Completed\n");
}

